/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Comparator;
import org.apache.log4j.Category;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.common.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeComparator
implements Comparator<Range> {
    Category log = ThreadCategory.getInstance(this.getClass());

    @Override
    public int compare(Range rng1, Range rng2) {
        long compared = 0L;
        try {
            long range1Begin = InetAddressUtils.toIpAddrLong((InetAddress)InetAddress.getByName(rng1.getBegin()));
            long range2Begin = InetAddressUtils.toIpAddrLong((InetAddress)InetAddress.getByName(rng2.getBegin()));
            compared = range1Begin - range2Begin;
        }
        catch (UnknownHostException e) {
            this.log.error((Object)"compare: Exception sorting ranges.", (Throwable)e);
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        return (int)compared;
    }
}

