/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.MergeableSpecific;
import org.opennms.netmgt.config.RangeComparator;
import org.opennms.netmgt.config.common.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MergeableRange
implements Comparable<Range> {
    private Range m_range;
    private RangeComparator m_comparator;
    private final MergeableSpecific m_first;
    private final MergeableSpecific m_last;

    public MergeableRange(Range range) {
        this.m_range = range;
        this.m_comparator = new RangeComparator();
        this.m_first = new MergeableSpecific(range.getBegin());
        this.m_last = new MergeableSpecific(range.getEnd());
    }

    @Override
    public int compareTo(Range range) {
        return this.m_comparator.compare(this.getRange(), range);
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj == null) {
            equals = false;
        } else if (obj instanceof Range) {
            equals = this.equals((Range)obj);
        }
        return equals;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(MergeableRange range) {
        boolean equals = false;
        if (this.getFirst() == range.getFirst() && this.getLast() == range.getLast()) {
            equals = true;
        }
        return equals;
    }

    public boolean equals(Range range) {
        return this.equals(new MergeableRange(range));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Range getRange() {
        Range range = this.m_range;
        synchronized (range) {
            return this.m_range;
        }
    }

    public boolean coversSpecific(String spec) {
        boolean covers = false;
        if (this.getFirst().compareTo(spec) <= 0 && this.getLast().compareTo(spec) >= 0) {
            covers = true;
        }
        return covers;
    }

    public boolean overlapsBegin(Range rng) {
        boolean overlaps = false;
        if (this.m_first.compareTo(rng.getBegin()) < 0 && this.m_last.compareTo(rng.getBegin()) >= 0 && this.m_last.compareTo(rng.getEnd()) <= 0) {
            overlaps = true;
        }
        return overlaps;
    }

    public boolean withInRange(Range rng) {
        boolean within = false;
        if (this.m_first.compareTo(rng.getBegin()) >= 0 && this.m_last.compareTo(rng.getEnd()) <= 0) {
            within = true;
        }
        return within;
    }

    public boolean overlapsEnd(Range rng) {
        boolean overlaps = false;
        if (this.m_first.compareTo(rng.getBegin()) >= 0 && this.m_first.compareTo(rng.getEnd()) <= 0 && this.m_last.compareTo(rng.getEnd()) > 0) {
            overlaps = true;
        }
        return overlaps;
    }

    public boolean eclipses(Range rng) {
        boolean eclipses = false;
        if (this.m_first.compareTo(rng.getBegin()) <= 0 && this.m_last.compareTo(rng.getEnd()) >= 0) {
            eclipses = true;
        }
        return eclipses;
    }

    public boolean isAdjacentToBegin(Range nextRange) {
        boolean adjacent = false;
        if (this.m_last.compareTo(nextRange.getBegin()) == -1) {
            adjacent = true;
        }
        return adjacent;
    }

    public boolean isAdjacentToEnd(Range nextRange) {
        boolean adjacent = false;
        if (this.m_first.compareTo(nextRange.getEnd()) == 1) {
            adjacent = true;
        }
        return adjacent;
    }

    protected Range removeSpecificFromRange(String spec) {
        if (!this.coversSpecific(spec)) {
            throw new IllegalArgumentException("Specific: " + spec + ", doesn't effect range: ");
        }
        MergeableSpecific specific = new MergeableSpecific(spec);
        Range newRange = null;
        if (specific.getValue() == this.getFirst().getValue()) {
            this.getRange().setBegin(InetAddressUtils.toIpAddrString((long)(specific.getValue() + 1L)));
        } else if (specific.getValue() == this.getLast().getValue()) {
            this.getRange().setEnd(InetAddressUtils.toIpAddrString((long)(specific.getValue() - 1L)));
        } else {
            newRange = new Range();
            newRange.setBegin(InetAddressUtils.toIpAddrString((long)(specific.getValue() + 1L)));
            newRange.setEnd(this.getRange().getEnd());
            this.getRange().setEnd(InetAddressUtils.toIpAddrString((long)(specific.getValue() - 1L)));
        }
        return newRange;
    }

    public RangeComparator getComparator() {
        return this.m_comparator;
    }

    public MergeableSpecific getFirst() {
        return this.m_first;
    }

    public MergeableSpecific getLast() {
        return this.m_last;
    }
}

