/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ClosableDataSource;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.config.opennmsDataSources.Param;
import org.opennms.netmgt.dao.castor.CastorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C3P0ConnectionFactory
implements ClosableDataSource {
    private ComboPooledDataSource m_pool;

    protected C3P0ConnectionFactory(InputStream stream, String dsName) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        this.log().info((Object)"C3P0ConnectionFactory: setting up data sources from input stream.");
        JdbcDataSource ds = C3P0ConnectionFactory.marshalDataSourceFromConfig(stream, dsName);
        this.initializePool(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected C3P0ConnectionFactory(Reader rdr, String dsName) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        this.log().info((Object)"C3P0ConnectionFactory: setting up data sources from reader argument.");
        JdbcDataSource ds = C3P0ConnectionFactory.marshalDataSourceFromConfig(rdr, dsName);
        this.initializePool(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected C3P0ConnectionFactory(String configFile, String dsName) throws IOException, MarshalException, ValidationException, PropertyVetoException, SQLException {
        FileInputStream fileInputStream = new FileInputStream(configFile);
        this.log().info((Object)("C3P0ConnectionFactory: setting up data sources from:" + configFile));
        try {
            JdbcDataSource ds = C3P0ConnectionFactory.marshalDataSourceFromConfig(fileInputStream, dsName);
            this.initializePool(ds);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    public static JdbcDataSource marshalDataSourceFromConfig(InputStream stream, String dsName) throws MarshalException, ValidationException {
        DataSourceConfiguration dsc = CastorUtils.unmarshal(DataSourceConfiguration.class, stream);
        return C3P0ConnectionFactory.validateDataSourceConfiguration(dsName, dsc);
    }

    public static JdbcDataSource marshalDataSourceFromConfig(Reader rdr, String dsName) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        DataSourceConfiguration dsc = CastorUtils.unmarshal(DataSourceConfiguration.class, rdr);
        return C3P0ConnectionFactory.validateDataSourceConfiguration(dsName, dsc);
    }

    private static JdbcDataSource validateDataSourceConfiguration(String dsName, DataSourceConfiguration dsc) {
        for (JdbcDataSource jdbcDs : dsc.getJdbcDataSourceCollection()) {
            if (!jdbcDs.getName().equals(dsName)) continue;
            return jdbcDs;
        }
        throw new IllegalArgumentException("C3P0ConnectionFactory: DataSource: " + dsName + " is not defined.");
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void initializePool(JdbcDataSource ds) throws PropertyVetoException, SQLException {
        this.m_pool = new ComboPooledDataSource();
        this.m_pool.setPassword(ds.getPassword());
        this.m_pool.setUser(ds.getUserName());
        this.m_pool.setJdbcUrl(ds.getUrl());
        this.m_pool.setDriverClass(ds.getClassName());
        Properties props = new Properties();
        for (Param p : ds.getParamCollection()) {
            props.put(p.getName(), p.getValue());
        }
        if (!props.isEmpty()) {
            this.m_pool.setProperties(props);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_pool.getConnection();
    }

    public ComboPooledDataSource getPool() {
        return this.m_pool;
    }

    public void setPool(ComboPooledDataSource pool) {
        this.m_pool = pool;
    }

    public String getUrl() {
        return this.m_pool.getJdbcUrl();
    }

    public void setUrl(String url) {
        this.m_pool.setJdbcUrl(url);
    }

    public String getUser() {
        return this.m_pool.getUser();
    }

    public void setUser(String user) {
        this.m_pool.setUser(user);
    }

    public DataSource getDataSource() {
        return this.m_pool;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.m_pool.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_pool.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_pool.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_pool.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_pool.getLoginTimeout();
    }

    @Override
    public void close() throws SQLException {
        this.log().info((Object)"Closing c3p0 pool");
        this.m_pool.close();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

