/*
 * This file is part of the OpenNMS(R) Application.
 *
 * OpenNMS(R) is Copyright (C) 2006 The OpenNMS Group, Inc.  All rights reserved.
 * OpenNMS(R) is a derivative work, containing both original code, included code and modified
 * code that was published under the GNU General Public License. Copyrights for modified
 * and included code are below.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * Modifications:
 *
 * 2008 Feb 15: Pass the newly required description argument to our super's constructor. - dj@opennms.org
 * 2007 Apr 08: Switch to use Spring Resources instead of File for the
 *              configuration files, since this is what FileReloadContainer
 *              now uses. - dj@opennms.org
 * 2007 Apr 07: Reorganize a bit.  Close Readers in the same method that causes
 *              them to be opened as suggested by brozow@. - dj@opennms.org 
 *
 * Original code base Copyright (C) 1999-2001 Oculan Corp.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * For more information contact:
 *      OpenNMS Licensing       <license@opennms.org>
 *      http://www.opennms.org/
 *      http://www.opennms.com/
 */
package org.opennms.netmgt.dao.castor;

import java.util.Map;

import org.opennms.netmgt.config.surveillanceViews.SurveillanceViewConfiguration;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.opennms.netmgt.config.surveillanceViews.Views;
import org.opennms.netmgt.dao.SurveillanceViewConfigDao;

public class DefaultSurveillanceViewConfigDao extends AbstractCastorConfigDao<SurveillanceViewConfiguration, SurveillanceViewConfig> implements SurveillanceViewConfigDao {
    public DefaultSurveillanceViewConfigDao() {
        super(SurveillanceViewConfiguration.class, "surveillance view configuration");
    }
    
    @Override
    public SurveillanceViewConfig translateConfig(SurveillanceViewConfiguration castorConfig) {
        return new SurveillanceViewConfig(castorConfig);
    }
    
    public View getView(String viewName) {
        return getContainer().getObject().getViewsMap().get(viewName);
    }
    
    /**
     * Use this method to get the generated Views class generated by the XSD.
     */
    public Views getViews() {
        return getContainer().getObject().getConfig().getViews();
    }

    /**
     * Use this method to get a Map of view names to marshalled classes based on the generated View class
     * from the XSD.
     * @return <code>Map</> of View classes.
     */
    public Map<String, View> getViewMap() {
        return getContainer().getObject().getViewsMap();
    }

    public View getDefaultView() {
        String defaultView = getContainer().getObject().getConfig().getDefaultView();
        return getView(defaultView);
    }

}
