/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.opennms.netmgt.dao.support.MockResourceType;
import org.opennms.netmgt.dao.support.PropertiesGraphDao;
import org.opennms.netmgt.model.AdhocGraphType;
import org.opennms.netmgt.model.ExternalValueAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.PrefabGraphType;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.FileAnticipator;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesGraphDaoTest
extends TestCase {
    private static final Map<String, Resource> s_emptyMap = new HashMap<String, Resource>();
    static final String s_prefab = "command.prefix=foo\noutput.mime=foo\n\nreports=mib2.HCbits, mib2.bits, mib2.discards\n\nreport.mib2.HCbits.name=Bits In/Out\nreport.mib2.HCbits.columns=ifHCInOctets,ifHCOutOctets\nreport.mib2.HCbits.type=interface\nreport.mib2.HCbits.externalValues=ifSpeed\nreport.mib2.HCbits.suppress=mib2.bits\nreport.mib2.HCbits.command=--title=\"Bits In/Out (High Speed)\" \\\n DEF:octIn={rrd1}:ifHCInOctets:AVERAGE \\\n DEF:octOut={rrd2}:ifHCOutOctets:AVERAGE \\\n CDEF:bitsIn=octIn,8,* \\\n CDEF:bitsOut=octOut,8,* \\\n CDEF:totBits=octIn,octOut,+,8,* \\\n AREA:totBits#00ff00:\"Total\" \\\n GPRINT:totBits:AVERAGE:\" Avg  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:bitsIn#0000ff:\"Bits In\" \\\n GPRINT:bitsIn:AVERAGE:\" Avg  \\\\: %8.2lf %s\" \\\n GPRINT:bitsIn:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:bitsIn:MAX:\"Max  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:bitsOut#ff0000:\"Bits Out\" \\\n GPRINT:bitsOut:AVERAGE:\"Avg  \\\\: %8.2lf %s\" \\\n GPRINT:bitsOut:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:bitsOut:MAX:\"Max  \\\\: %8.2lf %s\\\\n\"\n\nreport.mib2.bits.name=Bits In/Out\nreport.mib2.bits.columns=ifInOctets,ifOutOctets\nreport.mib2.bits.type=interface\nreport.mib2.bits.externalValues=ifSpeed\nreport.mib2.bits.command=--title=\"Bits In/Out\" \\\n DEF:octIn={rrd1}:ifInOctets:AVERAGE \\\n DEF:octOut={rrd2}:ifOutOctets:AVERAGE \\\n CDEF:bitsIn=octIn,8,* \\\n CDEF:bitsOut=octOut,8,* \\\n CDEF:totBits=octIn,octOut,+,8,* \\\n AREA:totBits#00ff00:\"Total\" \\\n GPRINT:totBits:AVERAGE:\" Avg  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:bitsIn#0000ff:\"Bits In\" \\\n GPRINT:bitsIn:AVERAGE:\" Avg  \\\\: %8.2lf %s\" \\\n GPRINT:bitsIn:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:bitsIn:MAX:\"Max  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:bitsOut#ff0000:\"Bits Out\" \\\n GPRINT:bitsOut:AVERAGE:\"Avg  \\\\: %8.2lf %s\" \\\n GPRINT:bitsOut:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:bitsOut:MAX:\"Max  \\\\: %8.2lf %s\\\\n\"\n\nreport.mib2.discards.name=Discards In/Out\nreport.mib2.discards.columns=ifInDiscards,ifOutDiscards\nreport.mib2.discards.type=interface\nreport.mib2.discards.propertiesValues=ifSpeed\nreport.mib2.discards.command=--title=\"Discards In/Out\" \\\n DEF:octIn={rrd1}:ifInDiscards:AVERAGE \\\n DEF:octOut={rrd2}:ifOutDiscards:AVERAGE \\\n LINE2:octIn#0000ff:\"Discards In\" \\\n GPRINT:octIn:AVERAGE:\" Avg  \\\\: %8.2lf %s\" \\\n GPRINT:octIn:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:octIn:MAX:\"Max  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:octOut#ff0000:\"Discards Out\" \\\n GPRINT:octOut:AVERAGE:\"Avg  \\\\: %8.2lf %s\" \\\n GPRINT:octOut:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:octOut:MAX:\"Max  \\\\: %8.2lf %s\\\\n\"\n";
    private static final String s_adhoc = "command.prefix=@install.rrdtool.bin@ graph - --imgformat PNG --start {1} --end {2}\noutput.mime=image/png\nadhoc.command.title=--title=\"{3}\"\nadhoc.command.ds=DEF:{4}={0}:{5}:{6}\nadhoc.command.graphline={7}:{4}#{8}:\"{9}\"\n";
    private static final String s_responsePrefab = "command.prefix=foo\noutput.mime=foo\n\nreports=icmp\n\nreport.icmp.name=ICMP\nreport.icmp.columns=icmp\nreport.icmp.type=responseTime\nreport.icmp.command=--title=\"ICMP Response Time\" \\\n  --vertical-label=\"Seconds\" \\\n  DEF:rtMicro={rrd1}:icmp:AVERAGE \\\n  CDEF:rt=rtMicro,1000000,/ \\\n  LINE1:rt#0000ff:\"Response Time\" \\\n  GPRINT:rt:AVERAGE:\" Avg  \\: %8.2lf %s\" \\\n  GPRINT:rt:MIN:\"Min  \\\\: %8.2lf %s\" \\\n  GPRINT:rt:MAX:\"Max  \\\\: %8.2lf %s\\\\n\"";
    private Map<String, PrefabGraph> m_graphs;
    private PropertiesGraphDao m_dao;

    protected void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
        this.m_dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        ByteArrayInputStream in = new ByteArrayInputStream(s_prefab.getBytes());
        this.m_dao.loadProperties("performance", (InputStream)in);
        PrefabGraphType type = this.m_dao.findByName("performance");
        PropertiesGraphDaoTest.assertNotNull((String)"could not get performance prefab graph type", (Object)type);
        this.m_graphs = type.getReportMap();
        PropertiesGraphDaoTest.assertNotNull((String)"report map shouldn't be null", this.m_graphs);
    }

    protected void runTest() throws Throwable {
        super.runTest();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    public void testCompareToLessThan() {
        PrefabGraph bits = this.m_graphs.get("mib2.bits");
        PrefabGraph discards = this.m_graphs.get("mib2.discards");
        PropertiesGraphDaoTest.assertEquals((String)"compareTo", (int)-1, (int)bits.compareTo(discards));
    }

    public void testCompareToGreaterThan() {
        PrefabGraph bits = this.m_graphs.get("mib2.bits");
        PrefabGraph discards = this.m_graphs.get("mib2.discards");
        PropertiesGraphDaoTest.assertEquals((String)"compareTo", (int)1, (int)discards.compareTo(bits));
    }

    public void testCompareToEquals() {
        PrefabGraph bits = this.m_graphs.get("mib2.bits");
        PrefabGraph bits2 = this.m_graphs.get("mib2.bits");
        PropertiesGraphDaoTest.assertEquals((String)"compareTo", (int)0, (int)bits.compareTo(bits2));
    }

    public void testGetName() {
        PrefabGraph bits = this.m_graphs.get("mib2.bits");
        PropertiesGraphDaoTest.assertEquals((String)"getName", (String)"mib2.bits", (String)bits.getName());
    }

    public void testGetTitle() {
        PrefabGraph bits = this.m_graphs.get("mib2.bits");
        PropertiesGraphDaoTest.assertEquals((String)"getTitle", (String)"Bits In/Out", (String)bits.getTitle());
    }

    public void testGetOrder() {
        PrefabGraph bits = this.m_graphs.get("mib2.HCbits");
        PropertiesGraphDaoTest.assertEquals((String)"getOrder", (int)0, (int)bits.getOrder());
    }

    public void testGetColumns() {
        PrefabGraph bits = this.m_graphs.get("mib2.bits");
        String[] columns = bits.getColumns();
        PropertiesGraphDaoTest.assertEquals((String)"getColumns().length", (int)2, (int)columns.length);
        PropertiesGraphDaoTest.assertEquals((String)"getColumns()[0]", (String)"ifInOctets", (String)columns[0]);
        PropertiesGraphDaoTest.assertEquals((String)"getColumns()[1]", (String)"ifOutOctets", (String)columns[1]);
    }

    public void testGetCommand() {
        String expectedCommand = "--title=\"Bits In/Out\" DEF:octIn={rrd1}:ifInOctets:AVERAGE DEF:octOut={rrd2}:ifOutOctets:AVERAGE CDEF:bitsIn=octIn,8,* CDEF:bitsOut=octOut,8,* CDEF:totBits=octIn,octOut,+,8,* AREA:totBits#00ff00:\"Total\" GPRINT:totBits:AVERAGE:\" Avg  \\: %8.2lf %s\\n\" LINE2:bitsIn#0000ff:\"Bits In\" GPRINT:bitsIn:AVERAGE:\" Avg  \\: %8.2lf %s\" GPRINT:bitsIn:MIN:\"Min  \\: %8.2lf %s\" GPRINT:bitsIn:MAX:\"Max  \\: %8.2lf %s\\n\" LINE2:bitsOut#ff0000:\"Bits Out\" GPRINT:bitsOut:AVERAGE:\"Avg  \\: %8.2lf %s\" GPRINT:bitsOut:MIN:\"Min  \\: %8.2lf %s\" GPRINT:bitsOut:MAX:\"Max  \\: %8.2lf %s\\n\"";
        PrefabGraph bits = this.m_graphs.get("mib2.bits");
        PropertiesGraphDaoTest.assertEquals((String)"getCommand", (String)expectedCommand, (String)bits.getCommand());
    }

    public void testGetExternalValues() {
        PrefabGraph bits = this.m_graphs.get("mib2.bits");
        String[] values = bits.getExternalValues();
        PropertiesGraphDaoTest.assertEquals((String)"getExternalValues().length", (int)1, (int)values.length);
        PropertiesGraphDaoTest.assertEquals((String)"getExternalValues()[0]", (String)"ifSpeed", (String)values[0]);
    }

    public void testGetExternalValuesEmpty() {
        PrefabGraph discards = this.m_graphs.get("mib2.discards");
        PropertiesGraphDaoTest.assertEquals((String)"getExternalValues().length", (int)0, (int)discards.getExternalValues().length);
    }

    public void testGetPropertiesValues() {
        PrefabGraph discards = this.m_graphs.get("mib2.discards");
        String[] values = discards.getPropertiesValues();
        PropertiesGraphDaoTest.assertEquals((String)"getPropertiesValues().length", (int)1, (int)values.length);
        PropertiesGraphDaoTest.assertEquals((String)"getPropertiesValues()[0]", (String)"ifSpeed", (String)values[0]);
    }

    public void testGetPropertiesValuesEmpty() {
        PrefabGraph bits = this.m_graphs.get("mib2.bits");
        PropertiesGraphDaoTest.assertEquals((String)"getPropertiesValues().length", (int)0, (int)bits.getPropertiesValues().length);
    }

    public void testGetTypes() {
        PrefabGraph bits = this.m_graphs.get("mib2.bits");
        PropertiesGraphDaoTest.assertNotNull((String)"getTypes", (Object)bits.getTypes());
        PropertiesGraphDaoTest.assertEquals((String)"getTypes count", (int)1, (int)bits.getTypes().length);
        PropertiesGraphDaoTest.assertEquals((String)"getTypes 1", (String)"interface", (String)bits.getTypes()[0]);
    }

    public void testGetDescription() {
        PrefabGraph bits = this.m_graphs.get("mib2.bits");
        PropertiesGraphDaoTest.assertEquals((String)"getDescription", null, (String)bits.getDescription());
    }

    public void testLoadSnmpGraphProperties() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        dao.loadProperties("foo", ConfigurationTestUtils.getInputStreamForConfigFile((String)"snmp-graph.properties"));
    }

    public void testLoadSnmpAdhocGraphProperties() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        dao.loadAdhocProperties("foo", ConfigurationTestUtils.getInputStreamForConfigFile((String)"snmp-adhoc-graph.properties"));
    }

    public void testLoadResponseTimeGraphProperties() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        dao.loadProperties("foo", ConfigurationTestUtils.getInputStreamForConfigFile((String)"response-graph.properties"));
    }

    public void testLoadResponseTimeAdhocGraphProperties() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        dao.loadAdhocProperties("foo", ConfigurationTestUtils.getInputStreamForConfigFile((String)"response-adhoc-graph.properties"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrefabPropertiesReload() throws Exception {
        FileAnticipator fa = new FileAnticipator();
        try {
            File f = fa.tempFile("snmp-graph.properties");
            FileWriter writer = new FileWriter(f);
            String noDiscards = s_prefab.replace(", mib2.discards", "");
            writer.write(noDiscards);
            writer.close();
            HashMap<String, Resource> perfConfig = new HashMap<String, Resource>();
            perfConfig.put("performance", (Resource)new FileSystemResource(f));
            PropertiesGraphDao dao = this.createPropertiesGraphDao(perfConfig, s_emptyMap);
            PrefabGraphType type = dao.findByName("performance");
            PropertiesGraphDaoTest.assertNotNull((String)"could not get performance prefab graph type", (Object)type);
            PropertiesGraphDaoTest.assertNotNull((String)"could not get mib2.bits report", (Object)type.getQuery("mib2.bits"));
            PropertiesGraphDaoTest.assertNull((String)"could get mib2.discards report, but shouldn't have been able to", (Object)type.getQuery("mib2.discards"));
            Thread.sleep(1100L);
            writer = new FileWriter(f);
            writer.write(s_prefab);
            writer.close();
            type = dao.findByName("performance");
            PropertiesGraphDaoTest.assertNotNull((String)"could not get performance prefab graph type after rewriting config file", (Object)type);
            PropertiesGraphDaoTest.assertNotNull((String)"could not get mib2.bits report after rewriting config file", (Object)type.getQuery("mib2.bits"));
            PropertiesGraphDaoTest.assertNotNull((String)"could not get mib2.discards report after rewriting config file", (Object)type.getQuery("mib2.discards"));
        }
        finally {
            fa.deleteExpected();
            fa.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrefabPropertiesReloadBad() throws Exception {
        FileAnticipator fa = new FileAnticipator();
        MockLogAppender.setupLogging((boolean)false, (String)"DEBUG");
        try {
            File f = fa.tempFile("snmp-graph.properties");
            FileWriter writer = new FileWriter(f);
            writer.write(s_prefab);
            writer.close();
            HashMap<String, Resource> perfConfig = new HashMap<String, Resource>();
            perfConfig.put("performance", (Resource)new FileSystemResource(f));
            PropertiesGraphDao dao = this.createPropertiesGraphDao(perfConfig, s_emptyMap);
            PrefabGraphType type = dao.findByName("performance");
            PropertiesGraphDaoTest.assertNotNull((String)"could not get performance prefab graph type", (Object)type);
            PropertiesGraphDaoTest.assertNotNull((String)"could not get mib2.bits report", (Object)type.getQuery("mib2.bits"));
            PropertiesGraphDaoTest.assertNotNull((String)"could not get mib2.discards report", (Object)type.getQuery("mib2.discards"));
            Thread.sleep(1100L);
            writer = new FileWriter(f);
            String noReports = s_prefab.replace("reports=mib2.HCbits, mib2.bits, mib2.discards", "");
            writer.write(noReports);
            writer.close();
            type = dao.findByName("performance");
            PropertiesGraphDaoTest.assertNotNull((String)"could not get performance prefab graph type after rewriting config file", (Object)type);
            PropertiesGraphDaoTest.assertNotNull((String)"could not get mib2.bits report after rewriting config file", (Object)type.getQuery("mib2.bits"));
            PropertiesGraphDaoTest.assertNotNull((String)"could not get mib2.discards report after rewriting config file", (Object)type.getQuery("mib2.discards"));
        }
        finally {
            fa.deleteExpected();
            fa.tearDown();
        }
        LoggingEvent[] events = MockLogAppender.getEvents();
        PropertiesGraphDaoTest.assertNotNull((String)"logged event list was null", (Object)events);
        PropertiesGraphDaoTest.assertEquals((String)"should only have received two logged events", (int)2, (int)events.length);
        PropertiesGraphDaoTest.assertEquals((String)("should have received an ERROR event" + events[0]), (Object)Level.ERROR, (Object)events[0].getLevel());
        PropertiesGraphDaoTest.assertEquals((String)("should have received an INFO event" + events[1]), (Object)Level.INFO, (Object)events[1].getLevel());
        MockLogAppender.resetEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdhocPropertiesReload() throws Exception {
        FileAnticipator fa = new FileAnticipator();
        try {
            File f = fa.tempFile("snmp-adhoc-graph.properties");
            FileWriter writer = new FileWriter(f);
            String cheesy = s_adhoc.replace("image/png", "image/cheesy");
            writer.write(cheesy);
            writer.close();
            HashMap<String, Resource> adhocConfig = new HashMap<String, Resource>();
            adhocConfig.put("performance", (Resource)new FileSystemResource(f));
            PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, adhocConfig);
            AdhocGraphType type = dao.findAdhocByName("performance");
            PropertiesGraphDaoTest.assertNotNull((String)"could not get performance adhoc graph type", (Object)type);
            PropertiesGraphDaoTest.assertEquals((String)"image type isn't correct", (String)"image/cheesy", (String)type.getOutputMimeType());
            Thread.sleep(1100L);
            writer = new FileWriter(f);
            writer.write(s_adhoc);
            writer.close();
            type = dao.findAdhocByName("performance");
            PropertiesGraphDaoTest.assertNotNull((String)"could not get performance adhoc graph type", (Object)type);
            PropertiesGraphDaoTest.assertEquals((String)"image type isn't correct", (String)"image/png", (String)type.getOutputMimeType());
        }
        finally {
            fa.deleteExpected();
            fa.tearDown();
        }
    }

    public void testNoType() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        String ourConfig = s_responsePrefab.replaceAll("report.icmp.type=responseTime", "");
        ByteArrayInputStream in = new ByteArrayInputStream(ourConfig.getBytes());
        dao.loadProperties("response", (InputStream)in);
        PrefabGraphType type = dao.findByName("response");
        PropertiesGraphDaoTest.assertNotNull((String)"could not get response prefab graph type", (Object)type);
        PrefabGraph graph = type.getQuery("icmp");
        PropertiesGraphDaoTest.assertNotNull((String)"could not get icmp response prefab graph type", (Object)graph);
        PropertiesGraphDaoTest.assertNotNull((String)"graph type list should not be null", (Object)graph.getTypes());
        PropertiesGraphDaoTest.assertEquals((String)"graph type was not specified the list should be empty", (int)0, (int)graph.getTypes().length);
        PropertiesGraphDaoTest.assertFalse((String)"should not have responseTime type", (boolean)graph.hasMatchingType(new String[]{"responseTime"}));
    }

    public void testOneType() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        ByteArrayInputStream in = new ByteArrayInputStream(s_responsePrefab.getBytes());
        dao.loadProperties("response", (InputStream)in);
        PrefabGraphType type = dao.findByName("response");
        PropertiesGraphDaoTest.assertNotNull((String)"could not get response prefab graph type", (Object)type);
        PrefabGraph graph = type.getQuery("icmp");
        PropertiesGraphDaoTest.assertNotNull((String)"could not get icmp response prefab graph type", (Object)graph);
        PropertiesGraphDaoTest.assertNotNull((String)"graph type list should not be null", (Object)graph.getTypes());
        PropertiesGraphDaoTest.assertEquals((String)"graph type was not specified the list should be empty", (int)1, (int)graph.getTypes().length);
        PropertiesGraphDaoTest.assertEquals((String)"graph type 1", (String)"responseTime", (String)graph.getTypes()[0]);
        PropertiesGraphDaoTest.assertTrue((String)"should have responseTime type", (boolean)graph.hasMatchingType(new String[]{"responseTime"}));
        PropertiesGraphDaoTest.assertFalse((String)"should not have distributedStatus type", (boolean)graph.hasMatchingType(new String[]{"distributedStatus"}));
        PropertiesGraphDaoTest.assertTrue((String)"should have responseTime or distributedStatus type", (boolean)graph.hasMatchingType(new String[]{"responseTime", "distributedStatus"}));
    }

    public void testTwoTypes() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        String ourConfig = s_responsePrefab.replaceAll("report.icmp.type=responseTime", "report.icmp.type=responseTime, distributedStatus");
        ByteArrayInputStream in = new ByteArrayInputStream(ourConfig.getBytes());
        dao.loadProperties("response", (InputStream)in);
        PrefabGraphType type = dao.findByName("response");
        PropertiesGraphDaoTest.assertNotNull((String)"could not get response prefab graph type", (Object)type);
        PrefabGraph graph = type.getQuery("icmp");
        PropertiesGraphDaoTest.assertNotNull((String)"could not get icmp response prefab graph type", (Object)graph);
        PropertiesGraphDaoTest.assertNotNull((String)"graph type should not be null", (Object)graph.getTypes());
        PropertiesGraphDaoTest.assertEquals((String)"graph type count", (int)2, (int)graph.getTypes().length);
        PropertiesGraphDaoTest.assertEquals((String)"graph type 1", (String)"responseTime", (String)graph.getTypes()[0]);
        PropertiesGraphDaoTest.assertEquals((String)"graph type 2", (String)"distributedStatus", (String)graph.getTypes()[1]);
        PropertiesGraphDaoTest.assertTrue((String)"should have responseTime type", (boolean)graph.hasMatchingType(new String[]{"responseTime"}));
        PropertiesGraphDaoTest.assertTrue((String)"should have distributedStatus type", (boolean)graph.hasMatchingType(new String[]{"distributedStatus"}));
    }

    public void testGetPrefabGraphsForResource() {
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interface");
        HashSet<Object> attributes = new HashSet<Object>(0);
        attributes.add(new RrdGraphAttribute("ifInOctets", "", ""));
        attributes.add(new RrdGraphAttribute("ifOutOctets", "", ""));
        attributes.add(new ExternalValueAttribute("ifSpeed", ""));
        OnmsResource resource = new OnmsResource("node", "1", (OnmsResourceType)resourceType, attributes);
        PrefabGraph[] graphs = this.m_dao.getPrefabGraphsForResource(resource);
        PropertiesGraphDaoTest.assertEquals((String)"prefab graph array size", (int)1, (int)graphs.length);
        PropertiesGraphDaoTest.assertEquals((String)"prefab graph[0] name", (String)"mib2.bits", (String)graphs[0].getName());
    }

    public void testGetPrefabGraphsForResourceWithSuppress() {
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interface");
        HashSet<Object> attributes = new HashSet<Object>(0);
        attributes.add(new RrdGraphAttribute("ifInOctets", "", ""));
        attributes.add(new RrdGraphAttribute("ifOutOctets", "", ""));
        attributes.add(new RrdGraphAttribute("ifHCInOctets", "", ""));
        attributes.add(new RrdGraphAttribute("ifHCOutOctets", "", ""));
        attributes.add(new ExternalValueAttribute("ifSpeed", ""));
        OnmsResource resource = new OnmsResource("node", "1", (OnmsResourceType)resourceType, attributes);
        PrefabGraph[] graphs = this.m_dao.getPrefabGraphsForResource(resource);
        PropertiesGraphDaoTest.assertEquals((String)"prefab graph array size", (int)1, (int)graphs.length);
        PropertiesGraphDaoTest.assertEquals((String)"prefab graph[0] name", (String)"mib2.HCbits", (String)graphs[0].getName());
    }

    public void testGetPrefabGraphsForResourceWithSuppressUnused() {
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interface");
        HashSet<Object> attributes = new HashSet<Object>(0);
        attributes.add(new RrdGraphAttribute("ifHCInOctets", "", ""));
        attributes.add(new RrdGraphAttribute("ifHCOutOctets", "", ""));
        attributes.add(new ExternalValueAttribute("ifSpeed", ""));
        OnmsResource resource = new OnmsResource("node", "1", (OnmsResourceType)resourceType, attributes);
        PrefabGraph[] graphs = this.m_dao.getPrefabGraphsForResource(resource);
        PropertiesGraphDaoTest.assertEquals((String)"prefab graph array size", (int)1, (int)graphs.length);
        PropertiesGraphDaoTest.assertEquals((String)"prefab graph[0] name", (String)"mib2.HCbits", (String)graphs[0].getName());
    }

    public PropertiesGraphDao createPropertiesGraphDao(Map<String, Resource> prefabConfigs, Map<String, Resource> adhocConfigs) throws IOException {
        PropertiesGraphDao dao = new PropertiesGraphDao();
        dao.setPrefabConfigs(prefabConfigs);
        dao.setAdhocConfigs(adhocConfigs);
        dao.afterPropertiesSet();
        return dao;
    }
}

