/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.dao.CastorDataAccessFailureException;
import org.opennms.netmgt.dao.hibernate.LocationMonitorDaoHibernate;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.ThrowableAnticipator;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationMonitorDaoHibernateTest
extends AbstractTransactionalDaoTestCase {
    public void testInitialize() {
    }

    public void testSaveLocationMonitor() {
        HashMap<String, String> pollerDetails = new HashMap<String, String>();
        pollerDetails.put("os.name", "BogOS");
        pollerDetails.put("os.version", "sqrt(-1)");
        OnmsLocationMonitor mon = new OnmsLocationMonitor();
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        mon.setLastCheckInTime(new Date());
        mon.setDetails(pollerDetails);
        mon.setDefinitionName("RDU");
        this.getLocationMonitorDao().save((Object)mon);
        this.getLocationMonitorDao().flush();
        this.getLocationMonitorDao().clear();
        Object[] args = new Object[]{mon.getId()};
        LocationMonitorDaoHibernateTest.assertEquals((int)2, (int)this.getJdbcTemplate().queryForInt("select count(*) from location_monitor_details where locationMonitorId = ?", args));
        OnmsLocationMonitor mon2 = (OnmsLocationMonitor)this.getLocationMonitorDao().get((Serializable)mon.getId());
        LocationMonitorDaoHibernateTest.assertNotSame((Object)mon, (Object)mon2);
        LocationMonitorDaoHibernateTest.assertEquals((Object)mon.getStatus(), (Object)mon2.getStatus());
        LocationMonitorDaoHibernateTest.assertEquals((Object)mon.getLastCheckInTime(), (Object)mon2.getLastCheckInTime());
        LocationMonitorDaoHibernateTest.assertEquals((String)mon.getDefinitionName(), (String)mon2.getDefinitionName());
        LocationMonitorDaoHibernateTest.assertEquals((Object)mon.getDetails(), (Object)mon2.getDetails());
    }

    public void testSetConfigResourceProduction() throws FileNotFoundException {
        this.getLocationMonitorDao().setMonitoringLocationConfigResource((Resource)new InputStreamResource(ConfigurationTestUtils.getInputStreamForConfigFile((String)"monitoring-locations.xml")));
    }

    public void testSetConfigResourceExample() throws FileNotFoundException {
        this.getLocationMonitorDao().setMonitoringLocationConfigResource((Resource)new InputStreamResource(ConfigurationTestUtils.getInputStreamForConfigFile((String)"examples/monitoring-locations.xml")));
    }

    public void testSetConfigResourceNoLocations() throws FileNotFoundException {
        this.getLocationMonitorDao().setMonitoringLocationConfigResource((Resource)new FileSystemResource("src/test/resources/monitoring-locations-no-locations.xml"));
    }

    public void testBogusConfig() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new CastorDataAccessFailureException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            this.getLocationMonitorDao().setMonitoringLocationConfigResource((Resource)new FileSystemResource("some bogus filename"));
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testFindAllLocationDefinitionsPropsNotSet() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            new LocationMonitorDaoHibernate().findAllLocationDefinitions();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testFindAllMonitoringLocationDefinitionsPropsNotSet() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            new LocationMonitorDaoHibernate().findAllMonitoringLocationDefinitions();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testFindMonitoringLocationDefinitionPropsNotSet() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            new LocationMonitorDaoHibernate().findMonitoringLocationDefinition("test");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testFindMonitoringLocationDefinitionNull() throws FileNotFoundException {
        this.getLocationMonitorDao().setMonitoringLocationConfigResource((Resource)new InputStreamResource(ConfigurationTestUtils.getInputStreamForConfigFile((String)"monitoring-locations.xml")));
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            this.getLocationMonitorDao().findMonitoringLocationDefinition(null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testFindMonitoringLocationDefinitionBogus() throws FileNotFoundException {
        this.getLocationMonitorDao().setMonitoringLocationConfigResource((Resource)new InputStreamResource(ConfigurationTestUtils.getInputStreamForConfigFile((String)"monitoring-locations.xml")));
        LocationMonitorDaoHibernateTest.assertNull((String)"should not have found monitoring location definition--should have returned null", (Object)this.getLocationMonitorDao().findMonitoringLocationDefinition("bogus"));
    }

    public void testFindStatusChangesForNodeForUniqueMonitorAndInterface() throws InterruptedException {
        OnmsLocationMonitor monitor1 = new OnmsLocationMonitor();
        monitor1.setDefinitionName("Outer Space");
        this.getLocationMonitorDao().save((Object)monitor1);
        OnmsLocationMonitor monitor2 = new OnmsLocationMonitor();
        monitor2.setDefinitionName("Really Outer Space");
        this.getLocationMonitorDao().save((Object)monitor2);
        OnmsNode node1 = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(1));
        LocationMonitorDaoHibernateTest.assertNotNull((String)"node 1 should not be null", (Object)node1);
        OnmsNode node2 = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(2));
        LocationMonitorDaoHibernateTest.assertNotNull((String)"node 2 should not be null", (Object)node2);
        this.addStatusChangesForMonitorAndService(monitor1, node1.getIpInterfaceByIpAddress("192.168.1.1").getMonitoredServices());
        this.addStatusChangesForMonitorAndService(monitor1, node1.getIpInterfaceByIpAddress("192.168.1.2").getMonitoredServices());
        this.addStatusChangesForMonitorAndService(monitor2, node1.getIpInterfaceByIpAddress("192.168.1.1").getMonitoredServices());
        this.addStatusChangesForMonitorAndService(monitor1, node2.getIpInterfaceByIpAddress("192.168.2.1").getMonitoredServices());
        Thread.sleep(10L);
        this.addStatusChangesForMonitorAndService(monitor1, node1.getIpInterfaceByIpAddress("192.168.1.1").getMonitoredServices());
        Collection statuses = this.getLocationMonitorDao().findStatusChangesForNodeForUniqueMonitorAndInterface(1);
        LocationMonitorDaoHibernateTest.assertEquals((String)"number of statuses found", (int)3, (int)statuses.size());
    }

    private void addStatusChangesForMonitorAndService(OnmsLocationMonitor monitor, Set<OnmsMonitoredService> services) {
        for (OnmsMonitoredService service : services) {
            OnmsLocationSpecificStatus status = new OnmsLocationSpecificStatus();
            status.setLocationMonitor(monitor);
            status.setMonitoredService(service);
            status.setPollResult(PollStatus.available());
            this.getLocationMonitorDao().saveStatusChange(status);
        }
    }
}

