/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import javax.sql.DataSource;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.dao.db.TemporaryDatabase;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

public class TemporaryDatabaseExecutionListener
extends AbstractTestExecutionListener {
    public void afterTestMethod(TestContext testContext) throws Exception {
        System.err.printf("TemporaryDatabaseExecutionListener.afterTestMethod(%s)\n", testContext);
        DataSource dataSource = DataSourceFactory.getInstance();
        TemporaryDatabase tempDb = this.findTemporaryDatabase(dataSource);
        if (tempDb != null) {
            tempDb.drop();
        }
        testContext.markApplicationContextDirty();
        testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, (Object)Boolean.TRUE);
    }

    private TemporaryDatabase findTemporaryDatabase(DataSource dataSource) {
        if (dataSource instanceof TemporaryDatabase) {
            return (TemporaryDatabase)dataSource;
        }
        if (dataSource instanceof DelegatingDataSource) {
            return this.findTemporaryDatabase(((DelegatingDataSource)dataSource).getTargetDataSource());
        }
        return null;
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        System.err.printf("TemporaryDatabaseExecutionListener.beforeTestMethod(%s)\n", testContext);
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
        System.err.printf("TemporaryDatabaseExecutionListener.prepareTestInstance(%s)\n", testContext);
        String dbName = this.getDatabaseName(testContext);
        TemporaryDatabase dataSource = new TemporaryDatabase(dbName);
        dataSource.setPopulateSchema(true);
        dataSource.create();
        LazyConnectionDataSourceProxy proxy = new LazyConnectionDataSourceProxy((DataSource)dataSource);
        DataSourceFactory.setInstance((DataSource)proxy);
    }

    private String getDatabaseName(TestContext testContext) {
        return String.format("opennms_test_%s", System.currentTimeMillis());
    }
}

