/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import java.io.InputStream;
import junit.framework.TestCase;
import org.opennms.netmgt.config.users.Userinfo;
import org.opennms.netmgt.dao.CastorDataAccessFailureException;
import org.opennms.netmgt.dao.castor.AbstractCastorConfigDao;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.ThrowableAnticipator;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class AbstractCastorConfigDaoTest
extends TestCase {
    public void testAfterPropertiesSetWithNoConfigSet() {
        TestCastorConfigDao dao = new TestCastorConfigDao();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property configResource must be set and be non-null"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSetWithBogusFileResource() throws Exception {
        FileSystemResource resource = new FileSystemResource("/bogus-file");
        TestCastorConfigDao dao = new TestCastorConfigDao();
        dao.setConfigResource((Resource)resource);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new CastorDataAccessFailureException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSetWithGoodConfigFile() throws Exception {
        TestCastorConfigDao dao = new TestCastorConfigDao();
        InputStream in = ConfigurationTestUtils.getInputStreamForConfigFile((String)"users.xml");
        dao.setConfigResource((Resource)new InputStreamResource(in));
        dao.afterPropertiesSet();
        AbstractCastorConfigDaoTest.assertNotNull((String)"userinfo should not be null", (Object)dao.getUserinfo());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestCastorConfigDao
    extends AbstractCastorConfigDao<Userinfo, Userinfo> {
        public TestCastorConfigDao() {
            super(Userinfo.class, "user information configuration");
        }

        public Userinfo translateConfig(Userinfo castorConfig) {
            return castorConfig;
        }

        public Userinfo getUserinfo() {
            return (Userinfo)this.getContainer().getObject();
        }
    }
}

