/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.FactoryBasedSnmpConfigDao;
import org.opennms.netmgt.dao.SnmpConfigDao;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpConfiguration;

public class SnmpConfigDaoTest
extends TestCase {
    private SnmpConfigDao m_snmpConfigDao;
    private File m_configFile;

    public void setUp() throws Exception {
        File dir = new File("target/test-work-dir");
        dir.mkdirs();
        this.m_configFile = File.createTempFile("snmp-config-" + this.getName() + "-", "xml", dir);
        FileUtils.writeStringToFile((File)this.m_configFile, (String)"<?xml version=\"1.0\"?><snmp-config port=\"9161\" retry=\"1\" timeout=\"2000\"\n             read-community=\"myPublic\" \n             version=\"v1\" \n             max-vars-per-pdu=\"27\"  />");
        SnmpPeerFactory.setFile((File)this.m_configFile);
        FactoryBasedSnmpConfigDao factoryBasedSnmpConfigDao = new FactoryBasedSnmpConfigDao();
        factoryBasedSnmpConfigDao.afterPropertiesSet();
        this.m_snmpConfigDao = factoryBasedSnmpConfigDao;
    }

    private void assertConfig(String addr, int maxVarsPerPdu, int version, String community) throws UnknownHostException {
        SnmpConfigDaoTest.assertNotNull((Object)this.m_snmpConfigDao);
        SnmpAgentConfig config = this.m_snmpConfigDao.get(InetAddress.getByName(addr));
        SnmpConfigDaoTest.assertNotNull((Object)config);
        SnmpConfigDaoTest.assertEquals((String)addr, (String)config.getAddress().getHostAddress());
        SnmpConfigDaoTest.assertEquals((int)maxVarsPerPdu, (int)config.getMaxVarsPerPdu());
        SnmpConfigDaoTest.assertEquals((int)version, (int)config.getVersion());
        SnmpConfigDaoTest.assertEquals((String)community, (String)config.getReadCommunity());
    }

    public void testGet() throws Exception {
        this.assertConfig("192.168.1.3", 27, 1, "myPublic");
    }

    public void testUpdateDefaults() throws Exception {
        this.assertConfig("192.168.1.3", 27, 1, "myPublic");
        SnmpConfiguration defaults = new SnmpConfiguration();
        defaults.setVersion(2);
        defaults.setMaxVarsPerPdu(72);
        defaults.setReadCommunity("newcommunity");
        this.m_snmpConfigDao.saveAsDefaults(defaults);
        this.assertConfig("192.168.1.3", 72, 2, "newcommunity");
    }

    public void testUpdateConfig() throws Exception {
        this.assertConfig("192.168.1.3", 27, 1, "myPublic");
        this.assertConfig("192.168.1.7", 27, 1, "myPublic");
        SnmpAgentConfig agentConfig = this.m_snmpConfigDao.get(InetAddress.getByName("192.168.1.3"));
        agentConfig.setVersion(2);
        agentConfig.setReadCommunity("newcommunity");
        this.m_snmpConfigDao.saveOrUpdate(agentConfig);
        this.assertConfig("192.168.1.3", 27, 2, "newcommunity");
        this.assertConfig("192.168.1.7", 27, 1, "myPublic");
    }
}

