/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.Date;
import junit.framework.Assert;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.AvailabilityReportLocatorDao;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.NotificationDao;
import org.opennms.netmgt.dao.OutageDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.dao.UserNotificationDao;
import org.opennms.netmgt.dao.hibernate.LocationMonitorDaoHibernate;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSeverity;

public class DatabasePopulator {
    private DistPollerDao m_distPollerDao;
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private SnmpInterfaceDao m_snmpInterfaceDao;
    private MonitoredServiceDao m_monitoredServiceDao;
    private ServiceTypeDao m_serviceTypeDao;
    private AssetRecordDao m_assetRecordDao;
    private CategoryDao m_categoryDao;
    private OutageDao m_outageDao;
    private EventDao m_eventDao;
    private AlarmDao m_alarmDao;
    private NotificationDao m_notificationDao;
    private UserNotificationDao m_userNotificationDao;
    private AvailabilityReportLocatorDao m_availabilityReportLocatorDao;
    private LocationMonitorDaoHibernate m_locationMonitorDao;
    private OnmsNode m_node1;

    public void populateDatabase() {
        OnmsDistPoller distPoller = this.getDistPoller("localhost", "127.0.0.1");
        OnmsCategory ac = this.getCategory("DEV_AC");
        OnmsCategory mid = this.getCategory("IMP_mid");
        OnmsCategory ops = this.getCategory("OPS_Online");
        OnmsCategory catRouter = this.getCategory("Routers");
        OnmsCategory catSwitches = this.getCategory("Switches");
        OnmsCategory catServers = this.getCategory("Servers");
        this.getCategory("Production");
        this.getCategory("Test");
        this.getCategory("Development");
        this.getServiceType("ICMP");
        this.getServiceType("SNMP");
        this.getServiceType("HTTP");
        NetworkBuilder builder = new NetworkBuilder(distPoller);
        this.setNode1(builder.addNode("node1").setForeignSource("imported:").setForeignId("1").getNode());
        Assert.assertNotNull((String)"newly built node 1 should not be null", (Object)this.getNode1());
        builder.addCategory(ac);
        builder.addCategory(mid);
        builder.addCategory(ops);
        builder.addCategory(catRouter);
        builder.setBuilding("HQ");
        builder.addInterface("192.168.1.1").setIsManaged("M").setIsSnmpPrimary("P").setIpStatus(1).addSnmpInterface("192.168.1.1", 1).setIfSpeed(10000000L).setIfDescr("ATM0").setIfType(Integer.valueOf(37));
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("SNMP"));
        builder.addInterface("192.168.1.2").setIsManaged("M").setIsSnmpPrimary("S").setIpStatus(1).addSnmpInterface("192.168.1.2", 2).setIfSpeed(10000000L).setIfName("eth0").setIfType(Integer.valueOf(6));
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("HTTP"));
        builder.addInterface("192.168.1.3").setIsManaged("M").setIsSnmpPrimary("N").setIpStatus(1).addSnmpInterface("192.168.1.3", 3).setIfSpeed(10000000L);
        builder.addService(this.getServiceType("ICMP"));
        this.getNodeDao().save((Object)builder.getCurrentNode());
        this.getNodeDao().flush();
        builder.addNode("node2").setForeignSource("imported:").setForeignId("2");
        builder.addCategory(mid);
        builder.addCategory(catServers);
        builder.setBuilding("HQ");
        builder.addInterface("192.168.2.1").setIsManaged("M").setIsSnmpPrimary("P").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("SNMP"));
        builder.addInterface("192.168.2.2").setIsManaged("M").setIsSnmpPrimary("S").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("HTTP"));
        builder.addInterface("192.168.2.3").setIsManaged("M").setIsSnmpPrimary("N").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        this.getNodeDao().save((Object)builder.getCurrentNode());
        this.getNodeDao().flush();
        builder.addNode("node3").setForeignSource("imported:").setForeignId("3");
        builder.addCategory(ops);
        builder.addInterface("192.168.3.1").setIsManaged("M").setIsSnmpPrimary("P").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("SNMP"));
        builder.addInterface("192.168.3.2").setIsManaged("M").setIsSnmpPrimary("S").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("HTTP"));
        builder.addInterface("192.168.3.3").setIsManaged("M").setIsSnmpPrimary("N").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        this.getNodeDao().save((Object)builder.getCurrentNode());
        this.getNodeDao().flush();
        builder.addNode("node4").setForeignSource("imported:").setForeignId("4");
        builder.addCategory(ac);
        builder.addInterface("192.168.4.1").setIsManaged("M").setIsSnmpPrimary("P").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("SNMP"));
        builder.addInterface("192.168.4.2").setIsManaged("M").setIsSnmpPrimary("S").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("HTTP"));
        builder.addInterface("192.168.4.3").setIsManaged("M").setIsSnmpPrimary("N").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        this.getNodeDao().save((Object)builder.getCurrentNode());
        this.getNodeDao().flush();
        builder.addNode("alternate-node1").getAssetRecord().setAssetNumber("5");
        builder.addCategory(ac);
        builder.addCategory(catSwitches);
        builder.addInterface("10.1.1.1").setIsManaged("M").setIsSnmpPrimary("P").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("SNMP"));
        builder.addInterface("10.1.1.2").setIsManaged("M").setIsSnmpPrimary("S").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("HTTP"));
        builder.addInterface("10.1.1.3").setIsManaged("M").setIsSnmpPrimary("N").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        this.getNodeDao().save((Object)builder.getCurrentNode());
        this.getNodeDao().flush();
        builder.addNode("alternate-node2").getAssetRecord().setDisplayCategory("category1");
        builder.addCategory(ac);
        builder.addInterface("10.1.2.1").setIsManaged("M").setIsSnmpPrimary("P").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("SNMP"));
        builder.addInterface("10.1.2.2").setIsManaged("M").setIsSnmpPrimary("S").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("HTTP"));
        builder.addInterface("10.1.2.3").setIsManaged("M").setIsSnmpPrimary("N").setIpStatus(1);
        builder.addService(this.getServiceType("ICMP"));
        this.getNodeDao().save((Object)builder.getCurrentNode());
        this.getNodeDao().flush();
        OnmsEvent event = new OnmsEvent();
        event.setDistPoller(distPoller);
        event.setEventUei("uei.opennms.org/test");
        event.setEventTime(new Date());
        event.setEventSource("test");
        event.setEventCreateTime(new Date());
        event.setEventSeverity(Integer.valueOf(1));
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        this.getEventDao().save((Object)event);
        this.getEventDao().flush();
        OnmsMonitoredService svc = this.getMonitoredServiceDao().get(Integer.valueOf(1), "192.168.1.1", "SNMP");
        OnmsOutage resolved = new OnmsOutage(new Date(), new Date(), event, event, svc, null, null);
        this.getOutageDao().save((Object)resolved);
        this.getOutageDao().flush();
        OnmsOutage unresolved = new OnmsOutage(new Date(), event, svc);
        this.getOutageDao().save((Object)unresolved);
        this.getOutageDao().flush();
        OnmsCategory category = new OnmsCategory();
        category.setName("some category");
        this.getCategoryDao().save((Object)category);
        this.getCategoryDao().flush();
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setDistPoller((OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost")));
        alarm.setUei(event.getEventUei());
        alarm.setCounter(Integer.valueOf(1));
        alarm.setSeverity(OnmsSeverity.NORMAL);
        alarm.setLastEvent(event);
        this.getAlarmDao().save((Object)alarm);
        this.getAlarmDao().flush();
    }

    private OnmsCategory getCategory(String categoryName) {
        OnmsCategory cat = this.getCategoryDao().findByName(categoryName);
        if (cat == null) {
            cat = new OnmsCategory(categoryName);
            this.getCategoryDao().save((Object)cat);
            this.getCategoryDao().flush();
        }
        return cat;
    }

    private OnmsDistPoller getDistPoller(String localhost, String localhostIp) {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().get((Serializable)((Object)localhost));
        if (distPoller == null) {
            distPoller = new OnmsDistPoller(localhost, localhostIp);
            this.getDistPollerDao().save((Object)distPoller);
            this.getDistPollerDao().flush();
        }
        return distPoller;
    }

    private OnmsServiceType getServiceType(String name) {
        OnmsServiceType serviceType = this.getServiceTypeDao().findByName(name);
        if (serviceType == null) {
            serviceType = new OnmsServiceType(name);
            this.getServiceTypeDao().save((Object)serviceType);
            this.getServiceTypeDao().flush();
        }
        return serviceType;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public AssetRecordDao getAssetRecordDao() {
        return this.m_assetRecordDao;
    }

    public void setAssetRecordDao(AssetRecordDao assetRecordDao) {
        this.m_assetRecordDao = assetRecordDao;
    }

    public AvailabilityReportLocatorDao getAvailabilityReportLocatorDao() {
        return this.m_availabilityReportLocatorDao;
    }

    public void setAvailabilityReportLocatorDao(AvailabilityReportLocatorDao availabilityReportLocatorDao) {
        this.m_availabilityReportLocatorDao = availabilityReportLocatorDao;
    }

    public CategoryDao getCategoryDao() {
        return this.m_categoryDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    public DistPollerDao getDistPollerDao() {
        return this.m_distPollerDao;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.m_distPollerDao = distPollerDao;
    }

    public EventDao getEventDao() {
        return this.m_eventDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public MonitoredServiceDao getMonitoredServiceDao() {
        return this.m_monitoredServiceDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.m_monitoredServiceDao = monitoredServiceDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public NotificationDao getNotificationDao() {
        return this.m_notificationDao;
    }

    public void setNotificationDao(NotificationDao notificationDao) {
        this.m_notificationDao = notificationDao;
    }

    public OutageDao getOutageDao() {
        return this.m_outageDao;
    }

    public void setOutageDao(OutageDao outageDao) {
        this.m_outageDao = outageDao;
    }

    public ServiceTypeDao getServiceTypeDao() {
        return this.m_serviceTypeDao;
    }

    public void setServiceTypeDao(ServiceTypeDao serviceTypeDao) {
        this.m_serviceTypeDao = serviceTypeDao;
    }

    public SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    public void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    public UserNotificationDao getUserNotificationDao() {
        return this.m_userNotificationDao;
    }

    public void setUserNotificationDao(UserNotificationDao userNotificationDao) {
        this.m_userNotificationDao = userNotificationDao;
    }

    public OnmsNode getNode1() {
        return this.m_node1;
    }

    private void setNode1(OnmsNode node1) {
        this.m_node1 = node1;
    }

    public LocationMonitorDaoHibernate getLocationMonitorDao() {
        return this.m_locationMonitorDao;
    }

    public void setLocationMonitorDao(LocationMonitorDaoHibernate locationMonitorDao) {
        this.m_locationMonitorDao = locationMonitorDao;
    }
}

