/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.Date;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.ThrowableAnticipator;
import org.springframework.dao.DataIntegrityViolationException;

public class AlarmDaoTest
extends AbstractTransactionalDaoTestCase {
    public void testSave() {
        OnmsEvent event = new OnmsEvent();
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setEventCreateTime(new Date());
        event.setDistPoller((OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost")));
        event.setEventTime(new Date());
        event.setEventSeverity(new Integer(7));
        event.setEventUei("uei://org/opennms/test/EventDaoTest");
        event.setEventSource("test");
        this.getEventDao().save((Object)event);
        OnmsNode node = (OnmsNode)this.getNodeDao().findAll().iterator().next();
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setNode(node);
        alarm.setUei(event.getEventUei());
        alarm.setSeverityId(event.getEventSeverity());
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        alarm.setCounter(new Integer(1));
        alarm.setDistPoller((OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost")));
        this.getAlarmDao().save((Object)alarm);
        OnmsAlarm newAlarm = (OnmsAlarm)this.getAlarmDao().load((Serializable)alarm.getId());
        AlarmDaoTest.assertEquals((String)"uei://org/opennms/test/EventDaoTest", (String)newAlarm.getUei());
        AlarmDaoTest.assertEquals((Object)alarm.getLastEvent().getId(), (Object)newAlarm.getLastEvent().getId());
    }

    public void testWithoutDistPoller() {
        OnmsEvent event = new OnmsEvent();
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setEventCreateTime(new Date());
        event.setDistPoller((OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost")));
        event.setEventTime(new Date());
        event.setEventSeverity(new Integer(7));
        event.setEventUei("uei://org/opennms/test/EventDaoTest");
        event.setEventSource("test");
        this.getEventDao().save((Object)event);
        OnmsNode node = (OnmsNode)this.getNodeDao().findAll().iterator().next();
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setNode(node);
        alarm.setUei(event.getEventUei());
        alarm.setSeverityId(event.getEventSeverity());
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        alarm.setCounter(new Integer(1));
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new DataIntegrityViolationException("not-null property references a null or transient value: org.opennms.netmgt.model.OnmsAlarm.distPoller; nested exception is org.hibernate.PropertyValueException: not-null property references a null or transient value: org.opennms.netmgt.model.OnmsAlarm.distPoller"));
        try {
            this.getAlarmDao().save((Object)alarm);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }
}

