/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.util.List;
import org.opennms.netmgt.dao.db.Column;
import org.opennms.netmgt.dao.db.Constraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table {
    private String m_name;
    private List<Column> m_columns;
    private List<Constraint> m_constraints;

    public List<Column> getColumns() {
        return this.m_columns;
    }

    public void setColumns(List<Column> columns) {
        this.m_columns = columns;
    }

    public List<Constraint> getConstraints() {
        return this.m_constraints;
    }

    public void setConstraints(List<Constraint> constraints) {
        this.m_constraints = constraints;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name.toLowerCase();
    }

    public void setNotNullOnPrimaryKeyColumns() throws Exception {
        for (Constraint constraint : this.getConstraints()) {
            if (!constraint.isPrimaryKeyConstraint()) continue;
            for (String constrainedColumn : constraint.getColumns()) {
                boolean foundColumn = false;
                for (Column column : this.getColumns()) {
                    if (!constrainedColumn.equals(column.getName())) continue;
                    column.setNotNull(true);
                    foundColumn = true;
                    break;
                }
                if (foundColumn) continue;
                throw new Exception("could not find column '" + constrainedColumn + "' for constraint: " + constraint);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (this.m_name == null && other.getName() != null || this.m_name != null && other.getName() == null) {
            return false;
        }
        if (this.m_name != null && other.getName() != null && !this.m_name.equals(other.getName())) {
            return false;
        }
        if (this.m_columns == null && other.getColumns() != null || this.m_columns != null && other.getColumns() == null) {
            return false;
        }
        if (this.m_columns != null && other.getColumns() != null && !((Object)this.m_columns).equals(other.getColumns())) {
            return false;
        }
        if (this.m_constraints == null && other.getConstraints() != null || this.m_constraints != null && other.getConstraints() == null) {
            return false;
        }
        return this.m_constraints == null || other.getConstraints() == null || ((Object)this.m_constraints).equals(other.getConstraints());
    }
}

