/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.FilteringIterator;
import org.opennms.core.utils.IPSorter;
import org.opennms.core.utils.IteratorIterator;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;
import org.opennms.netmgt.model.discovery.IPPollAddress;
import org.opennms.netmgt.model.discovery.IPPollRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiscoveryConfigFactory {
    public static final String COMMENT_STR = " #";
    public static final char COMMENT_CHAR = '#';
    private static DiscoveryConfigFactory m_singleton = null;
    private DiscoveryConfiguration m_config;
    private static boolean m_loaded = false;

    private DiscoveryConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream cfgIn = new FileInputStream(configFile);
        this.m_config = (DiscoveryConfiguration)Unmarshaller.unmarshal(DiscoveryConfiguration.class, (Reader)new InputStreamReader(cfgIn));
        ((InputStream)cfgIn).close();
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DISCOVERY_CONFIG_FILE_NAME);
        ThreadCategory.getInstance(DiscoveryConfigFactory.class).debug((Object)("init: config file path: " + cfgFile.getPath()));
        m_singleton = new DiscoveryConfigFactory(cfgFile.getPath());
        try {
            m_singleton.getInitialSleepTime();
            m_singleton.getRestartSleepTime();
            m_singleton.getIntraPacketDelay();
            m_singleton.getConfiguredAddresses();
        }
        catch (Exception e) {
            throw new ValidationException("An error occurred while validating the configuration.", (Throwable)e);
        }
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        DiscoveryConfigFactory.init();
    }

    public static synchronized DiscoveryConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public synchronized DiscoveryConfiguration getConfiguration() {
        return this.m_config;
    }

    protected void saveXml(String xml) throws IOException {
        if (xml != null) {
            FileWriter fileWriter = new FileWriter(ConfigFileConstants.getFile((int)ConfigFileConstants.DISCOVERY_CONFIG_FILE_NAME));
            fileWriter.write(xml);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    public synchronized void saveConfiguration(DiscoveryConfiguration configuration) throws MarshalException, ValidationException, IOException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)configuration, (Writer)stringWriter);
        String xml = stringWriter.toString();
        ThreadCategory.getInstance(DiscoveryConfigFactory.class).debug((Object)"saving configuration... \n");
        this.saveXml(xml);
    }

    public boolean addToSpecificsFromURL(List<IPPollAddress> specifics, String url, long timeout, int retries) {
        boolean bRet;
        block10: {
            Category log = ThreadCategory.getInstance();
            bRet = true;
            try {
                URL fileURL = new URL(url);
                InputStream is = fileURL.openStream();
                if (is != null) {
                    BufferedReader buffer = new BufferedReader(new InputStreamReader(is));
                    String ipLine = null;
                    String specIP = null;
                    while ((ipLine = buffer.readLine()) != null) {
                        if ((ipLine = ipLine.trim()).length() == 0 || ipLine.charAt(0) == '#') continue;
                        int comIndex = ipLine.indexOf(COMMENT_STR);
                        if (comIndex == -1) {
                            specIP = ipLine;
                        } else {
                            specIP = ipLine.substring(0, comIndex);
                            ipLine = ipLine.trim();
                        }
                        try {
                            specifics.add(new IPPollAddress(specIP, timeout, retries));
                        }
                        catch (UnknownHostException e) {
                            log.warn((Object)("Unknown host '" + specIP + "' read from URL '" + url.toString() + "': address ignored"));
                        }
                        specIP = null;
                    }
                    buffer.close();
                    break block10;
                }
                log.warn((Object)("URL does not exist: " + url.toString()));
                bRet = true;
            }
            catch (MalformedURLException e) {
                log.error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
                bRet = false;
            }
            catch (FileNotFoundException e) {
                log.error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
                bRet = false;
            }
            catch (IOException e) {
                log.error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
                bRet = false;
            }
        }
        return bRet;
    }

    public List<IPPollAddress> getURLSpecifics() {
        LinkedList<IPPollAddress> specifics = new LinkedList<IPPollAddress>();
        Enumeration urlEntries = this.getConfiguration().enumerateIncludeUrl();
        while (urlEntries.hasMoreElements()) {
            IncludeUrl url = (IncludeUrl)urlEntries.nextElement();
            long timeout = 800L;
            if (url.hasTimeout()) {
                timeout = url.getTimeout();
            } else if (this.getConfiguration().hasTimeout()) {
                timeout = this.getConfiguration().getTimeout();
            }
            int retries = 3;
            if (url.hasRetries()) {
                retries = url.getRetries();
            } else if (this.getConfiguration().hasRetries()) {
                retries = this.getConfiguration().getRetries();
            }
            this.addToSpecificsFromURL(specifics, url.getContent(), timeout, retries);
        }
        return specifics;
    }

    public List<IPPollRange> getRanges() {
        LinkedList<IPPollRange> includes = new LinkedList<IPPollRange>();
        Enumeration includeRangeEntries = this.getConfiguration().enumerateIncludeRange();
        while (includeRangeEntries.hasMoreElements()) {
            IncludeRange ir = (IncludeRange)includeRangeEntries.nextElement();
            long timeout = 800L;
            if (ir.hasTimeout()) {
                timeout = ir.getTimeout();
            } else if (this.getConfiguration().hasTimeout()) {
                timeout = this.getConfiguration().getTimeout();
            }
            int retries = 3;
            if (ir.hasRetries()) {
                retries = ir.getRetries();
            } else if (this.getConfiguration().hasRetries()) {
                retries = this.getConfiguration().getRetries();
            }
            try {
                includes.add(new IPPollRange(ir.getBegin(), ir.getEnd(), timeout, retries));
            }
            catch (UnknownHostException uhE) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)("Failed to convert address range (" + ir.getBegin() + ", " + ir.getEnd() + ")"), (Throwable)uhE);
            }
        }
        return includes;
    }

    public List<IPPollAddress> getSpecifics() {
        LinkedList<IPPollAddress> specifics = new LinkedList<IPPollAddress>();
        Enumeration specificEntries = this.getConfiguration().enumerateSpecific();
        while (specificEntries.hasMoreElements()) {
            Specific s = (Specific)specificEntries.nextElement();
            long timeout = 800L;
            if (s.hasTimeout()) {
                timeout = s.getTimeout();
            } else if (this.getConfiguration().hasTimeout()) {
                timeout = this.getConfiguration().getTimeout();
            }
            int retries = 3;
            if (s.hasRetries()) {
                retries = s.getRetries();
            } else if (this.getConfiguration().hasRetries()) {
                retries = this.getConfiguration().getRetries();
            }
            try {
                specifics.add(new IPPollAddress(s.getContent(), timeout, retries));
            }
            catch (UnknownHostException uhE) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)("Failed to convert address " + s.getContent()), (Throwable)uhE);
            }
        }
        return specifics;
    }

    public boolean isExcluded(InetAddress address) {
        if (this.getConfiguration().getExcludeRangeCollection() != null) {
            long laddr = IPSorter.convertToLong((byte[])address.getAddress());
            for (ExcludeRange range : this.getConfiguration().getExcludeRangeCollection()) {
                try {
                    long begin = IPSorter.convertToLong((byte[])InetAddress.getByName(range.getBegin()).getAddress());
                    long end = IPSorter.convertToLong((byte[])InetAddress.getByName(range.getEnd()).getAddress());
                    if (begin > laddr || laddr > end) continue;
                    return true;
                }
                catch (UnknownHostException ex) {
                    ThreadCategory.getInstance(this.getClass()).debug((Object)"isExcluded: failed to convert exclusion address to InetAddress", (Throwable)ex);
                }
            }
        }
        return false;
    }

    public int getIntraPacketDelay() {
        return 1000 / this.getConfiguration().getPacketsPerSecond();
    }

    public Iterator<IPPollAddress> getExcludingInterator(Iterator<IPPollAddress> it) {
        return new FilteringIterator<IPPollAddress>(it){

            protected boolean matches(IPPollAddress item) {
                return !DiscoveryConfigFactory.this.isExcluded(item.getAddress());
            }
        };
    }

    public Iterable<IPPollAddress> getConfiguredAddresses() {
        List<IPPollAddress> specifics = this.getSpecifics();
        specifics.addAll(this.getURLSpecifics());
        List<IPPollRange> ranges = this.getRanges();
        ArrayList<Iterator<IPPollAddress>> iters = new ArrayList<Iterator<IPPollAddress>>();
        iters.add(specifics.iterator());
        for (IPPollRange range : ranges) {
            iters.add(this.getExcludingInterator(range.iterator()));
        }
        IteratorIterator addrs = new IteratorIterator(iters);
        return addrs;
    }

    public long getRestartSleepTime() {
        return this.getConfiguration().getRestartSleepTime();
    }

    public long getInitialSleepTime() {
        return this.getConfiguration().getInitialSleepTime();
    }
}

