/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.support.FileReloadCallback;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileReloadContainer<T> {
    private static final long DEFAULT_RELOAD_CHECK_INTERVAL = 1000L;
    private T m_object;
    private Resource m_resource;
    private File m_file;
    private long m_lastModified;
    private FileReloadCallback<T> m_callback;
    private long m_reloadCheckInterval = 1000L;
    private long m_lastReloadCheck;

    public FileReloadContainer(T object, Resource resource, FileReloadCallback<T> callback) {
        Assert.notNull(object, (String)"argument object cannot be null");
        Assert.notNull((Object)resource, (String)"argument file cannot be null");
        Assert.notNull(callback, (String)"argument callback cannot be null");
        this.m_object = object;
        this.m_resource = resource;
        this.m_callback = callback;
        try {
            this.m_file = resource.getFile();
            this.m_lastModified = this.m_file.lastModified();
        }
        catch (IOException e) {
            this.log().info((Object)("Resource '" + resource + "' does not seem to have an underlying File object; assuming this is not an auto-reloadable file resource"));
        }
        this.m_lastReloadCheck = System.currentTimeMillis();
    }

    public FileReloadContainer(T object) {
        Assert.notNull(object, (String)"argument object cannot be null");
        this.m_object = object;
    }

    public T getObject() throws DataAccessResourceFailureException {
        this.checkForUpdates();
        return this.m_object;
    }

    private synchronized void checkForUpdates() throws DataAccessResourceFailureException {
        if (this.m_file == null || this.m_reloadCheckInterval < 0L || System.currentTimeMillis() < this.m_lastReloadCheck + this.m_reloadCheckInterval) {
            return;
        }
        this.m_lastReloadCheck = System.currentTimeMillis();
        if (this.m_file.lastModified() <= this.m_lastModified) {
            return;
        }
        this.reload();
    }

    public synchronized void reload() {
        T object;
        this.m_lastModified = this.m_file.lastModified();
        try {
            object = this.m_callback.reload(this.m_object, this.m_resource);
        }
        catch (Throwable t) {
            String message = "Failed reloading data for object '" + this.m_object + "' " + "from file '" + this.m_file.getAbsolutePath() + "'.  " + "Unexpected Throwable received while " + "issuing reload: " + t.getMessage();
            this.log().error((Object)message, t);
            throw new DataAccessResourceFailureException(message, t);
        }
        if (object == null) {
            this.log().info((Object)("Not updating object for file '" + this.m_file.getAbsolutePath() + "' due to reload callback returning null"));
        } else {
            this.m_object = object;
        }
    }

    public File getFile() {
        return this.m_file;
    }

    public long getReloadCheckInterval() {
        return this.m_reloadCheckInterval;
    }

    public void setReloadCheckInterval(long reloadCheckInterval) {
        this.m_reloadCheckInterval = reloadCheckInterval;
    }

    private Category log() {
        return ThreadCategory.getInstance();
    }
}

