/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpInterfaceDaoHibernate
extends AbstractDaoHibernate<OnmsIpInterface, Integer>
implements IpInterfaceDao {
    String m_findByServiceTypeQuery = System.getProperty("org.opennms.dao.ipinterface.findByServiceType", "select distinct ipIf from OnmsIpInterface as ipIf join ipIf.monitoredServices as monSvc where monSvc.serviceType.name = ?");

    public IpInterfaceDaoHibernate() {
        super(OnmsIpInterface.class);
    }

    @Override
    public OnmsIpInterface get(OnmsNode node, String ipAddress) {
        return (OnmsIpInterface)this.findUnique("from OnmsIpInterface as ipIf where ipIf.node = ? and ipIf.ipAddress = ?", node, ipAddress);
    }

    @Override
    public Collection<OnmsIpInterface> findByIpAddress(String ipAddress) {
        return this.find("from OnmsIpInterface ipIf where ipIf.ipAddress = ?", ipAddress);
    }

    @Override
    public Collection<OnmsIpInterface> findByServiceType(String svcName) {
        return this.find(this.m_findByServiceTypeQuery, svcName);
    }

    @Override
    public Collection<OnmsIpInterface> findHierarchyByServiceType(String svcName) {
        return this.find("select distinct ipIf from OnmsIpInterface as ipIf left join fetch ipIf.node as node left join fetch node.assetRecord left join fetch ipIf.node.snmpInterfaces as snmpIf left join fetch snmpIf.ipInterfaces join ipIf.monitoredServices as monSvc where monSvc.serviceType.name = ?", svcName);
    }

    @Override
    public Map<String, Integer> getInterfacesForNodes() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List l = this.getHibernateTemplate().find("select distinct ipIf.ipAddress, ipIf.node.id from OnmsIpInterface as ipIf");
        for (Object o : l) {
            String ip = (String)((Object[])o)[0];
            Integer nodeId = (Integer)((Object[])o)[1];
            map.put(ip, nodeId);
        }
        return map;
    }
}

