/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.IntegerType;
import org.hibernate.type.Type;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsCategory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryDaoHibernate
extends AbstractDaoHibernate<OnmsCategory, Integer>
implements CategoryDao {
    public CategoryDaoHibernate() {
        super(OnmsCategory.class);
    }

    @Override
    public OnmsCategory findByName(String name) {
        return (OnmsCategory)this.findUnique("from OnmsCategory as category where category.name = ?", name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Criterion> getCriterionForCategorySetsUnion(String[] ... categories) {
        void var5_7;
        Assert.notNull((Object)categories, (String)"categories argument must not be null");
        Assert.isTrue((categories.length >= 1 ? 1 : 0) != 0, (String)"categories must have at least one set of categories");
        ArrayList categoryIdsList = new ArrayList(categories.length);
        String[][] arr$ = categories;
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_7 < len$) {
            String[] categoryStrings = arr$[var5_7];
            ArrayList<Integer> categoryIds = new ArrayList<Integer>(categoryStrings.length);
            for (String categoryString : categoryStrings) {
                OnmsCategory category = this.findByName(categoryString);
                if (category == null) {
                    throw new IllegalArgumentException("Could not find category for name '" + categoryString + "'");
                }
                categoryIds.add(category.getId());
            }
            categoryIdsList.add(categoryIds);
            ++var5_7;
        }
        ArrayList<Criterion> criteria = new ArrayList<Criterion>(categoryIdsList.size());
        for (List list : categoryIdsList) {
            Type[] types = new Type[list.size()];
            Object[] questionMarks = new String[list.size()];
            IntegerType theOneAndOnlyType = new IntegerType();
            for (int i = 0; i < list.size(); ++i) {
                types[i] = theOneAndOnlyType;
                questionMarks[i] = "?";
            }
            String sql = "{alias}.nodeId in (select distinct cn.nodeId from category_node cn where cn.categoryId in (" + StringUtils.arrayToCommaDelimitedString((Object[])questionMarks) + "))";
            criteria.add(Restrictions.sqlRestriction((String)sql, (Object[])list.toArray(new Integer[list.size()]), (Type[])types));
        }
        return criteria;
    }
}

