/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import junit.framework.TestCase;
import org.opennms.netmgt.dao.support.MockResourceType;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.dao.support.RrdTestUtils;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.test.FileAnticipator;
import org.opennms.test.ThrowableAnticipator;

public class ResourceTypeUtilsTest
extends TestCase {
    private FileAnticipator m_fileAnticipator;
    private File m_snmp;
    private File m_node;
    private File m_intf;

    protected void setUp() throws Exception {
        super.setUp();
        this.m_fileAnticipator = new FileAnticipator();
        RrdTestUtils.initializeNullStrategy();
    }

    protected void tearDown() {
        this.m_fileAnticipator.tearDown();
    }

    public void testLoadPropertiesNullRrdDirectory() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("rrdDirectory argument must not be null"));
        try {
            ResourceTypeUtils.getStringProperties(null, (String)"something");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testLoadPropertiesNullRelativePath() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("relativePath argument must not be null"));
        try {
            ResourceTypeUtils.getStringProperties((File)new File(""), null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testLoadPropertiesEmpty() throws Exception {
        OnmsResource childResource = this.createResource();
        this.createPropertiesFile(childResource, "", false);
        Properties p = ResourceTypeUtils.getStringProperties((File)this.m_fileAnticipator.getTempDir(), (String)"snmp/1/eth0");
        ResourceTypeUtilsTest.assertNotNull((String)"properties should not be null", (Object)p);
        ResourceTypeUtilsTest.assertEquals((String)"properties size", (int)0, (int)p.size());
    }

    public void testLoadPropertiesNonEmpty() throws Exception {
        OnmsResource childResource = this.createResource();
        this.createPropertiesFile(childResource, "foo=bar", false);
        Properties p = ResourceTypeUtils.getStringProperties((File)this.m_fileAnticipator.getTempDir(), (String)"snmp/1/eth0");
        ResourceTypeUtilsTest.assertNotNull((String)"properties should not be null", (Object)p);
        ResourceTypeUtilsTest.assertEquals((String)"properties size", (int)1, (int)p.size());
        ResourceTypeUtilsTest.assertNotNull((String)"property 'foo' should exist", (Object)p.get("foo"));
        ResourceTypeUtilsTest.assertEquals((String)"property 'foo' value", (Object)"bar", (Object)p.get("foo"));
    }

    public void testLoadPropertiesDoesNotExist() throws Exception {
        OnmsResource childResource = this.createResource();
        this.createPropertiesFile(childResource, "", true);
        Properties p = ResourceTypeUtils.getStringProperties((File)this.m_fileAnticipator.getTempDir(), (String)"snmp/1/eth0");
        ResourceTypeUtilsTest.assertNull((String)"no properties file was created, so the properties object should be null", (Object)p);
    }

    public void testGetAttributesAtRelativePathWithBogusDirectory() {
        File bogusRrdDirectory = new File("/foo/bogus/blam/cheese/this/really/should/never/exist");
        ResourceTypeUtilsTest.assertFalse((String)("bogus RRD directory " + bogusRrdDirectory + " should not exist"), (boolean)bogusRrdDirectory.exists());
        ResourceTypeUtils.getAttributesAtRelativePath((File)bogusRrdDirectory, (String)"also-should-never-exist");
    }

    private OnmsResource createResource() {
        OnmsResource topResource = new OnmsResource("1", "Node One", (OnmsResourceType)new MockResourceType(), new HashSet(0));
        HashSet<RrdGraphAttribute> attributes = new HashSet<RrdGraphAttribute>(1);
        attributes.add(new RrdGraphAttribute("foo", "1/eth0", "foo.jrb"));
        OnmsResource childResource = new OnmsResource("eth0", "Interface eth0", (OnmsResourceType)new MockResourceType(), attributes);
        childResource.setParent(topResource);
        return childResource;
    }

    private File createPropertiesFile(OnmsResource childResource, String propertiesContent, boolean onlyCreateParentDirectories) throws IOException {
        this.m_fileAnticipator.initialize();
        this.m_snmp = this.m_fileAnticipator.tempDir("snmp");
        this.m_node = this.m_fileAnticipator.tempDir(this.m_snmp, childResource.getParent().getName());
        this.m_intf = this.m_fileAnticipator.tempDir(this.m_node, childResource.getName());
        if (onlyCreateParentDirectories) {
            return new File(this.m_intf, "strings.properties");
        }
        return this.m_fileAnticipator.tempFile(this.m_intf, "strings.properties", propertiesContent);
    }
}

