/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.db.AbstractTransactionalTemporaryDatabaseSpringContextTests;
import org.opennms.netmgt.dao.support.JdbcFilterDao;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.DaoTestConfigBean;
import org.opennms.test.ThrowableAnticipator;

public class JdbcFilterDaoTest
extends AbstractTransactionalTemporaryDatabaseSpringContextTests {
    private NodeDao m_nodeDao;
    private JdbcFilterDao m_dao;
    private DatabasePopulator m_populator;

    protected void setUpConfiguration() {
        DaoTestConfigBean daoTestConfig = new DaoTestConfigBean();
        daoTestConfig.afterPropertiesSet();
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml"};
    }

    public void onSetUpInTransactionIfEnabled() throws Exception {
        super.onSetUpInTransactionIfEnabled();
        this.m_populator.populateDatabase();
        this.setComplete();
        this.endTransaction();
        this.startNewTransaction();
        this.m_dao = new JdbcFilterDao();
        this.m_dao.setDataSource(this.getDataSource());
        this.m_dao.setDatabaseSchemaConfigFactory(new DatabaseSchemaConfigFactory(ConfigurationTestUtils.getReaderForConfigFile((String)"database-schema.xml")));
        this.m_dao.afterPropertiesSet();
    }

    public void testInstantiate() {
        new JdbcFilterDao();
    }

    public void testAfterPropertiesSetValid() throws Exception {
        JdbcFilterDao dao = new JdbcFilterDao();
        dao.setDataSource(this.getDataSource());
        dao.setNodeDao(this.m_nodeDao);
        dao.setDatabaseSchemaConfigFactory(new DatabaseSchemaConfigFactory(ConfigurationTestUtils.getReaderForConfigFile((String)"database-schema.xml")));
        dao.afterPropertiesSet();
    }

    public void testAfterPropertiesSetNoNodeDao() throws Exception {
        JdbcFilterDao dao = new JdbcFilterDao();
        dao.setDataSource(this.getDataSource());
        dao.setDatabaseSchemaConfigFactory(new DatabaseSchemaConfigFactory(ConfigurationTestUtils.getReaderForConfigFile((String)"database-schema.xml")));
        dao.afterPropertiesSet();
    }

    public void testAfterPropertiesSetNoDataSource() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        JdbcFilterDao dao = new JdbcFilterDao();
        dao.setDatabaseSchemaConfigFactory(new DatabaseSchemaConfigFactory(ConfigurationTestUtils.getReaderForConfigFile((String)"database-schema.xml")));
        ta.anticipate((Throwable)new IllegalStateException("property dataSource cannot be null"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testWithManyCatIncAndServiceIdentifiersInRules() throws Exception {
        JdbcFilterDao dao = new JdbcFilterDao();
        dao.setDataSource(this.getDataSource());
        dao.setDatabaseSchemaConfigFactory(new DatabaseSchemaConfigFactory(ConfigurationTestUtils.getReaderForConfigFile((String)"database-schema.xml")));
        dao.afterPropertiesSet();
        String rule = "(catincIMP_mid) & (catincDEV_AC) & (catincOPS_Online) & (nodeId == 1) & (ipAddr == '192.168.1.1') & (serviceName == 'ICMP')";
        JdbcFilterDaoTest.assertTrue((boolean)dao.isRuleMatching(rule));
        String rule2 = "(catincIMP_mid) & (catincDEV_AC) & (catincOPS_Online) & (nodeId == 2) & (ipAddr == '192.168.2.1') & (serviceName == 'ICMP')";
        JdbcFilterDaoTest.assertFalse((boolean)dao.isRuleMatching(rule2));
    }

    public void testAfterPropertiesSetNoSchemaFactory() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        JdbcFilterDao dao = new JdbcFilterDao();
        dao.setDataSource(this.getDataSource());
        ta.anticipate((Throwable)new IllegalStateException("property databaseSchemaConfigFactory cannot be null"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testGetNodeMap() throws Exception {
        SortedMap map = this.m_dao.getNodeMap("ipaddr == '1.1.1.1'");
        JdbcFilterDaoTest.assertNotNull((String)"returned map should not be null", (Object)map);
        JdbcFilterDaoTest.assertEquals((String)"map size", (int)0, (int)map.size());
    }

    public void testGetIPServiceMap() throws Exception {
        Map map = this.m_dao.getIPServiceMap("ipaddr == '1.1.1.1'");
        JdbcFilterDaoTest.assertNotNull((String)"returned map should not be null", (Object)map);
        JdbcFilterDaoTest.assertEquals((String)"map size", (int)0, (int)map.size());
    }

    public void testGetIPList() throws Exception {
        List list = this.m_dao.getIPList("ipaddr == '1.1.1.1'");
        JdbcFilterDaoTest.assertNotNull((String)"returned list should not be null", (Object)list);
        JdbcFilterDaoTest.assertEquals((String)"list size", (int)0, (int)list.size());
    }

    public void testIsValid() throws Exception {
        JdbcFilterDaoTest.assertFalse((String)"There is nothing in the database, so isValid shouldn't match non-empty rules", (boolean)this.m_dao.isValid("1.1.1.1", "ipaddr == '1.1.1.1'"));
    }

    public void testIsValidEmptyRule() throws Exception {
        JdbcFilterDaoTest.assertTrue((String)"isValid should return true for non-empty rules", (boolean)this.m_dao.isValid("1.1.1.1", ""));
    }

    public void testGetInterfaceWithServiceStatement() throws Exception {
        JdbcFilterDaoTest.assertEquals((String)"SQL from getInterfaceWithServiceStatement", (String)"SELECT DISTINCT ipInterface.ipAddr, service.serviceName, node.nodeID FROM ipInterface JOIN ifServices ON (ipInterface.id = ifServices.ipInterfaceId) JOIN service ON (ifServices.serviceID = service.serviceID) JOIN node ON (ipInterface.nodeID = node.nodeID) WHERE IPLIKE(ipInterface.ipaddr, '*.*.*.*')", (String)this.m_dao.getInterfaceWithServiceStatement("ipaddr IPLIKE *.*.*.*"));
    }

    public void testWalkNodes() throws Exception {
        this.m_dao.setNodeDao(this.getNodeDao());
        final ArrayList nodes = new ArrayList();
        AbstractEntityVisitor visitor = new AbstractEntityVisitor(){

            public void visitNode(OnmsNode node) {
                nodes.add(node);
            }
        };
        this.m_dao.walkMatchingNodes("ipaddr == '10.1.1.1'", (EntityVisitor)visitor);
        JdbcFilterDaoTest.assertEquals((String)"node list size", (int)1, (int)nodes.size());
    }

    public void testVariousWaysToMatchServiceNames() {
        JdbcFilterDaoTest.assertEquals((String)"service statement", (String)this.m_dao.getInterfaceWithServiceStatement("isFooService"), (String)this.m_dao.getInterfaceWithServiceStatement("serviceName == 'FooService'"));
        JdbcFilterDaoTest.assertEquals((String)"ip service mapping statement", (String)this.m_dao.getIPServiceMappingStatement("isFooService"), (String)this.m_dao.getIPServiceMappingStatement("serviceName == 'FooService'"));
        JdbcFilterDaoTest.assertEquals((String)"ip service mapping statement", (String)this.m_dao.getNodeMappingStatement("isFooService"), (String)this.m_dao.getNodeMappingStatement("serviceName == 'FooService'"));
        this.m_dao.getInterfaceWithServiceStatement("serviceName == 'DiskUsage-/foo/bar'");
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public DatabasePopulator getPopulator() {
        return this.m_populator;
    }

    public void setPopulator(DatabasePopulator populator) {
        this.m_populator = populator;
    }
}

