/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import junit.framework.AssertionFailedError;
import org.opennms.netmgt.dao.db.PopulatedTemporaryDatabaseTestCase;
import org.opennms.test.ThrowableAnticipator;

public class TriggerTest
extends PopulatedTemporaryDatabaseTestCase {
    public void testSetIpInterfaceIfIndexLikeCapsdDoes() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', null )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1)");
        TriggerTest.assertEquals((String)"ipinterface.id", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT id FROM ipinterface", new Object[0]));
        TriggerTest.assertEquals((String)"snmpinterface.id", (int)2, (int)this.jdbcTemplate.queryForInt("SELECT id FROM snmpinterface", new Object[0]));
        TriggerTest.assertEquals((String)"ifIndex", (int)0, (int)this.jdbcTemplate.queryForInt("SELECT ifIndex FROM ipinterface", new Object[0]));
        this.executeSQL("UPDATE ipInterface SET ifIndex = 1 WHERE nodeID = 1 AND ipAddr = '1.2.3.4'");
        TriggerTest.assertEquals((String)"ifIndex", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT ifIndex FROM ipinterface", new Object[0]));
        TriggerTest.assertEquals((String)"snmpInterfaceId", (int)2, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface WHERE nodeID = ?", new Object[]{1}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetIpInterfaceIfIndexLikeCapsdDoesBadIfIndex() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', null )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1)");
        TriggerTest.assertEquals((String)"ifIndex", (int)0, (int)this.jdbcTemplate.queryForInt("SELECT ifIndex FROM ipinterface", new Object[0]));
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new AssertionFailedError("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            this.executeSQL("UPDATE ipInterface SET ifIndex = 2 WHERE nodeID = 1 AND ipAddr = '1.2.3.4'");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        finally {
            ta.verifyAnticipated();
        }
    }

    public void testSetIpInterfaceIfIndexLikeCapsdButOppositeOrder() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1)");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 1 )");
        TriggerTest.assertEquals((String)"snmpInterfaceId", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface WHERE nodeID = ?", new Object[]{1}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetIpInterfaceIfIndexLikeCapsdButOppositeOrderUpdateWithBadIfIndex() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1)");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 1 )");
        TriggerTest.assertEquals((String)"snmpInterfaceId", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface WHERE nodeID = ?", new Object[]{1}));
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new AssertionFailedError("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            this.executeSQL("UPDATE ipInterface SET ifIndex = 2 WHERE nodeID = 1 AND ipAddr = '1.2.3.4'");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        finally {
            ta.verifyAnticipated();
        }
    }
}

