/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.dao.db.BackupTablesFoundException;
import org.opennms.netmgt.dao.db.Column;
import org.opennms.netmgt.dao.db.Constraint;
import org.opennms.netmgt.dao.db.InstallerDb;
import org.opennms.netmgt.dao.db.Table;
import org.opennms.netmgt.dao.db.TemporaryDatabaseTestCase;
import org.opennms.netmgt.dao.db.Trigger;
import org.opennms.test.ThrowableAnticipator;
import org.springframework.util.StringUtils;

public class InstallerDbTest
extends TemporaryDatabaseTestCase {
    private static final String s_constraint = "fk_nodeid6";
    private InstallerDb m_installerDb;
    private Connection m_connection;
    private ByteArrayOutputStream m_outputStream;

    protected void setUp() throws Exception {
        super.setUp();
        if (!InstallerDbTest.isEnabled()) {
            return;
        }
        this.m_installerDb = new InstallerDb();
        this.resetOutputStream();
        this.getInstallerDb().setDatabaseName(this.getTestDatabase());
        this.m_installerDb.setPostgresOpennmsUser("opennms");
        this.getInstallerDb().setCreateSqlLocation("../opennms-daemon/src/main/filtered/etc/create.sql");
        this.getInstallerDb().setStoredProcedureDirectory("../opennms-daemon/src/main/filtered/etc");
        this.getInstallerDb().readTables();
        this.getInstallerDb().setDataSource(this.getDataSource());
        this.getInstallerDb().addColumnReplacements();
        this.m_connection = this.getInstallerDb().getDataSource().getConnection();
    }

    public void tearDown() throws Exception {
        if (InstallerDbTest.isEnabled()) {
            this.m_installerDb.closeColumnReplacements();
            this.m_connection.close();
            this.getInstallerDb().closeConnection();
        }
        super.tearDown();
    }

    public void testParseSQLTables() throws Exception {
        for (String table : this.getInstallerDb().getTableNames()) {
            this.getInstallerDb().getTableFromSQL(table);
        }
    }

    public void testCreateSequences() throws Exception {
        this.getInstallerDb().createSequences();
    }

    public void testCreateTables() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.getInstallerDb().createTables();
    }

    public void testCreateTablesTwice() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.getInstallerDb().createTables();
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.resetOutputStream();
        this.getInstallerDb().createTables();
        this.assertNoTablesHaveChanged();
    }

    public void testInsertCriteria() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.getInstallerDb().createTables();
        this.getInstallerDb().insertData();
        this.getInstallerDb().insertData();
    }

    public void testUpgradeRevision3952ToCurrent() throws Exception {
        String newCreate = this.getInstallerDb().getCreateSqlLocation();
        URL sql = ((Object)((Object)this)).getClass().getResource("/create.sql-revision-3952");
        InstallerDbTest.assertNotNull((String)"Could not find create.sql", (Object)sql);
        this.getInstallerDb().setCreateSqlLocation(sql.getFile());
        this.getInstallerDb().readTables();
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.getInstallerDb().createTables();
        this.getInstallerDb().setCreateSqlLocation(newCreate);
        this.getInstallerDb().readTables();
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.getInstallerDb().createTables();
    }

    public void testUpgradeRevision3952ToCurrentWithData() throws Exception {
        String newCreate = this.getInstallerDb().getCreateSqlLocation();
        URL sql = ((Object)((Object)this)).getClass().getResource("/create.sql-revision-3952");
        InstallerDbTest.assertNotNull((String)"Could not find create.sql", (Object)sql);
        this.getInstallerDb().setCreateSqlLocation(sql.getFile());
        this.getInstallerDb().readTables();
        this.getInstallerDb().createSequences();
        this.getInstallerDb().getTriggerDao().reset();
        this.getInstallerDb().createTables();
        this.executeSQL("INSERT INTO node ( nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.6', -100 )");
        this.executeSQL("INSERT INTO ipInterface ( nodeId, ipAddr, ifIndex ) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO ipInterface ( nodeId, ipAddr, ifIndex ) VALUES ( 1, '1.2.3.5', null )");
        this.executeSQL("INSERT INTO ipInterface ( nodeId, ipAddr, ifIndex ) VALUES ( 1, '1.2.3.6', -100 )");
        this.executeSQL("INSERT INTO service ( serviceID, serviceName ) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO service ( serviceID, serviceName ) VALUES ( 2, 'TEA-READY' )");
        this.executeSQL("INSERT INTO ifServices ( nodeID, ipAddr, ifIndex, serviceID ) VALUES ( 1, '1.2.3.4', 1, 1 )");
        this.executeSQL("INSERT INTO ifServices ( nodeID, ipAddr, ifIndex, serviceID ) VALUES ( 1, '1.2.3.5', null, 1 )");
        this.executeSQL("INSERT INTO ifServices ( nodeID, ipAddr, ifIndex, serviceID ) VALUES ( 1, '1.2.3.6', -100, 1 )");
        this.executeSQL("INSERT INTO outages ( outageId, nodeId, ipAddr, ifLostService, serviceID ) VALUES ( nextval('outageNxtId'), 1, '1.2.3.4', now(), 1 )");
        this.executeSQL("INSERT INTO outages ( outageId, nodeId, ipAddr, ifLostService, serviceID ) VALUES ( nextval('outageNxtId'), 1, '1.2.3.5', now(), 1 )");
        this.executeSQL("INSERT INTO outages ( outageId, nodeId, ipAddr, ifLostService, serviceID ) VALUES ( nextval('outageNxtId'), 1, '1.2.3.6', now(), 1 )");
        this.executeSQL("INSERT INTO events (eventID, eventUei, eventTime, eventSource, eventDpName, eventCreateTime, eventSeverity, eventLog, eventDisplay) VALUES ( nextval('eventsNxtId'), 'uei.opennms.org/foo', now(), 'somewhere', 'rainbow', now(), 0, 'Y', 'Y')");
        int eventId = this.jdbcTemplate.queryForInt("select eventId from events", new Object[0]);
        Date eventTime = (Date)this.jdbcTemplate.queryForObject("select eventTime from events where eventId = ?", Date.class, new Object[]{eventId});
        this.getInstallerDb().setCreateSqlLocation(newCreate);
        this.getInstallerDb().readTables();
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.getInstallerDb().createTables();
        Date newEventTime = (Date)this.jdbcTemplate.queryForObject("select eventTime from events where eventId = ?", Date.class, new Object[]{eventId});
        String localFailureMessage = "time for eventId " + eventId + " does not match between old and new (in local time zone): " + eventTime + " (" + new Date(eventTime.getTime()) + ") -> " + newEventTime + " (" + new Date(newEventTime.getTime()) + ")";
        InstallerDbTest.assertEquals((String)localFailureMessage, (Object)eventTime, (Object)newEventTime);
        this.jdbcTemplate.getJdbcOperations().execute("SET TIME ZONE 'UTC'");
        Date utcEventTime = (Date)this.jdbcTemplate.queryForObject("select eventTime from events where eventId = ?", Date.class, new Object[]{eventId});
        String utcFailureMessage = "time for eventId " + eventId + " does not match between old and new (in UTC): " + eventTime + " (" + new Date(eventTime.getTime()) + ") -> " + utcEventTime + " (" + new Date(utcEventTime.getTime()) + ")";
        InstallerDbTest.assertEquals((String)utcFailureMessage, (Object)eventTime, (Object)utcEventTime);
    }

    public void testUpgradeColumnAddNotNullConstraint() throws Exception {
        Table oldTable = new Table();
        oldTable.setName("node");
        oldTable.setConstraints(new LinkedList());
        LinkedList<Column> oldColumns = new LinkedList<Column>();
        Column oldColumn = new Column();
        oldColumn.setName("nodeId");
        oldColumn.setType("INTEGER");
        oldColumn.setSize(4);
        oldColumns.add(oldColumn);
        oldTable.setColumns(oldColumns);
        oldTable.setNotNullOnPrimaryKeyColumns();
        Table newTable = new Table();
        newTable.setName("node");
        newTable.setConstraints(new LinkedList());
        LinkedList<Column> newColumns = new LinkedList<Column>();
        Column newColumn = new Column();
        newColumn.setName("nodeId");
        newColumn.setType("INTEGER");
        newColumn.setSize(4);
        newColumn.setNotNull(true);
        newColumns.add(newColumn);
        newTable.setColumns(newColumns);
        newTable.setNotNullOnPrimaryKeyColumns();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new Exception("Column nodeid in new table has NOT NULL constraint, however this column did not have the NOT NULL constraint before and there is no change replacement for this column"));
        try {
            this.getInstallerDb().changeTable("node", oldTable, newTable);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testBug1006NoOldTables() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        try {
            this.getInstallerDb().checkOldTables();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testBug1006HasOldTables() throws SQLException {
        String table = "testBug1006_old_" + System.currentTimeMillis();
        Statement st = this.m_connection.createStatement();
        st.execute("CREATE TABLE " + table + " ( foo integer )");
        st.close();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        LinkedList<String> l = new LinkedList<String>();
        l.add(table);
        ta.anticipate((Throwable)new BackupTablesFoundException(l));
        try {
            this.getInstallerDb().checkOldTables();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void setupBug931(boolean breakConstraint, boolean dropForeignTable) throws Exception {
        this.setupBug931(breakConstraint, dropForeignTable, true);
    }

    public void setupBug931(boolean breakConstraint, boolean dropForeignTable, boolean useOwnCreateSql) throws Exception {
        String[] commands = new String[]{"CREATE TABLE events ( nodeID integer )", "CREATE TABLE node ( nodeID integer )", "INSERT INTO events ( nodeID ) VALUES ( 1 )", "INSERT INTO node ( nodeID ) VALUES ( 1 )", "INSERT INTO events ( nodeID ) VALUES ( 2 )", "INSERT INTO node ( nodeID ) VALUES ( 2 )"};
        String newSql = "CREATE TABLE events ( nodeID integer, constraint fk_nodeID6 foreign key (nodeID) references node (nodeID) ON DELETE CASCADE );\n";
        this.executeSQL(commands);
        if (breakConstraint) {
            this.executeSQL("DELETE FROM node where nodeID = 2");
        }
        if (dropForeignTable) {
            this.executeSQL("DROP TABLE node");
            if (!breakConstraint) {
                this.executeSQL("UPDATE events SET nodeID = NULL WHERE nodeID IS NOT NULL");
            }
        }
        if (useOwnCreateSql) {
            this.getInstallerDb().readTables((Reader)new StringReader("CREATE TABLE events ( nodeID integer, constraint fk_nodeID6 foreign key (nodeID) references node (nodeID) ON DELETE CASCADE );\n"));
        }
    }

    public void testBug931ConstraintsOkayTwoTables() throws Exception {
        this.doTestBug931(false, 0, false, false);
    }

    public void testBug931ConstraintsOkayOneTable() throws Exception {
        this.doTestBug931(true, 0, false, false);
    }

    public void testBug931ConstraintsBadTwoTables() throws Exception {
        this.doTestBug931(false, 1, false, false);
    }

    public void testBug931ConstraintsBadOneTable() throws Exception {
        this.doTestBug931(true, 2, false, false);
    }

    public void testConstraintsFixedNullTwoTables() throws Exception {
        this.doTestBug931(false, 0, true, false);
    }

    public void testConstraintsFixedNullOneTable() throws Exception {
        this.doTestBug931(true, 0, true, false);
    }

    public void testConstraintsFixedDelTwoTables() throws Exception {
        this.doTestBug931(false, 0, true, true);
    }

    public void testConstraintsFixedDelOneTable() throws Exception {
        this.doTestBug931(true, 0, true, true);
    }

    public void testBogusConstraintName() throws Exception {
        String constraint = "bogus_test_" + System.currentTimeMillis();
        this.doTestBogusConstraint(constraint, "Did not find constraint " + constraint + " in the database.");
    }

    public void testBogusConstraintTable() throws Exception {
        String constraint = "fk_nodeid1";
        this.doTestBogusConstraint(constraint, "Constraint " + constraint + " is on table " + "ipinterface, but table does not exist (so fixing this constraint does nothing).");
    }

    public void testBogusConstraintColumn() throws Exception {
        String constraint = "fk_dpname";
        this.doTestBogusConstraint(constraint, "Constraint " + constraint + " constrains column " + "dpname of table node, but column does not " + "exist (so fixing this constraint does nothing).");
    }

    public void testConstraintAfterConstrainedColumn() throws Exception {
        String s_create_sql = "            create table distPoller (\n                    dpName            varchar(12),\n                                constraint pk_dpName primary key (dpName),\n                    dpIP            varchar(16) not null,\n                    dpComment        varchar(256),\n                    dpDiscLimit        numeric(5,2),\n                    dpLastNodePull        timestamp without time zone,\n                    dpLastEventPull        timestamp without time zone,\n                    dpLastPackagePush    timestamp without time zone,\n                    dpAdminState         integer,\n                    dpRunState        integer );\n";
        this.getInstallerDb().readTables((Reader)new StringReader(s_create_sql));
        this.getInstallerDb().getTableColumnsFromSQL("distpoller");
    }

    public void testConstraintAtEndOfTable() throws Exception {
        String s_create_sql = "            create table distPoller (\n                    dpName            varchar(12),\n                    dpIP            varchar(16) not null,\n                    dpComment        varchar(256),\n                    dpDiscLimit        numeric(5,2),\n                    dpLastNodePull        timestamp without time zone,\n                    dpLastEventPull        timestamp without time zone,\n                    dpLastPackagePush    timestamp without time zone,\n                    dpAdminState         integer,\n                    dpRunState        integer,\n                                constraint pk_dpName primary key (dpName) );\n";
        this.getInstallerDb().readTables((Reader)new StringReader(s_create_sql));
        this.getInstallerDb().getTableColumnsFromSQL("distpoller");
    }

    public void testConstraintIpInterfaceSnmpInterfaceValidData() throws Exception {
        String newCreate = this.getInstallerDb().getCreateSqlLocation();
        URL sql = ((Object)((Object)this)).getClass().getResource("/create.sql-revision-3952");
        InstallerDbTest.assertNotNull((String)"Could not find create.sql", (Object)sql);
        this.getInstallerDb().setCreateSqlLocation(sql.getFile());
        this.getInstallerDb().readTables();
        this.getInstallerDb().createSequences();
        this.getInstallerDb().getTriggerDao().reset();
        this.getInstallerDb().createTables();
        this.executeSQL("INSERT INTO node ( nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.6', -100 )");
        this.executeSQL("INSERT INTO ipInterface ( nodeId, ipAddr, ifIndex ) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO ipInterface ( nodeId, ipAddr, ifIndex ) VALUES ( 1, '1.2.3.5', null )");
        this.executeSQL("INSERT INTO ipInterface ( nodeId, ipAddr, ifIndex ) VALUES ( 1, '1.2.3.6', -100 )");
        this.getInstallerDb().setCreateSqlLocation(newCreate);
        this.getInstallerDb().readTables();
        this.getInstallerDb().checkConstraints();
    }

    public void testConstraintIpInterfaceSnmpInterfaceInvalidData() throws Exception {
        String newCreate = this.getInstallerDb().getCreateSqlLocation();
        URL sql = ((Object)((Object)this)).getClass().getResource("/create.sql-revision-3952");
        InstallerDbTest.assertNotNull((String)"Could not find create.sql", (Object)sql);
        this.getInstallerDb().setCreateSqlLocation(sql.getFile());
        this.getInstallerDb().readTables();
        this.getInstallerDb().createSequences();
        this.getInstallerDb().getTriggerDao().reset();
        this.getInstallerDb().createTables();
        this.executeSQL("INSERT INTO node ( nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO ipInterface ( nodeId, ipAddr, ifIndex ) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO ipInterface ( nodeId, ipAddr, ifIndex ) VALUES ( 1, '1.2.3.5', null )");
        this.getInstallerDb().setCreateSqlLocation(newCreate);
        this.getInstallerDb().readTables();
        this.getInstallerDb().checkConstraints();
    }

    public void testConstraintOnBogusColumn() throws Exception {
        String s_create_sql = "            create table distPoller (\n                    dpName            varchar(12),\n                    dpIP            varchar(16) not null,\n                    dpComment        varchar(256),\n                    dpDiscLimit        numeric(5,2),\n                    dpLastNodePull        timestamp without time zone,\n                    dpLastEventPull        timestamp without time zone,\n                    dpLastPackagePush    timestamp without time zone,\n                    dpAdminState         integer,\n                    dpRunState        integer,\n                                constraint pk_dpName primary key (dpNameBogus) );\n";
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new Exception("constraint pk_dpname references column \"dpnamebogus\", which is not a column in the table distpoller"));
        this.getInstallerDb().readTables((Reader)new StringReader(s_create_sql));
        try {
            this.getInstallerDb().getTableColumnsFromSQL("distpoller");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void doTestBogusConstraint(String constraint, String exceptionMessage) throws Exception {
        this.setupBug931(false, false, false);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new Exception(exceptionMessage));
        try {
            this.getInstallerDb().fixConstraint(constraint, false);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void doTestBug931(boolean dropForeignTable, int badRows, boolean fixConstraint, boolean removeRows) throws Exception {
        String errorSubstring = dropForeignTable ? "Table events contains " + badRows + " rows (out of 2) that violate new constraint " + s_constraint + ".  See the install guide for details on how to correct this " + "problem.  You can execute this SQL query to see a list of " + "the rows that violate the constraint:\n" + "SELECT * FROM events WHERE events.nodeid IS NOT NULL" : "Table events contains " + badRows + " rows (out of 2) that violate new constraint " + s_constraint + ".  See the install guide for details on how to correct this " + "problem.  You can execute this SQL query to see a list of " + "the rows that violate the constraint:\n" + "SELECT * FROM events LEFT JOIN node ON (events.nodeid = " + "node.nodeid) WHERE node.nodeid is NULL AND events.nodeid " + "IS NOT NULL";
        this.setupBug931(badRows != 0 || fixConstraint, dropForeignTable);
        if (fixConstraint) {
            this.getInstallerDb().fixConstraint(s_constraint, removeRows);
        }
        ThrowableAnticipator ta = new ThrowableAnticipator();
        if (badRows > 0) {
            ta.anticipate((Throwable)new Exception(errorSubstring));
        }
        try {
            this.getInstallerDb().checkConstraints();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testParseConstraintWithOnUpdateCascade() throws Exception {
        String createSQL = "create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on update cascade\n);\n";
        this.getInstallerDb().readTables((Reader)new StringReader("create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on update cascade\n);\n"));
        this.getInstallerDb().getTableFromSQL("a");
        this.getInstallerDb().getTableFromSQL("b");
    }

    public void testGetFromDbConstraintWithOnUpdateCascade() throws Exception {
        String createSQL = "create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on update cascade\n);\n";
        this.executeSQL("create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on update cascade\n);\n");
        List columns = this.getInstallerDb().getColumnsFromDB("b");
        InstallerDbTest.assertNotNull((String)"column list not null", (Object)columns);
        List constraints = this.getInstallerDb().getConstraintsFromDB("b");
        InstallerDbTest.assertNotNull((String)"constraint list not null", (Object)constraints);
        InstallerDbTest.assertEquals((String)"constraint list size", (int)1, (int)constraints.size());
        InstallerDbTest.assertEquals((String)"constraint zero toString()", (String)"constraint fk_a foreign key (b1) references a (a1) on update cascade", (String)((Constraint)constraints.get(0)).toString());
    }

    public void testParseConstraintWithOnDeleteRestrict() throws Exception {
        String createSQL = "create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on delete restrict\n);\n";
        this.getInstallerDb().readTables((Reader)new StringReader("create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on delete restrict\n);\n"));
        this.getInstallerDb().getTableFromSQL("a");
        this.getInstallerDb().getTableFromSQL("b");
    }

    public void testGetFromDbConstraintWithOnDeleteRestrict() throws Exception {
        String createSQL = "create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on delete restrict\n);\n";
        this.executeSQL("create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on delete restrict\n);\n");
        List columns = this.getInstallerDb().getColumnsFromDB("b");
        InstallerDbTest.assertNotNull((String)"column list not null", (Object)columns);
        List constraints = this.getInstallerDb().getConstraintsFromDB("b");
        InstallerDbTest.assertNotNull((String)"constraint list not null", (Object)constraints);
        InstallerDbTest.assertEquals((String)"constraint list size", (int)1, (int)constraints.size());
        InstallerDbTest.assertEquals((String)"constraint zero toString()", (String)"constraint fk_a foreign key (b1) references a (a1) on delete restrict", (String)((Constraint)constraints.get(0)).toString());
    }

    public void testParseConstraintWithOnDeleteSetDefault() throws Exception {
        String createSQL = "create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on delete set default\n);\n";
        this.getInstallerDb().readTables((Reader)new StringReader("create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on delete set default\n);\n"));
        this.getInstallerDb().getTableFromSQL("a");
        this.getInstallerDb().getTableFromSQL("b");
    }

    public void testGetFromDbConstraintWithOnDeleteSetDefault() throws Exception {
        String createSQL = "create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on delete set default\n);\n";
        this.executeSQL("create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on delete set default\n);\n");
        List columns = this.getInstallerDb().getColumnsFromDB("b");
        InstallerDbTest.assertNotNull((String)"column list not null", (Object)columns);
        List constraints = this.getInstallerDb().getConstraintsFromDB("b");
        InstallerDbTest.assertNotNull((String)"constraint list not null", (Object)constraints);
        InstallerDbTest.assertEquals((String)"constraint list size", (int)1, (int)constraints.size());
        InstallerDbTest.assertEquals((String)"constraint zero toString()", (String)"constraint fk_a foreign key (b1) references a (a1) on delete set default", (String)((Constraint)constraints.get(0)).toString());
    }

    public void testParseConstraintWithOnDeleteSetNull() throws Exception {
        String createSQL = "create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on delete set null\n);\n";
        this.getInstallerDb().readTables((Reader)new StringReader("create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on delete set null\n);\n"));
        this.getInstallerDb().getTableFromSQL("a");
        this.getInstallerDb().getTableFromSQL("b");
    }

    public void testGetFromDbConstraintWithOnDeleteSetNull() throws Exception {
        String createSQL = "create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on delete set null\n);\n";
        this.executeSQL("create table a (\n    a1           integer,\n    constraint pk_a primary key (a1)\n);\ncreate table b (\n    b1           integer,\n    constraint fk_a foreign key (b1) references a (a1) on delete set null\n);\n");
        List columns = this.getInstallerDb().getColumnsFromDB("b");
        InstallerDbTest.assertNotNull((String)"column list not null", (Object)columns);
        List constraints = this.getInstallerDb().getConstraintsFromDB("b");
        InstallerDbTest.assertNotNull((String)"constraint list not null", (Object)constraints);
        InstallerDbTest.assertEquals((String)"constraint list size", (int)1, (int)constraints.size());
        InstallerDbTest.assertEquals((String)"constraint zero toString()", (String)"constraint fk_a foreign key (b1) references a (a1) on delete set null", (String)((Constraint)constraints.get(0)).toString());
    }

    public void testParsePrimaryKeyMultipleColumns() throws Exception {
        String createSQL = "create table Element (\n    mapId           integer,\n    elementId       integer,\n    somethingElse       varchar(80),\n    constraint pk_Element primary key (mapId, elementId)\n);";
        this.getInstallerDb().readTables((Reader)new StringReader("create table Element (\n    mapId           integer,\n    elementId       integer,\n    somethingElse       varchar(80),\n    constraint pk_Element primary key (mapId, elementId)\n);"));
        Table table = this.getInstallerDb().getTableFromSQL("element");
        List columns = table.getColumns();
        InstallerDbTest.assertNotNull((String)"column list is not null", (Object)columns);
        InstallerDbTest.assertEquals((String)"column count", (int)3, (int)columns.size());
        InstallerDbTest.assertEquals((String)"column zero toString()", (String)"mapid integer(4) NOT NULL", (String)((Column)columns.get(0)).toString());
        InstallerDbTest.assertEquals((String)"column one toString()", (String)"elementid integer(4) NOT NULL", (String)((Column)columns.get(1)).toString());
        InstallerDbTest.assertEquals((String)"column two toString()", (String)"somethingelse character varying(80)", (String)((Column)columns.get(2)).toString());
        List foo = table.getConstraints();
        InstallerDbTest.assertNotNull((String)"constraint list is not null", (Object)foo);
        InstallerDbTest.assertEquals((String)"constraint count is one", (int)1, (int)foo.size());
        Constraint f = (Constraint)foo.get(0);
        InstallerDbTest.assertNotNull((String)"constraint zero is not null", (Object)f);
        InstallerDbTest.assertEquals((String)"constraint getTable()", (String)"element", (String)f.getTable());
        InstallerDbTest.assertEquals((String)"constraint zero toString()", (String)"constraint pk_element primary key (mapid, elementid)", (String)f.toString());
    }

    public void testInsertMultipleColumns() throws SQLException {
        String command = "CREATE TABLE qrtz_job_details (\n  JOB_NAME  VARCHAR(80) NOT NULL,\n  JOB_GROUP VARCHAR(80) NOT NULL,\n  CONSTRAINT pk_qrtz_job_details PRIMARY KEY (JOB_NAME,JOB_GROUP)\n)";
        this.executeSQL(command);
    }

    public void testInsertMultipleColumnsGetFromDB() throws Exception {
        String command = "CREATE TABLE qrtz_job_details (\n  JOB_NAME  VARCHAR(80) NOT NULL,\n  JOB_GROUP VARCHAR(80) NOT NULL,\n  CONSTRAINT pk_qrtz_job_details PRIMARY KEY (JOB_NAME,JOB_GROUP)\n)";
        this.executeSQL(command);
        this.getInstallerDb().getTableColumnsFromDB("qrtz_job_details");
    }

    public void testInsertMultipleColumnsGetFromDBCompare() throws Exception {
        String command = "CREATE TABLE qrtz_job_details (\n  JOB_NAME  VARCHAR(80) NOT NULL,\n  JOB_GROUP VARCHAR(80) NOT NULL,\n  CONSTRAINT pk_qrtz_job_details PRIMARY KEY (JOB_NAME,JOB_GROUP)\n)";
        this.executeSQL(command);
        Table table = this.getInstallerDb().getTableFromDB("qrtz_job_details");
        InstallerDbTest.assertNotNull((String)"table not null", (Object)table);
        List constraints = table.getConstraints();
        InstallerDbTest.assertNotNull((String)"constraints not null", (Object)constraints);
        InstallerDbTest.assertEquals((String)"constraints size equals one", (int)1, (int)constraints.size());
        InstallerDbTest.assertEquals((String)"constraint zero toString()", (String)"constraint pk_qrtz_job_details primary key (job_name, job_group)", (String)((Constraint)constraints.get(0)).toString());
    }

    public void testGetColumnsFromDB() throws Exception {
        String command = "CREATE TABLE qrtz_job_details (\n  JOB_NAME  VARCHAR(80) NOT NULL,\n  JOB_GROUP VARCHAR(80) NOT NULL,\n  CONSTRAINT pk_qrtz_job_details PRIMARY KEY (JOB_NAME,JOB_GROUP)\n)";
        this.executeSQL(command);
        List columns = this.getInstallerDb().getColumnsFromDB("qrtz_job_details");
        InstallerDbTest.assertNotNull((String)"column list not null", (Object)columns);
        InstallerDbTest.assertEquals((String)"column list size", (int)2, (int)columns.size());
        InstallerDbTest.assertEquals((String)"column zero toString()", (String)"job_name character varying(80) NOT NULL", (String)((Column)columns.get(0)).toString());
        InstallerDbTest.assertEquals((String)"column one toString()", (String)"job_group character varying(80) NOT NULL", (String)((Column)columns.get(1)).toString());
    }

    public void testGetColumnsFromDBWithDefaultIntegerConstant() throws Exception {
        String command = "CREATE TABLE alarms (\n  x733ProbableCause INTEGER DEFAULT 17 NOT NULL\n)";
        this.executeSQL(command);
        List columns = this.getInstallerDb().getColumnsFromDB("alarms");
        InstallerDbTest.assertNotNull((String)"column list not null", (Object)columns);
        InstallerDbTest.assertEquals((String)"column list size", (int)1, (int)columns.size());
        InstallerDbTest.assertEquals((String)"column zero toString()", (String)"x733probablecause integer(4) DEFAULT 17 NOT NULL", (String)((Column)columns.get(0)).toString());
    }

    public void testGetColumnsFromDBWithDefaultTextConstant() throws Exception {
        String command = "CREATE TABLE alarms (\n  someColumn VARCHAR(20) DEFAULT 'HeLlO!' NOT NULL\n)";
        this.executeSQL(command);
        List columns = this.getInstallerDb().getColumnsFromDB("alarms");
        InstallerDbTest.assertNotNull((String)"column list not null", (Object)columns);
        InstallerDbTest.assertEquals((String)"column list size", (int)1, (int)columns.size());
        InstallerDbTest.assertEquals((String)"column zero toString()", (String)"somecolumn character varying(20) DEFAULT 'HeLlO!' NOT NULL", (String)((Column)columns.get(0)).toString());
    }

    public void testGetColumnsFromDBWithDefaultNextVal() throws Exception {
        this.executeSQL("create sequence opennmsNxtId minvalue 1");
        String command = "CREATE TABLE alarms (\n  x733ProbableCause INTEGER DEFAULT nextval('opennmsNxtId') NOT NULL\n)";
        this.executeSQL(command);
        List columns = this.getInstallerDb().getColumnsFromDB("alarms");
        InstallerDbTest.assertNotNull((String)"column list not null", (Object)columns);
        InstallerDbTest.assertEquals((String)"column list size", (int)1, (int)columns.size());
        InstallerDbTest.assertEquals((String)"column zero toString()", (String)"x733probablecause integer(4) DEFAULT nextval('opennmsnxtid') NOT NULL", (String)((Column)columns.get(0)).toString());
    }

    public void testGetConstraintsFromDB() throws Exception {
        String command = "CREATE TABLE qrtz_job_details (\n  JOB_NAME  VARCHAR(80) NOT NULL,\n  JOB_GROUP VARCHAR(80) NOT NULL,\n  CONSTRAINT pk_qrtz_job_details PRIMARY KEY (JOB_NAME,JOB_GROUP)\n)";
        this.executeSQL(command);
        List columns = this.getInstallerDb().getColumnsFromDB("qrtz_job_details");
        InstallerDbTest.assertNotNull((String)"column list not null", (Object)columns);
        List constraints = this.getInstallerDb().getConstraintsFromDB("qrtz_job_details");
        InstallerDbTest.assertNotNull((String)"constraint list not null", (Object)constraints);
        InstallerDbTest.assertEquals((String)"constraint list size", (int)1, (int)constraints.size());
        InstallerDbTest.assertEquals((String)"constraint zero toString()", (String)"constraint pk_qrtz_job_details primary key (job_name, job_group)", (String)((Constraint)constraints.get(0)).toString());
    }

    public void testSetEventSourceOnUpgrade() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQLWithReplacements("events", new String[][]{{"eventSource\\s+varchar\\(\\d+\\) not null,", ""}}, true);
        this.executeSQL("INSERT INTO events (eventID, eventUei, eventTime, eventDpName, eventCreateTime, eventSeverity, eventLog, eventDisplay) VALUES ( 1, 'uei.opennms.org/eatmyshorts', now(), 'Duh', now(), 1, 'n', 'n' )");
        this.getInstallerDb().createTables();
        Statement st = this.m_connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT eventsource from events");
        int count = 0;
        while (rs.next()) {
            InstallerDbTest.assertEquals((String)"expected events eventsrource", (String)"OpenNMS.Eventd", (String)rs.getString(1));
            ++count;
        }
        InstallerDbTest.assertEquals((String)"expected column count", (int)1, (int)count);
    }

    public void XXXtestSetOutageIdOnUpgrade() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQL("ipinterface");
        this.addTableFromSQL("service");
        this.addTableFromSQL("ifservices");
        this.addTableFromSQL("events");
        this.addTableFromSQLWithReplacements("outages", new String[][]{{"outageID\\s+integer not null,", ""}, {"constraint pk_outageID primary key \\(outageID\\),", ""}}, true);
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', null )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO ifServices (id, nodeID, ipAddr, ifIndex, serviceID, ipInterfaceId) VALUES ( 1, 1, '1.2.3.4', null, 1, 1 )");
        this.executeSQL("INSERT INTO outages (nodeId, ipAddr, ifLostService, serviceId, ifServiceId ) VALUES ( 1, '1.2.3.4', now(), 1, 1 )");
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.getInstallerDb().createTables();
        Statement st = this.m_connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT outageid from outages");
        int count = 0;
        int expected = 1;
        while (rs.next()) {
            InstallerDbTest.assertEquals((String)"expected outages outageid", (int)expected, (int)rs.getInt(1));
            ++count;
            ++expected;
        }
        InstallerDbTest.assertEquals((String)"expected column count", (int)1, (int)count);
    }

    public void testSomethingUnknown() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQL("ipinterface");
        this.addTableFromSQL("service");
        this.addTableFromSQL("ifservices");
        this.addTableFromSQL("events");
        this.addTableFromSQL("outages");
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', null )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO ifServices (id, nodeID, ipAddr, ifIndex, serviceID, ipInterfaceId) VALUES ( 1, 1, '1.2.3.4', null, 1, 1 )");
        this.executeSQL("INSERT INTO outages ( outageID, nodeId, ipAddr, ifLostService, serviceId, ifServiceId ) VALUES ( 1, 1, '1.2.3.4', now(), 1, 1 )");
        this.getInstallerDb().createTables();
        Statement st = this.m_connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT svcregainedeventid from outages");
        int count = 0;
        while (rs.next()) {
            InstallerDbTest.assertEquals((String)"expected outages svcregainedeventid", (int)0, (int)rs.getInt(1));
            ++count;
        }
        InstallerDbTest.assertEquals((String)"expected column count", (int)1, (int)count);
    }

    public void testSetUsersNotifiedIdOnUpgrade() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQL("ipinterface");
        this.addTableFromSQL("service");
        this.addTableFromSQL("ifservices");
        this.addTableFromSQL("events");
        this.addTableFromSQL("notifications");
        this.addTableFromSQLWithReplacements("usersnotified", new String[][]{{"id\\s+integer not null, ", ""}, {"constraint pk_userNotificationID primary key \\(id\\),", ""}});
        this.executeSQL("INSERT INTO usersNotified (userID) VALUES ('DJ... it is always his fault')");
        this.getInstallerDb().createTables();
        Statement st = this.m_connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT id from usersnotified");
        int count = 0;
        int expected = 1;
        while (rs.next()) {
            InstallerDbTest.assertEquals((String)"expected usersNotified id", (int)expected, (int)rs.getInt(1));
            ++count;
            ++expected;
        }
        InstallerDbTest.assertEquals((String)"expected column count", (int)1, (int)count);
    }

    public void testSetSnmpInterfaceIdOnUpgrade() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQLWithReplacements("snmpinterface", new String[][]{{"(?i)id\\s+INTEGER DEFAULT nextval\\('opennmsNxtId'\\) NOT NULL,", ""}, {"(?i)CONSTRAINT snmpinterface_pkey primary key \\(id\\),", ""}});
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES (1, '1.2.3.4', 1)");
        this.getInstallerDb().createTables();
        Statement st = this.m_connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT id from snmpInterface");
        int count = 0;
        int expected = 1;
        while (rs.next()) {
            InstallerDbTest.assertEquals((String)"expected usersNotified id", (int)expected, (int)rs.getInt(1));
            ++count;
            ++expected;
        }
        InstallerDbTest.assertEquals((String)"expected column count", (int)1, (int)count);
    }

    public void testCatchSnmpInterfaceNullNodeIdColumnOnUpgrade() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQLWithReplacements("snmpinterface", new String[][]{{"(?i)nodeID\\s+integer not null,", "nodeId integer,"}});
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.getInstallerDb().createTables();
        Statement st = this.m_connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT id from snmpInterface");
        InstallerDbTest.assertTrue((String)"Could not ResultSet.next() to first result entry", (boolean)rs.next());
        rs.getInt(1);
        InstallerDbTest.assertFalse((String)"first result should not be null, but was null", (boolean)rs.wasNull());
        InstallerDbTest.assertFalse((String)"Too many entries", (boolean)rs.next());
    }

    public void testCatchSnmpInterfaceHasNullNodeIdValueOnUpgrade() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQLWithReplacements("snmpinterface", new String[][]{{"(?i)nodeID\\s+integer not null,", "nodeId integer,"}});
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( null, '1.2.3.4', 1 )");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new Exception("Error changing table 'snmpinterface'.  Nested exception: The 'nodeId' column in the 'snmpInterface' table should never be null, but the entry for this row does have a null 'nodeId' column.  It needs to be removed or udpated to reflect a valid 'nodeId' value."));
        try {
            this.getInstallerDb().createTables();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testCatchIpInterfaceNullIpAddrColumnOnUpgrade() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQLWithReplacements("ipinterface", new String[][]{{"(?i)ipAddr\\s+varchar\\(16\\) not null,", "ipAddr varchar(16),"}});
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', null )");
        this.getInstallerDb().createTables();
    }

    public void testCatchIpInterfaceHasNullIpAddrValueOnUpgrade() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQLWithReplacements("ipinterface", new String[][]{{"(?i)ipAddr\\s+varchar\\(16\\) not null,", "ipAddr varchar(16),"}});
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, null, 1 )");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new Exception("Error changing table 'ipinterface'.  Nested exception: The 'ipAddr' column in the 'ipInterface' table should never be null, but the entry for this row does have a null 'ipAddr' column.  It needs to be removed or udpated to reflect a valid 'ipAddr' value."));
        try {
            this.getInstallerDb().createTables();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAssetsIdOnUpgrade() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQLWithReplacements("assets", new String[][]{{"(?i)id\\s+INTEGER DEFAULT nextval\\('opennmsNxtId'\\) NOT NULL,", ""}, {"(?i)constraint pk_assetID primary key \\(id\\),", ""}});
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO assets (nodeId, category, userLastModified, lastModifiedDate) VALUES (1, 'some category', 'dgregor broke it', now())");
        this.getInstallerDb().createTables();
        Statement st = this.m_connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT id from assets");
        InstallerDbTest.assertTrue((String)"Could not ResultSet.next() to first result entry", (boolean)rs.next());
        int got = rs.getInt(1);
        InstallerDbTest.assertFalse((String)"first result should not be null, but was null", (boolean)rs.wasNull());
        InstallerDbTest.assertEquals((String)"assets id", (int)1, (int)got);
        InstallerDbTest.assertFalse((String)"Too many entries", (boolean)rs.next());
    }

    public void testTriggersAfterUpdate() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.getInstallerDb().createTables();
        this.verifyTriggers(false);
        this.getInstallerDb().createTables();
        this.verifyTriggers(false);
    }

    public void testTriggersAfterUpdateWithChange() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distPoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.getInstallerDb().getIndexDao().remove("ipinterface_snmpInterfaceId_idx");
        this.addTableFromSQLWithReplacements("ipinterface", new String[][]{{"(?i)snmpInterfaceId\\s+integer,", ""}, {"(?i)CONSTRAINT snmpinterface_fkey2 FOREIGN KEY \\(snmpInterfaceId\\) REFERENCES snmpInterface \\(id\\) ON DELETE SET NULL,", ""}});
        this.addTableFromSQL("service");
        this.addTableFromSQL("ifServices");
        this.addTableFromSQL("events");
        this.addTableFromSQL("outages");
        this.verifyTriggers(false);
        this.getInstallerDb().createTables();
        this.verifyTriggers(false);
    }

    public void testIpInterfaceForeignKeySnmpInterfaceIdOnUpgrade() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distPoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpInterface");
        this.addTableFromSQLWithReplacements("ipinterface", new String[][]{{"(?i)snmpInterfaceId\\s+integer,", ""}, {"(?i)CONSTRAINT snmpinterface_fkey2 FOREIGN KEY \\(snmpInterfaceId\\) REFERENCES snmpInterface \\(id\\) ON DELETE SET NULL,", ""}}, false);
        this.addTableFromSQL("service");
        this.addTableFromSQL("ifServices");
        this.addTableFromSQL("events");
        this.addTableFromSQL("outages");
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1)");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.getInstallerDb().createTables();
        this.verifyTriggers(false);
        Statement st = this.m_connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT id from snmpInterface ORDER BY nodeId");
        InstallerDbTest.assertTrue((String)"Could not ResultSet.next() to first result entry", (boolean)rs.next());
        rs.getInt(1);
        InstallerDbTest.assertFalse((String)"first result should not be null, but was null", (boolean)rs.wasNull());
        InstallerDbTest.assertFalse((String)"Too many entries", (boolean)rs.next());
        st = this.m_connection.createStatement();
        rs = st.executeQuery("SELECT id, snmpInterfaceID from ipInterface ORDER BY nodeId");
        InstallerDbTest.assertTrue((String)"Could not ResultSet.next() to first result entry", (boolean)rs.next());
        rs.getInt(1);
        InstallerDbTest.assertFalse((String)"ipInterface.id in first result should not be null, but was null", (boolean)rs.wasNull());
        rs.getInt(2);
        InstallerDbTest.assertFalse((String)"ipInterface.snmpInterfaceId in first result should not be null, but was null", (boolean)rs.wasNull());
        InstallerDbTest.assertFalse((String)"More than one entry was found", (boolean)rs.next());
    }

    public void testIfServicesForeignKeyIpInterfaceIdOnUpgrade() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distPoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQLWithReplacements("ipinterface", new String[][]{{"(?i)id\\s+integer default nextval\\('opennmsNxtId'\\) not null,", ""}, {"(?i)constraint ipinterface_pkey primary key \\(id\\),", ""}});
        this.addTableFromSQL("service");
        this.addTableFromSQLWithReplacements("ifservices", new String[][]{{"(?i)ipInterfaceID\\s+integer not null,", ""}, {"(?i)constraint ipinterface_fkey foreign key \\(ipInterfaceId\\) references ipInterface \\(id\\) ON DELETE CASCADE,", ""}}, false);
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', null )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '1.2.3.4', null, 1)");
        this.getInstallerDb().createTables();
        Statement st = this.m_connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT id from ipInterface");
        InstallerDbTest.assertTrue((String)"could not advance results to first row", (boolean)rs.next());
        rs.getInt(1);
        InstallerDbTest.assertFalse((String)"ipInterface.id should not be null", (boolean)rs.wasNull());
        InstallerDbTest.assertFalse((String)"too many rows: only expecting one", (boolean)rs.next());
        rs = st.executeQuery("SELECT id, ipInterfaceID from ifServices");
        InstallerDbTest.assertTrue((String)"could not advance results to first row", (boolean)rs.next());
        rs.getInt(1);
        InstallerDbTest.assertFalse((String)"ifServices.id should not be null", (boolean)rs.wasNull());
        rs.getInt(2);
        InstallerDbTest.assertFalse((String)"ifServices.interfaceId should not be null", (boolean)rs.wasNull());
        InstallerDbTest.assertFalse((String)"too many rows: only expecting one", (boolean)rs.next());
    }

    public void testOutagesForeignKeyIfServiceIdOnUpgrade() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distPoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQL("ipinterface");
        this.addTableFromSQL("events");
        this.addTableFromSQL("service");
        this.addTableFromSQLWithReplacements("ifservices", new String[][]{{"(?i)id\\s+integer default nextval\\('opennmsNxtId'\\) not null,", ""}, {"(?i)constraint ifServices_pkey primary key \\(id\\),", ""}});
        this.addTableFromSQLWithReplacements("outages", new String[][]{{"(?i)ifServiceId\\s+INTEGER not null,", ""}, {"(?i),\\s+CONSTRAINT ifServices_fkey2 FOREIGN KEY \\(ifServiceId\\) REFERENCES ifServices \\(id\\) ON DELETE CASCADE", ""}}, false);
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (id, nodeId, ipAddr, snmpIfIndex) VALUES ( 1, 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO ipInterface (id, nodeId, ipAddr, ifIndex, snmpInterfaceId ) VALUES ( 1, 1, '1.2.3.4', 1, 1 )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID, ipInterfaceId) VALUES ( 1, '1.2.3.4', 1, 1, 1)");
        this.executeSQL("INSERT INTO outages (outageId, nodeId, ipAddr, ifLostService, serviceID ) VALUES ( nextval('outageNxtId'), 1, '1.2.3.4', now(), 1 )");
        this.getInstallerDb().createTables();
        Statement st = this.m_connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT id from ifServices");
        int count = 0;
        int expected = 1;
        while (rs.next()) {
            InstallerDbTest.assertEquals((String)"ifServices id", (int)expected, (int)rs.getInt(1));
            ++count;
            ++expected;
        }
        InstallerDbTest.assertEquals((String)"column count", (int)1, (int)count);
        rs = st.executeQuery("SELECT ifServiceId from outages");
        count = 0;
        expected = 1;
        while (rs.next()) {
            InstallerDbTest.assertEquals((String)"outages ifServiceId", (int)expected, (int)rs.getInt(1));
            ++count;
            ++expected;
        }
        InstallerDbTest.assertEquals((String)"expected column count", (int)1, (int)count);
    }

    public void testAddStoredProcedures() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.getInstallerDb().createTables();
        this.verifyTriggers(true);
    }

    public void testAddStoredProceduresTwice() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.getInstallerDb().addStoredProcedures();
        this.verifyTriggers(true);
    }

    public void testSnmpInterfaceNodeIdColumnConvertToNotNull() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQLWithReplacements("snmpinterface", new String[][]{{"(?i)nodeID\\s+integer not null,", "nodeId integer,"}});
        this.getInstallerDb().createTables();
    }

    public void testSnmpInterfaceSnmpIfIndexColumnConvertToNotNull() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQLWithReplacements("snmpinterface", new String[][]{{"(?i)snmpIfIndex\\s+integer not null,", "snmpIfIndex integer,"}});
        this.getInstallerDb().createTables();
    }

    public void testIpInterfaceNodeIdColumnConvertToNotNull() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQLWithReplacements("ipinterface", new String[][]{{"(?i)nodeID\\s+integer not null,", "nodeId integer,"}});
        this.getInstallerDb().createTables();
    }

    public void testIfServicesNodeIdColumnConvertToNotNull() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQL("ipinterface");
        this.addTableFromSQL("service");
        this.addTableFromSQLWithReplacements("ifservices", new String[][]{{"(?i)nodeID\\s+integer not null,", "nodeId integer,"}});
        this.getInstallerDb().createTables();
    }

    public void testIfServicesIpAddrColumnConvertToNotNull() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQL("ipinterface");
        this.addTableFromSQL("service");
        this.addTableFromSQLWithReplacements("ifservices", new String[][]{{"(?i)ipAddr\\s+varchar\\(16\\) not null,", "ipAddr varchar(16),"}});
        this.getInstallerDb().createTables();
    }

    public void testIfServicesServiceIdColumnConvertToNotNull() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQL("ipinterface");
        this.addTableFromSQL("service");
        this.addTableFromSQLWithReplacements("ifservices", new String[][]{{"(?i)serviceID\\s+integer not null,", "serviceId integer,"}});
        this.getInstallerDb().createTables();
    }

    public void testOutagesNodeIdColumnConvertToNotNull() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQL("ipinterface");
        this.addTableFromSQL("service");
        this.addTableFromSQL("ifservices");
        this.addTableFromSQL("events");
        this.addTableFromSQLWithReplacements("outages", new String[][]{{"(?i)nodeID\\s+integer not null,", "nodeId integer,"}});
        this.getInstallerDb().createTables();
    }

    public void testOutagesServiceIdColumnConvertToNotNull() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQL("ipinterface");
        this.addTableFromSQL("service");
        this.addTableFromSQL("ifservices");
        this.addTableFromSQL("events");
        this.addTableFromSQLWithReplacements("outages", new String[][]{{"(?i)serviceID\\s+integer not null,", "serviceID integer,"}});
        this.getInstallerDb().createTables();
    }

    public void testOutagesIfServiceIdColumnConvertToNotNull() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQL("ipinterface");
        this.addTableFromSQL("service");
        this.addTableFromSQL("ifservices");
        this.addTableFromSQL("events");
        this.addTableFromSQLWithReplacements("outages", new String[][]{{"(?i)ifServiceID\\s+integer not null,", "ifServiceId integer,"}});
        this.getInstallerDb().createTables();
    }

    public void testSnmpInterfaceNonUniqueKeys() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.executeSQL("drop index snmpinterface_nodeid_ifindex_unique_idx");
        this.executeSQL("INSERT INTO node ( nodeId, nodeCreateTime ) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeID, ipAddr, snmpIfIndex ) VALUES ( 1, '0.0.0.0', 1 )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeID, ipAddr, snmpIfIndex ) VALUES ( 1, '0.0.0.0', 1 )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeID, ipAddr, snmpIfIndex ) VALUES ( 1, '0.0.0.1', 1 )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeID, ipAddr, snmpIfIndex ) VALUES ( 1, '0.0.0.2', 1 )");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new Exception("Unique index 'snmpinterface_nodeid_ifindex_unique_idx' cannot be added to table 'snmpinterface' because 4 rows are not unique.  See the install guide for details on how to correct this problem.  You can use the following SQL to see which rows are not unique:\nSELECT * FROM snmpinterface WHERE ( nodeID, snmpIfIndex ) IN ( SELECT nodeID, snmpIfIndex FROM snmpinterface GROUP BY nodeID, snmpIfIndex HAVING count(nodeID) > 1 ORDER BY nodeID, snmpIfIndex ) ORDER BY nodeID, snmpIfIndex"));
        try {
            this.getInstallerDb().checkIndexUniqueness();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testIpInterfaceNonUniqueKeys() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQL("ipinterface");
        this.executeSQL("drop index ipinterface_nodeid_ipaddr_notzero_idx");
        this.executeSQL("INSERT INTO node ( nodeId, nodeCreateTime ) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO node ( nodeId, nodeCreateTime ) VALUES ( 2, now() )");
        this.executeSQL("INSERT INTO node ( nodeId, nodeCreateTime ) VALUES ( 3, now() )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeID, ipAddr, snmpIfIndex ) VALUES ( 1, '0.0.0.0', 1 )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeID, ipAddr, snmpIfIndex ) VALUES ( 1, '0.0.0.0', 2 )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeID, ipAddr, snmpIfIndex ) VALUES ( 3, '1.1.1.1', 1 )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeID, ipAddr, snmpIfIndex ) VALUES ( 3, '1.1.1.1', 2 )");
        this.executeSQL("INSERT INTO ipInterface ( nodeID, ipAddr, ifIndex ) VALUES ( 1, '0.0.0.0', 1 )");
        this.executeSQL("INSERT INTO ipInterface ( nodeID, ipAddr, ifIndex ) VALUES ( 1, '0.0.0.0', 2 )");
        this.executeSQL("INSERT INTO ipInterface ( nodeID, ipAddr, ifIndex ) VALUES ( 2, '1.1.1.1', null )");
        this.executeSQL("INSERT INTO ipInterface ( nodeID, ipAddr, ifIndex ) VALUES ( 2, '1.1.1.1', null )");
        this.executeSQL("INSERT INTO ipInterface ( nodeID, ipAddr, ifIndex ) VALUES ( 3, '1.1.1.1', 1 )");
        this.executeSQL("INSERT INTO ipInterface ( nodeID, ipAddr, ifIndex ) VALUES ( 3, '1.1.1.1', 2 )");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new Exception("Unique index 'ipinterface_nodeid_ipaddr_notzero_idx' cannot be added to table 'ipInterface' because 4 rows are not unique.  See the install guide for details on how to correct this problem.  You can use the following SQL to see which rows are not unique:\nSELECT * FROM ipInterface WHERE ( nodeID, ipAddr ) IN ( SELECT nodeID, ipAddr FROM ipInterface GROUP BY nodeID, ipAddr HAVING count(nodeID) > 1 AND ( ipAddr != '0.0.0.0' ) ORDER BY nodeID, ipAddr ) ORDER BY nodeID, ipAddr"));
        try {
            this.getInstallerDb().checkIndexUniqueness();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testIfServicesNonUniqueKeys() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.addTableFromSQL("ipinterface");
        this.addTableFromSQL("events");
        this.addTableFromSQL("service");
        this.addTableFromSQL("ifservices");
        this.executeSQL("drop index ifservices_nodeid_ipaddr_svc_unique");
        this.executeSQL("INSERT INTO node ( nodeId, nodeCreateTime ) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO node ( nodeId, nodeCreateTime ) VALUES ( 2, now() )");
        this.executeSQL("INSERT INTO node ( nodeId, nodeCreateTime ) VALUES ( 3, now() )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeID, ipAddr, snmpIfIndex ) VALUES ( 1, '0.0.0.0', 1 )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeID, ipAddr, snmpIfIndex ) VALUES ( 1, '0.0.0.0', 2 )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeID, ipAddr, snmpIfIndex ) VALUES ( 3, '1.1.1.1', 1 )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeID, ipAddr, snmpIfIndex ) VALUES ( 3, '1.1.1.1', 2 )");
        this.executeSQL("INSERT INTO ipInterface ( nodeID, ipAddr, ifIndex ) VALUES ( 1, '0.0.0.0', 1 )");
        this.executeSQL("INSERT INTO ipInterface ( nodeID, ipAddr, ifIndex ) VALUES ( 1, '0.0.0.0', 2 )");
        this.executeSQL("INSERT INTO ipInterface ( nodeID, ipAddr, ifIndex ) VALUES ( 2, '1.1.1.1', null )");
        this.executeSQL("INSERT INTO ipInterface ( nodeID, ipAddr, ifIndex ) VALUES ( 3, '1.1.1.1', 1 )");
        this.executeSQL("INSERT INTO service ( serviceID, serviceName ) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO service ( serviceID, serviceName ) VALUES ( 2, 'TEA-READY' )");
        this.executeSQL("INSERT INTO service ( serviceID, serviceName ) VALUES ( 3, 'SODA-ICE-COLD' )");
        this.executeSQL("INSERT INTO ifServices ( nodeID, ipAddr, ifIndex, serviceID ) VALUES ( 2, '1.1.1.1', null, 1 )");
        this.executeSQL("INSERT INTO ifServices ( nodeID, ipAddr, ifIndex, serviceID ) VALUES ( 2, '1.1.1.1', null, 2 )");
        this.executeSQL("INSERT INTO ifServices ( nodeID, ipAddr, ifIndex, serviceID ) VALUES ( 2, '1.1.1.1', null, 3 )");
        this.executeSQL("INSERT INTO ifServices ( nodeID, ipAddr, ifIndex, serviceID ) VALUES ( 2, '1.1.1.1', null, 3 )");
        this.executeSQL("INSERT INTO ifServices ( nodeID, ipAddr, ifIndex, serviceID ) VALUES ( 3, '1.1.1.1', null, 3 )");
        this.executeSQL("INSERT INTO ifServices ( nodeID, ipAddr, ifIndex, serviceID ) VALUES ( 3, '1.1.1.1', -100, 3 )");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new Exception("Unique index 'ifservices_nodeid_ipaddr_svc_unique' cannot be added to table 'ifservices' because 4 rows are not unique.  See the install guide for details on how to correct this problem.  You can use the following SQL to see which rows are not unique:\nSELECT * FROM ifservices WHERE ( nodeID, ipAddr, serviceId ) IN ( SELECT nodeID, ipAddr, serviceId FROM ifservices GROUP BY nodeID, ipAddr, serviceId HAVING count(nodeID) > 1 ORDER BY nodeID, ipAddr, serviceId ) ORDER BY nodeID, ipAddr, serviceId"));
        try {
            this.getInstallerDb().checkIndexUniqueness();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testCheckIndexUniquenessWithTableButMissingColumnBug2325() throws Exception {
        this.addTableFromSQL("distpoller");
        this.getInstallerDb().getIndexDao().remove("node_foreign_unique_idx");
        this.addTableFromSQLWithReplacements("node", new String[][]{{"foreignSource\\s+varchar\\(\\d+\\),", ""}});
        this.getInstallerDb().readTables();
        this.getInstallerDb().checkIndexUniqueness();
    }

    public void testBug1574() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQL("snmpinterface");
        this.executeSQL("drop index snmpinterface_nodeid_ifindex_unique_idx");
        this.executeSQL("create index snmpinterface_nodeid_ifindex_idx on snmpinterface(nodeID, snmpIfIndex)");
        this.getInstallerDb().addIndexesForTable("snmpinterface");
        this.addTableFromSQL("ipinterface");
    }

    public void testUpgradeExistingDoNotAddColumnBug1685() throws Exception {
        this.getInstallerDb().createSequences();
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().addStoredProcedures();
        this.addTableFromSQL("distpoller");
        this.addTableFromSQL("node");
        this.addTableFromSQLWithReplacements("snmpinterface", new String[][]{{"snmpIfAlias\\s+varchar\\(\\d+\\),", ""}});
        this.executeSQL("INSERT INTO node ( nodeId, nodeCreateTime ) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface ( nodeID, ipAddr, snmpIfIndex ) VALUES ( 1, '0.0.0.0', 1 )");
        int id = this.jdbcTemplate.queryForInt("SELECT id from snmpInterface", new Object[0]);
        this.getInstallerDb().createTables();
        int id2 = this.jdbcTemplate.queryForInt("SELECT id from snmpInterface", new Object[0]);
        InstallerDbTest.assertEquals((String)"id before upgrade should equal id after upgrade", (int)id, (int)id2);
    }

    public void testUpgradeColumnToNotNullWithDefault() throws Exception {
        String[] commands = new String[]{"CREATE TABLE alarms ( id integer, x733ProbableCause integer )", "INSERT INTO alarms ( id, x733ProbableCause ) VALUES ( 1, 1 )", "INSERT INTO alarms ( id, x733ProbableCause ) VALUES ( 2, NULL )"};
        String newSql = "CREATE TABLE alarms ( id integer, x733ProbableCause integer DEFAULT 0 NOT NULL );\n";
        this.executeSQL(commands);
        this.getInstallerDb().readTables((Reader)new StringReader("CREATE TABLE alarms ( id integer, x733ProbableCause integer DEFAULT 0 NOT NULL );\n"));
        this.getInstallerDb().createTables();
        InstallerDbTest.assertEquals((String)"x733ProbableCause for id = 1 should have its original value", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT x733ProbableCause FROM alarms WHERE id = 1", new Object[0]));
        InstallerDbTest.assertEquals((String)"x733ProbableCause for id = 2 should have the DEFAULT value", (Object)new Integer(0), (Object)this.jdbcTemplate.queryForObject("SELECT x733ProbableCause FROM alarms WHERE id = 2", Integer.class, new Object[0]));
    }

    public void testColumnNoChangeWithDefault() throws Exception {
        String sql = "CREATE TABLE alarms ( id integer, x733ProbableCause integer DEFAULT 0 NOT NULL );\n";
        this.executeSQL("CREATE TABLE alarms ( id integer, x733ProbableCause integer DEFAULT 0 NOT NULL );\n");
        this.getInstallerDb().readTables((Reader)new StringReader("CREATE TABLE alarms ( id integer, x733ProbableCause integer DEFAULT 0 NOT NULL );\n"));
        this.getInstallerDb().createTables();
        this.assertNoTablesHaveChanged();
    }

    public void testUpdateIplikePgSql() throws Exception {
        this.getInstallerDb().updatePlPgsql();
        this.getInstallerDb().setPostgresIpLikeLocation(null);
        this.getInstallerDb().updateIplike();
        this.getInstallerDb().closeConnection();
    }

    public void testCreateTableWithCheckConstraint() throws Exception {
        String cname = "setfilter_type_valid";
        String checkexpression = "(((\"type\" >= 0) AND (\"type\" <= 2)))";
        String sql = "create table setFilter ( id integer, type integer, constraint setfilter_type_valid check (((\"type\" >= 0) AND (\"type\" <= 2))));\n";
        this.getInstallerDb().readTables((Reader)new StringReader("create table setFilter ( id integer, type integer, constraint setfilter_type_valid check (((\"type\" >= 0) AND (\"type\" <= 2))));\n"));
        Table table = this.getInstallerDb().getTableFromSQL("setFilter");
        List constraints = table.getConstraints();
        InstallerDbTest.assertTrue((constraints.size() == 1 ? 1 : 0) != 0);
        Constraint constraint = (Constraint)constraints.get(0);
        InstallerDbTest.assertTrue((boolean)"setfilter_type_valid".equals(constraint.getName()));
        InstallerDbTest.assertTrue((boolean)"(((\"type\" >= 0) AND (\"type\" <= 2)))".equals("(" + constraint.getCheckExpression() + ")"));
    }

    public void testUpgradeAddCheckConstraint() throws Exception {
        String cname = "setfilter_type_valid";
        String checkexpression = "(((\"type\" >= 0) AND (\"type\" <= 2)))";
        String sql_start = "create table setFilter ( id integer, type integer);\n";
        this.executeSQL("create table setFilter ( id integer, type integer);\n");
        String sql_upgrade = "create table setFilter ( id integer, type integer, constraint setfilter_type_valid check (((\"type\" >= 0) AND (\"type\" <= 2))));\n";
        this.getInstallerDb().readTables((Reader)new StringReader("create table setFilter ( id integer, type integer, constraint setfilter_type_valid check (((\"type\" >= 0) AND (\"type\" <= 2))));\n"));
        this.getInstallerDb().createTables();
        Table table = this.getInstallerDb().getTableFromDB("setFilter");
        List constraints = table.getConstraints();
        InstallerDbTest.assertEquals((int)1, (int)constraints.size());
        Constraint constraint = (Constraint)constraints.get(0);
        InstallerDbTest.assertEquals((String)"setfilter_type_valid", (String)constraint.getName());
        InstallerDbTest.assertEquals((String)"(((\"type\" >= 0) AND (\"type\" <= 2)))".replaceAll("\"type\"", "type"), (String)("(" + constraint.getCheckExpression().replaceAll("\"type\"", "type") + ")"));
    }

    public void addTableFromSQL(String tableName) throws SQLException {
        String partialSQL = null;
        try {
            partialSQL = this.getInstallerDb().getTableCreateFromSQL(tableName);
        }
        catch (Exception e) {
            this.fail("Could not get SQL for table '" + tableName + "'", e);
        }
        this.addTableWithSQL(tableName, partialSQL, true);
    }

    public void addTableFromSQLWithReplacements(String tableName, String[][] replacements) throws SQLException {
        this.addTableFromSQLWithReplacements(tableName, replacements, true);
    }

    public void addTableFromSQLWithReplacements(String tableName, String[][] replacements, boolean addTriggers) throws SQLException {
        String partialSQL = null;
        try {
            partialSQL = this.getInstallerDb().getTableCreateFromSQL(tableName);
        }
        catch (Exception e) {
            this.fail("Could not get SQL for table '" + tableName + "'", e);
        }
        for (String[] replacement : replacements) {
            Pattern p = Pattern.compile(replacement[0]);
            Matcher m = p.matcher(partialSQL);
            if (!m.find()) {
                StringBuffer error = new StringBuffer();
                error.append("Could not find a match for pattern '" + p.toString() + "'");
                if (this.containsUnescapedParens(p.toString())) {
                    error.append(" (pattern contains unescaped parenthesis--should they be backslash escaped?)");
                }
                error.append(" in string '" + partialSQL + "'.");
                InstallerDbTest.fail((String)error.toString());
            }
            partialSQL = partialSQL.replaceFirst(replacement[0], replacement[1]);
        }
        this.addTableWithSQL(tableName, partialSQL, addTriggers);
    }

    private void addTableWithSQL(String table, String sql, boolean addTriggers) throws SQLException {
        this.executeSQL("CREATE TABLE " + table + " ( " + sql + " )");
        if (!addTriggers) {
            return;
        }
        this.getInstallerDb().addIndexesForTable(table);
        this.getInstallerDb().addTriggersForTable(table);
    }

    public boolean containsUnescapedParens(String str) {
        Pattern p = Pattern.compile("[^\\\\]\\(");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public void assertStoredProcedureForTriggerExists(Trigger trigger) throws Exception {
        InstallerDbTest.assertTrue((String)("Function '" + trigger.getStoredProcedure() + "' does not exist"), (boolean)this.getInstallerDb().functionExists(trigger.getStoredProcedure(), "", "trigger"));
    }

    public void assertTriggerExists(Trigger trigger) throws Exception {
        InstallerDbTest.assertTrue((String)("Trigger '" + trigger.getName() + "' does not exist on table '" + trigger.getTable() + "' to execute '" + trigger.getStoredProcedure() + "' function"), (boolean)trigger.isOnDatabase(this.m_connection));
    }

    public void verifyTriggers(boolean onlyStoredProcedures) throws Exception {
        Trigger[] triggers;
        for (Trigger trigger : triggers = new Trigger[]{new Trigger("setIfServiceKeysOnInsertTrigger", "outages", "setIfServiceKeysOnInsert", "NO SQL"), new Trigger("setIfServiceKeysOnUpdateTrigger", "outages", "setIfServiceKeysOnUpdate", "NO SQL"), new Trigger("setIpInterfaceKeysOnInsertTrigger", "ifServices", "setIpInterfaceKeysOnInsert", "NO SQL"), new Trigger("setIpInterfaceKeysOnUpdateTrigger", "ifServices", "setIpInterfaceKeysOnUpdate", "NO SQL"), new Trigger("setSnmpInterfaceKeysOnInsertTrigger", "ipInterface", "setSnmpInterfaceKeysOnInsert", "NO SQL"), new Trigger("setSnmpInterfaceKeysOnUpdateTrigger", "ipInterface", "setSnmpInterfaceKeysOnUpdate", "NO SQL")}) {
            this.assertStoredProcedureForTriggerExists(trigger);
            if (onlyStoredProcedures) continue;
            this.assertTriggerExists(trigger);
        }
    }

    public InstallerDb getInstallerDb() {
        return this.m_installerDb;
    }

    public void resetOutputStream() {
        this.m_outputStream = new ByteArrayOutputStream();
        this.getInstallerDb().setOutputStream(new PrintStream(this.m_outputStream));
    }

    private void assertNoTablesHaveChanged() throws IOException {
        String line;
        ByteArrayInputStream in = new ByteArrayInputStream(this.m_outputStream.toByteArray());
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        ArrayList<String> unanticipatedOutput = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            if (line.matches("- creating tables\\.\\.\\.") || line.matches("  - checking table \"\\S+\"\\.\\.\\. ") || line.matches("  - checking table \"\\S+\"\\.\\.\\. UPTODATE") || line.matches("    - checking trigger '\\S+' on this table\\.\\.\\. DONE") || line.matches("    - checking trigger '\\S+' on this table\\.\\.\\. DONE") || line.matches("    - checking index '\\S+' on this table\\.\\.\\. DONE") || line.matches("- creating tables\\.\\.\\. DONE")) continue;
            unanticipatedOutput.add(line);
        }
        if (unanticipatedOutput.size() > 0) {
            InstallerDbTest.fail((String)(unanticipatedOutput.size() + "unexpected line(s) output by createTables(): \n\t" + StringUtils.collectionToDelimitedString(unanticipatedOutput, (String)"\n\t") + "\nAll output:\n" + this.m_outputStream));
        }
    }
}

