/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.Date;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsUserNotification;

public class UserNotificationDaoTest
extends AbstractTransactionalDaoTestCase {
    public void testSaveUserNotification() {
        OnmsEvent event = new OnmsEvent();
        event.setDistPoller((OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost")));
        event.setEventCreateTime(new Date());
        event.setEventDescr("event dao test");
        event.setEventHost("localhost");
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setEventLogGroup("event dao test log group");
        event.setEventLogMsg("event dao test log msg");
        event.setEventSeverity(new Integer(7));
        event.setEventSource("EventDaoTest");
        event.setEventTime(new Date());
        event.setEventUei("uei://org/opennms/test/UserNotificationDaoTest");
        OnmsAlarm alarm = new OnmsAlarm();
        event.setAlarm(alarm);
        OnmsNode node = (OnmsNode)this.getNodeDao().findAll().iterator().next();
        OnmsIpInterface iface = (OnmsIpInterface)node.getIpInterfaces().iterator().next();
        OnmsMonitoredService service = (OnmsMonitoredService)iface.getMonitoredServices().iterator().next();
        event.setNode(node);
        event.setServiceType(service.getServiceType());
        event.setIpAddr(iface.getIpAddress());
        this.getEventDao().save((Object)event);
        OnmsEvent newEvent = (OnmsEvent)this.getEventDao().load((Serializable)event.getId());
        UserNotificationDaoTest.assertEquals((String)"uei://org/opennms/test/UserNotificationDaoTest", (String)newEvent.getEventUei());
        OnmsNotification notification = new OnmsNotification();
        notification.setEvent(newEvent);
        notification.setTextMsg("Tests are fun!");
        this.getNotificationDao().save((Object)notification);
        OnmsNotification newNotification = (OnmsNotification)this.getNotificationDao().load((Serializable)notification.getNotifyId());
        UserNotificationDaoTest.assertEquals((String)"uei://org/opennms/test/UserNotificationDaoTest", (String)newNotification.getEvent().getEventUei());
        OnmsUserNotification userNotif = new OnmsUserNotification();
        userNotif.setNotification(notification);
        userNotif.setNotifyTime(new Date());
        userNotif.setUserId("OpenNMS User");
        userNotif.setMedia("E-mail");
        userNotif.setContactInfo("test@opennms.org");
        this.getUserNotificationDao().save((Object)userNotif);
        UserNotificationDaoTest.assertNotNull((Object)userNotif.getNotification());
        UserNotificationDaoTest.assertEquals((String)userNotif.getUserId(), (String)"OpenNMS User");
    }
}

