/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.ServiceSelector;

public class OutageDaoTest
extends AbstractTransactionalDaoTestCase {
    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
    }

    protected void onSetUpInTransactionIfEnabled() {
        super.onSetUpInTransactionIfEnabled();
        FilterDaoFactory.setInstance(null);
        FilterDaoFactory.getInstance();
    }

    public void testSave() {
        OnmsNode node = new OnmsNode(this.getLocalHostDistPoller());
        this.getNodeDao().save((Object)node);
        OnmsIpInterface ipInterface = new OnmsIpInterface("172.16.1.1", node);
        OnmsServiceType serviceType = this.getServiceTypeDao().findByName("ICMP");
        OutageDaoTest.assertNotNull((Object)serviceType);
        OnmsMonitoredService monitoredService = new OnmsMonitoredService(ipInterface, serviceType);
        OnmsEvent event = new OnmsEvent();
        OnmsOutage outage = new OnmsOutage();
        outage.setServiceLostEvent(event);
        outage.setIfLostService(new Date());
        outage.setMonitoredService(monitoredService);
        this.getOutageDao().save((Object)outage);
        outage = (OnmsOutage)this.getOutageDao().load((Serializable)outage.getId());
        OutageDaoTest.assertEquals((String)"ICMP", (String)outage.getMonitoredService().getServiceType().getName());
    }

    public void testGetMatchingOutages() {
        this.insertEntitiesAndOutage();
        this.flushOutageDaoAndStartNewTransaction();
        String[] svcs = new String[]{"ICMP"};
        ServiceSelector selector = new ServiceSelector("ipAddr IPLIKE 172.16.1.1", Arrays.asList(svcs));
        Collection outages = this.getOutageDao().matchingCurrentOutages(selector);
        OutageDaoTest.assertEquals((String)"outage count", (int)1, (int)outages.size());
    }

    public void testGetMatchingOutagesWithEmptyServiceList() {
        this.insertEntitiesAndOutage();
        this.flushOutageDaoAndStartNewTransaction();
        ServiceSelector selector = new ServiceSelector("ipAddr IPLIKE 172.16.1.1", new ArrayList(0));
        Collection outages = this.getOutageDao().matchingCurrentOutages(selector);
        OutageDaoTest.assertEquals((int)1, (int)outages.size());
    }

    private OnmsDistPoller getLocalHostDistPoller() {
        return (OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost"));
    }

    private OnmsOutage insertEntitiesAndOutage() {
        OnmsNode node = new OnmsNode(this.getLocalHostDistPoller());
        this.getNodeDao().save((Object)node);
        OnmsIpInterface ipInterface = new OnmsIpInterface("172.16.1.1", node);
        this.getIpInterfaceDao().save((Object)ipInterface);
        OnmsServiceType serviceType = this.getServiceTypeDao().findByName("ICMP");
        OutageDaoTest.assertNotNull((Object)serviceType);
        OnmsMonitoredService monitoredService = new OnmsMonitoredService(ipInterface, serviceType);
        this.getMonitoredServiceDao().save((Object)monitoredService);
        OnmsEvent event = new OnmsEvent();
        event.setDistPoller(this.getLocalHostDistPoller());
        event.setEventUei("foo!");
        event.setEventTime(new Date());
        event.setEventCreateTime(new Date());
        event.setEventSeverity(Integer.valueOf(1));
        event.setEventSource("your mom");
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        this.getEventDao().save((Object)event);
        OnmsOutage outage = new OnmsOutage();
        outage.setMonitoredService(monitoredService);
        outage.setServiceLostEvent(event);
        outage.setIfLostService(new Date());
        this.getOutageDao().save((Object)outage);
        return outage;
    }

    private void flushOutageDaoAndStartNewTransaction() {
        this.getOutageDao().flush();
        this.setComplete();
        this.endTransaction();
        this.startNewTransaction();
    }
}

