/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.beanutils.BeanUtils;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDaoTest
extends AbstractTransactionalDaoTestCase {
    public void testSave() {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().get((Serializable)((Object)"localhost"));
        OnmsNode node = new OnmsNode(distPoller);
        node.setLabel("MyFirstNode");
        this.getNodeDao().save((Object)node);
        this.getNodeDao().flush();
    }

    public void testSaveWithPathElement() {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().get((Serializable)((Object)"localhost"));
        OnmsNode node = new OnmsNode(distPoller);
        node.setLabel("MyFirstNode");
        PathElement p = new PathElement("192.168.7.7", "ICMP");
        node.setPathElement(p);
        this.getNodeDao().save((Object)node);
        this.getNodeDao().flush();
    }

    public void testSaveWithNullPathElement() {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().get((Serializable)((Object)"localhost"));
        OnmsNode node = new OnmsNode(distPoller);
        node.setLabel("MyFirstNode");
        PathElement p = new PathElement("192.168.7.7", "ICMP");
        node.setPathElement(p);
        this.getNodeDao().save((Object)node);
        OnmsNode myNode = (OnmsNode)this.getNodeDao().get((Serializable)node.getId());
        myNode.setPathElement(null);
        this.getNodeDao().save((Object)myNode);
        this.getNodeDao().flush();
    }

    public void testCreate() throws InterruptedException {
        OnmsDistPoller distPoller = this.getDistPoller();
        OnmsNode node = new OnmsNode(distPoller);
        node.setLabel("MyFirstNode");
        node.getAssetRecord().setDisplayCategory("MyCategory");
        PathElement p = new PathElement("192.168.7.7", "ICMP");
        node.setPathElement(p);
        this.getNodeDao().save((Object)node);
        System.out.println("BEFORE GET");
        OnmsDistPoller dp = this.getDistPoller();
        NodeDaoTest.assertSame((Object)distPoller, (Object)dp);
        System.out.println("AFTER GET");
        Collection nodes = this.getNodeDao().findNodes(dp);
        NodeDaoTest.assertEquals((int)7, (int)nodes.size());
        System.out.println("AFTER GETNODES");
        for (OnmsNode retrieved : nodes) {
            System.out.println("category for " + retrieved.getId() + " = " + retrieved.getAssetRecord().getDisplayCategory());
            if (node.getId() != 5) continue;
            NodeDaoTest.assertEquals((String)"MyFirstNode", (String)retrieved.getLabel());
            NodeDaoTest.assertEquals((String)"MyCategory", (String)retrieved.getAssetRecord().getDisplayCategory());
            NodeDaoTest.assertEquals((String)"192.168.7.7", (String)retrieved.getPathElement().getIpAddress());
        }
        System.out.println("AFTER Loop");
    }

    public void testQuery() throws Exception {
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(1));
        this.validateNode(n);
    }

    public void testDeleteOnOrphanIpInterface() {
        int preCount = this.getJdbcTemplate().queryForInt("select count(*) from ipinterface where ipinterface.nodeId = 1");
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(1));
        Iterator it = n.getIpInterfaces().iterator();
        it.next();
        it.remove();
        this.getNodeDao().saveOrUpdate((Object)n);
        this.getNodeDao().flush();
        int postCount = this.getJdbcTemplate().queryForInt("select count(*) from ipinterface where ipinterface.nodeId = 1");
        NodeDaoTest.assertEquals((int)(preCount - 1), (int)postCount);
    }

    public void testDeleteNode() {
        int preCount = this.getJdbcTemplate().queryForInt("select count(*) from node");
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(1));
        this.getNodeDao().delete((Object)n);
        this.getNodeDao().flush();
        int postCount = this.getJdbcTemplate().queryForInt("select count(*) from node");
        NodeDaoTest.assertEquals((int)(preCount - 1), (int)postCount);
    }

    public void testQueryWithHierarchy() throws Exception {
        OnmsNode n = this.getNodeDao().getHierarchy(Integer.valueOf(1));
        this.validateNode(n);
    }

    public void testQueryWithHierarchyCloseTransaction() throws Exception {
        this.setComplete();
        this.endTransaction();
        this.startNewTransaction();
        OnmsNode n = this.getNodeDao().getHierarchy(Integer.valueOf(1));
        this.endTransaction();
        this.validateNode(n);
        for (OnmsIpInterface ip : n.getIpInterfaces()) {
            ip.getIpAddress();
            for (OnmsMonitoredService service : ip.getMonitoredServices()) {
                service.getServiceName();
            }
        }
        for (OnmsSnmpInterface snmp : n.getSnmpInterfaces()) {
            for (OnmsIpInterface ip : snmp.getIpInterfaces()) {
                ip.getIpAddress();
            }
        }
    }

    public void testGetForeignIdToNodeIdMap() {
        Map arMap = this.getNodeDao().getForeignIdToNodeIdMap("imported:");
        NodeDaoTest.assertTrue((String)"Expected to find foriegnId 1", (boolean)arMap.containsKey("1"));
        OnmsNode node1 = (OnmsNode)this.getNodeDao().get((Serializable)arMap.get("1"));
        NodeDaoTest.assertNotNull((String)"Exepected foreignId to be mapped to a node", (Object)node1);
        NodeDaoTest.assertEquals((String)"Expected foreignId to be mapped to 'node1'", (String)"node1", (String)node1.getLabel());
    }

    private void validateNode(OnmsNode n) throws Exception {
        NodeDaoTest.assertNotNull((String)"Expected node to be non-null", (Object)n);
        NodeDaoTest.assertNotNull((String)("Expected node " + n.getId() + " to have interfaces"), (Object)n.getIpInterfaces());
        NodeDaoTest.assertEquals((String)("Unexpected number of interfaces for node " + n.getId()), (int)3, (int)n.getIpInterfaces().size());
        Iterator i$ = n.getIpInterfaces().iterator();
        while (i$.hasNext()) {
            OnmsIpInterface o;
            OnmsIpInterface iface = o = (OnmsIpInterface)i$.next();
            NodeDaoTest.assertNotNull((Object)iface);
            NodeDaoTest.assertNotNull((Object)iface.getIpAddress());
        }
        this.assertNodeEquals(this.getNode1(), n);
    }

    private void assertNodeEquals(OnmsNode expected, OnmsNode actual) throws Exception {
        NodeDaoTest.assertEquals((String)"Unexpected nodeId", (Object)expected.getId(), (Object)actual.getId());
        String[] properties = new String[]{"id", "label", "labelSource", "assetRecord.assetNumber", "distPoller.name", "sysContact", "sysName", "sysObjectId"};
        this.assertPropertiesEqual(properties, expected, actual);
        this.assertInterfaceSetsEqual(expected.getIpInterfaces(), actual.getIpInterfaces());
    }

    private void assertSetsEqual(Set expectedSet, Set actualSet, String orderProperty, AssertEquals comparer) throws Exception {
        TreeSet<Object> expectedSorted = new TreeSet<Object>(new PropertyComparator(orderProperty));
        expectedSorted.addAll(expectedSet);
        TreeSet<Object> actualSorted = new TreeSet<Object>(new PropertyComparator(orderProperty));
        actualSorted.addAll(actualSet);
        Iterator expected = expectedSorted.iterator();
        Iterator actual = actualSorted.iterator();
        while (expected.hasNext() && actual.hasNext()) {
            comparer.assertEqual(expected.next(), actual.next());
        }
        if (expected.hasNext()) {
            NodeDaoTest.fail((String)("Missing item " + expected.next() + " in the actual list"));
        }
        if (actual.hasNext()) {
            NodeDaoTest.fail((String)("Unexpected item " + actual.next() + " in the actual list"));
        }
    }

    private void assertInterfaceSetsEqual(Set<OnmsIpInterface> expectedSet, Set<OnmsIpInterface> actualSet) throws Exception {
        this.assertSetsEqual(expectedSet, actualSet, "ipAddress", new AssertEquals(){

            public void assertEqual(Object expected, Object actual) throws Exception {
                NodeDaoTest.this.assertInterfaceEquals((OnmsIpInterface)expected, (OnmsIpInterface)actual);
            }
        });
    }

    private void assertInterfaceEquals(OnmsIpInterface expected, OnmsIpInterface actual) throws Exception {
        String[] properties = new String[]{"ipAddress", "ifIndex", "ipHostName", "ipStatus", "node.id"};
        this.assertPropertiesEqual(properties, expected, actual);
        this.assertServicesEquals(expected.getMonitoredServices(), actual.getMonitoredServices());
    }

    private void assertServicesEquals(Set expectedSet, Set actualSet) throws Exception {
        this.assertSetsEqual(expectedSet, actualSet, "serviceId", new AssertEquals(){

            public void assertEqual(Object expected, Object actual) throws Exception {
                NodeDaoTest.this.assertServiceEquals((OnmsMonitoredService)expected, (OnmsMonitoredService)actual);
            }
        });
    }

    protected void assertServiceEquals(OnmsMonitoredService expected, OnmsMonitoredService actual) {
        NodeDaoTest.assertEquals((String)expected.getServiceName(), (String)actual.getServiceName());
    }

    private void assertPropertiesEqual(String[] properties, Object expected, Object actual) throws Exception {
        for (String property : properties) {
            this.assertPropertyEquals(property, expected, actual);
        }
    }

    private void assertPropertyEquals(String name, Object expected, Object actual) throws Exception {
        String expectedValue = BeanUtils.getProperty((Object)expected, (String)name);
        String actualValue = BeanUtils.getProperty((Object)actual, (String)name);
        NodeDaoTest.assertEquals((String)("Unexpected value for property " + name + " on object " + expected), (Object)expectedValue, (Object)actualValue);
    }

    public void testQuery2() {
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(6));
        NodeDaoTest.assertNotNull((Object)n);
        NodeDaoTest.assertEquals((int)3, (int)n.getIpInterfaces().size());
        NodeDaoTest.assertNotNull((Object)n.getAssetRecord());
        NodeDaoTest.assertEquals((String)"category1", (String)n.getAssetRecord().getDisplayCategory());
    }

    private OnmsDistPoller getDistPoller() {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost"));
        NodeDaoTest.assertNotNull((Object)distPoller);
        return distPoller;
    }

    private static interface AssertEquals {
        public void assertEqual(Object var1, Object var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertyComparator
    implements Comparator<Object> {
        String m_propertyName;

        public PropertyComparator(String propertyName) {
            this.m_propertyName = propertyName;
        }

        @Override
        public int compare(Object o1, Object o2) {
            try {
                String expectedValue = "" + BeanUtils.getProperty((Object)o1, (String)this.m_propertyName);
                String actualValue = "" + BeanUtils.getProperty((Object)o2, (String)this.m_propertyName);
                return expectedValue.compareTo(actualValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to compare property " + this.m_propertyName, e);
            }
        }
    }
}

