/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.model.OnmsIpInterface;

public class IpInterfaceDaoTest
extends AbstractTransactionalDaoTestCase {
    public void testGetByIpAddress() {
        Collection ifaces = this.getIpInterfaceDao().findByIpAddress("192.168.1.1");
        IpInterfaceDaoTest.assertEquals((int)1, (int)ifaces.size());
        OnmsIpInterface iface = (OnmsIpInterface)ifaces.iterator().next();
        IpInterfaceDaoTest.assertEquals((String)"node1", (String)iface.getNode().getLabel());
        int count = 0;
        Iterator it = iface.getMonitoredServices().iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        IpInterfaceDaoTest.assertEquals((int)2, (int)count);
        IpInterfaceDaoTest.assertEquals((int)2, (int)iface.getMonitoredServices().size());
        IpInterfaceDaoTest.assertEquals((String)"192.168.1.1", (String)iface.getInetAddress().getHostAddress());
    }

    public void testGetInterfacesForNodes() {
        Map interfaceNodes = this.getIpInterfaceDao().getInterfacesForNodes();
        IpInterfaceDaoTest.assertNotNull((String)"interfaceNodes", (Object)interfaceNodes);
        for (Map.Entry entry : interfaceNodes.entrySet()) {
            System.out.println((String)entry.getKey() + ": " + entry.getValue());
        }
        IpInterfaceDaoTest.assertEquals((String)"node ID for 192.168.1.1", (Object)new Integer(1), interfaceNodes.get("192.168.1.1"));
        IpInterfaceDaoTest.assertEquals((String)"node ID for 192.168.1.2", (Object)new Integer(1), interfaceNodes.get("192.168.1.2"));
        IpInterfaceDaoTest.assertEquals((String)"node ID for 192.168.2.1", (Object)new Integer(2), interfaceNodes.get("192.168.2.1"));
        IpInterfaceDaoTest.assertFalse((String)"node ID for *BOGUS*IP* should not have been found", (boolean)interfaceNodes.containsKey("*BOGUS*IP*"));
    }
}

