/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsNode;

public class CriteriaTestCase
extends AbstractTransactionalDaoTestCase {
    public void testSimple() {
        OnmsCriteria crit = new OnmsCriteria(OnmsNode.class);
        crit.add((Criterion)Restrictions.eq((String)"label", (Object)"node1"));
        List matching = this.getNodeDao().findMatching(crit);
        CriteriaTestCase.assertEquals((String)"Expect a single node with label node1", (int)1, (int)matching.size());
        OnmsNode node = (OnmsNode)matching.iterator().next();
        CriteriaTestCase.assertEquals((String)"node1", (String)node.getLabel());
        CriteriaTestCase.assertEquals((int)3, (int)node.getIpInterfaces().size());
    }

    public void testComplicated() {
        OnmsCriteria crit = new OnmsCriteria(OnmsNode.class).createAlias("ipInterfaces", "iface").add((Criterion)Restrictions.eq((String)"iface.ipAddress", (Object)"192.168.2.1"));
        List matching = this.getNodeDao().findMatching(crit);
        CriteriaTestCase.assertEquals((String)"Expect a single node with an interface 192.168.2.1", (int)1, (int)matching.size());
        OnmsNode node = (OnmsNode)matching.iterator().next();
        CriteriaTestCase.assertEquals((String)"node2", (String)node.getLabel());
        CriteriaTestCase.assertEquals((int)3, (int)node.getIpInterfaces().size());
    }
}

