/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceVisitor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ResourceTypeFilteringResourceVisitor
implements ResourceVisitor,
InitializingBean {
    private ResourceVisitor m_delegatedVisitor;
    private String m_resourceTypeMatch;

    public void visit(OnmsResource resource) {
        if (this.m_resourceTypeMatch.equals(resource.getResourceType().getName())) {
            this.m_delegatedVisitor.visit(resource);
        }
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_delegatedVisitor != null ? 1 : 0) != 0, (String)"property delegatedVisitor must be set to a non-null value");
        Assert.state((this.m_resourceTypeMatch != null ? 1 : 0) != 0, (String)"property resourceTypeMatch must be set to a non-null value");
    }

    public ResourceVisitor getDelegatedVisitor() {
        return this.m_delegatedVisitor;
    }

    public void setDelegatedVisitor(ResourceVisitor delegatedVisitor) {
        this.m_delegatedVisitor = delegatedVisitor;
    }

    public String getResourceTypeMatch() {
        return this.m_resourceTypeMatch;
    }

    public void setResourceTypeMatch(String resourceTypeMatch) {
        this.m_resourceTypeMatch = resourceTypeMatch;
    }
}

