/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.Serializable;
import java.util.SortedMap;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.filter.FilterDao;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class FilterWalker
implements InitializingBean {
    private NodeDao m_nodeDao;
    private FilterDao m_filterDao;
    private String m_filter;
    private EntityVisitor m_visitor;

    public void walk() {
        SortedMap map = this.getFilterDao().getNodeMap(this.m_filter);
        if (map != null) {
            for (Integer nodeId : map.keySet()) {
                OnmsNode node = (OnmsNode)this.getNodeDao().load((Serializable)nodeId);
                this.m_visitor.visitNode(node);
            }
        }
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_visitor != null ? 1 : 0) != 0, (String)"property visitor must be set to a non-null value");
        Assert.state((this.m_filterDao != null ? 1 : 0) != 0, (String)"property filterDao must be set to a non-null value");
        Assert.state((this.m_nodeDao != null ? 1 : 0) != 0, (String)"property nodeDao must be set to a non-null value");
        Assert.state((this.m_filter != null ? 1 : 0) != 0, (String)"property filter must be set to a non-null value");
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public EntityVisitor getVisitor() {
        return this.m_visitor;
    }

    public void setVisitor(EntityVisitor visitor) {
        this.m_visitor = visitor;
    }

    public FilterDao getFilterDao() {
        return this.m_filterDao;
    }

    public void setFilterDao(FilterDao filterDao) {
        this.m_filterDao = filterDao;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public void setFilter(String filter) {
        this.m_filter = filter;
    }
}

