/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.Collection;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.LinkStateDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsLinkState;
import org.springframework.orm.hibernate3.HibernateCallback;

public class LinkStateDaoHibernate
extends AbstractDaoHibernate<OnmsLinkState, Integer>
implements LinkStateDao {
    public LinkStateDaoHibernate() {
        super(OnmsLinkState.class);
    }

    public Collection<OnmsLinkState> findAll(final Integer offset, final Integer limit) {
        return (Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Collection<OnmsLinkState>>(){

            public Collection<OnmsLinkState> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(OnmsLinkState.class).setFirstResult(offset.intValue()).setMaxResults(limit.intValue()).list();
            }
        });
    }

    public OnmsLinkState findById(Integer id) {
        return (OnmsLinkState)this.findUnique("from OnmsLinkState as ls where ls.id = ?", id);
    }

    public OnmsLinkState findByDataLinkInterfaceId(Integer interfaceId) {
        return (OnmsLinkState)this.findUnique("from OnmsLinkState as ls where ls.dataLinkInterface.id = ?", interfaceId);
    }

    public Collection<OnmsLinkState> findByNodeId(Integer nodeId) {
        return this.find("from OnmsLinkState as ls where ls.dataLinkInterface.nodeId = ?", nodeId);
    }

    public Collection<OnmsLinkState> findByNodeParentId(Integer nodeParentId) {
        return this.find("from OnmsLinkState as ls where ls.dataLinkInterface.nodeParentId = ?", nodeParentId);
    }
}

