/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.AtInterfaceDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsAtInterface;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class AtInterfaceDaoHibernate
extends AbstractDaoHibernate<OnmsAtInterface, Integer>
implements AtInterfaceDao {
    private static final Logger LOG = LoggerFactory.getLogger(AtInterfaceDaoHibernate.class);
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;

    public AtInterfaceDaoHibernate() {
        super(OnmsAtInterface.class);
    }

    public void markDeletedIfNodeDeleted() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"D"));
        for (OnmsAtInterface iface : this.findMatching(criteria)) {
            iface.setStatus(OnmsArpInterface.StatusType.DELETED);
            this.saveOrUpdate(iface);
        }
    }

    public void deactivateForSourceNodeIdIfOlderThan(int nodeid, Date scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"sourceNodeId", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)OnmsArpInterface.StatusType.ACTIVE));
        for (OnmsAtInterface iface : this.findMatching(criteria)) {
            iface.setStatus(OnmsArpInterface.StatusType.INACTIVE);
            this.saveOrUpdate(iface);
        }
    }

    public void deleteForNodeSourceIdIfOlderThan(int nodeid, Date scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"sourceNodeId", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)"status", (Object)OnmsArpInterface.StatusType.ACTIVE)));
        for (OnmsAtInterface iface : this.findMatching(criteria)) {
            this.delete(iface);
        }
    }

    public Collection<OnmsAtInterface> findByMacAddress(String macAddress) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"macAddress", (Object)macAddress));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)OnmsArpInterface.StatusType.DELETED));
        return this.findMatching(criteria);
    }

    public void setStatusForNode(Integer nodeid, OnmsArpInterface.StatusType action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid), (Criterion)Restrictions.eq((String)"sourceNodeId", (Object)nodeid)));
        for (OnmsAtInterface iface : this.findMatching(criteria)) {
            iface.setStatus(action);
            this.saveOrUpdate(iface);
        }
    }

    public void setStatusForNodeAndIp(Integer nodeid, String ipAddr, OnmsArpInterface.StatusType action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)ipAddr));
        for (OnmsAtInterface iface : this.findMatching(criteria)) {
            iface.setStatus(action);
            this.saveOrUpdate(iface);
        }
    }

    public void setStatusForNodeAndIfIndex(Integer nodeid, Integer ifIndex, OnmsArpInterface.StatusType action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.eq((String)"ifIndex", (Object)ifIndex));
        for (OnmsAtInterface iface : this.findMatching(criteria)) {
            iface.setStatus(action);
            this.saveOrUpdate(iface);
        }
    }

    public OnmsAtInterface findByNodeAndAddress(Integer nodeId, InetAddress ipAddress, String macAddress) {
        String addressString = InetAddressUtils.str((InetAddress)ipAddress);
        return (OnmsAtInterface)this.findUnique("from OnmsAtInterface atInterface where atInterface.node.id = ? and atInterface.ipAddress = ? and atInterface.macAddress = ?", nodeId, addressString, macAddress);
    }

    public Collection<OnmsAtInterface> getAtInterfaceForAddress(InetAddress address) {
        String addressString = InetAddressUtils.str((InetAddress)address);
        if (address.isLoopbackAddress() || addressString.equals("0.0.0.0")) {
            return null;
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"A"));
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)addressString));
        List<OnmsAtInterface> interfaces = this.findMatching(criteria);
        if (interfaces.isEmpty()) {
            LOG.debug("getAtInterfaceForAddress: No AtInterface matched address {}!", (Object)addressString);
            LOG.debug("getAtInterfaceForAddress: search IpInterface for address {}!", (Object)addressString);
            for (OnmsIpInterface iface : this.m_ipInterfaceDao.findByIpAddress(addressString)) {
                interfaces.add(new OnmsAtInterface(iface.getNode(), iface.getIpAddress()));
            }
        }
        return interfaces;
    }
}

