/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import org.opennms.core.spring.FileReloadCallback;
import org.opennms.core.spring.FileReloadContainer;
import org.opennms.core.xml.CastorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public abstract class AbstractCastorConfigDao<K, V>
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCastorConfigDao.class);
    private Class<K> m_castorClass;
    private String m_description;
    private Resource m_configResource;
    private FileReloadContainer<V> m_container;
    private CastorReloadCallback m_callback = new CastorReloadCallback();
    private Long m_reloadCheckInterval = null;

    public AbstractCastorConfigDao(Class<K> entityClass, String description) {
        this.m_castorClass = entityClass;
        this.m_description = description;
    }

    public abstract V translateConfig(K var1);

    protected V loadConfig(Resource resource) {
        long startTime = System.currentTimeMillis();
        LOG.debug("Loading {} configuration from {}", (Object)this.m_description, (Object)resource);
        V config = this.translateConfig(CastorUtils.unmarshalWithTranslatedExceptions(this.m_castorClass, (Resource)resource));
        long endTime = System.currentTimeMillis();
        LOG.info(this.createLoadedLogMessage(config, endTime - startTime));
        return config;
    }

    protected String createLoadedLogMessage(V translatedConfig, long diffTime) {
        return "Loaded " + this.getDescription() + " in " + diffTime + "ms";
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_configResource != null ? 1 : 0) != 0, (String)"property configResource must be set and be non-null");
        V config = this.loadConfig(this.m_configResource);
        this.m_container = new FileReloadContainer(config, this.m_configResource, (FileReloadCallback)this.m_callback);
        if (this.m_reloadCheckInterval != null) {
            this.m_container.setReloadCheckInterval(this.m_reloadCheckInterval.longValue());
        }
    }

    public Resource getConfigResource() {
        return this.m_configResource;
    }

    public void setConfigResource(Resource configResource) {
        this.m_configResource = configResource;
    }

    protected FileReloadContainer<V> getContainer() {
        return this.m_container;
    }

    public Long getReloadCheckInterval() {
        return this.m_reloadCheckInterval;
    }

    public void setReloadCheckInterval(Long reloadCheckInterval) {
        this.m_reloadCheckInterval = reloadCheckInterval;
        if (this.m_reloadCheckInterval != null && this.m_container != null) {
            this.m_container.setReloadCheckInterval(this.m_reloadCheckInterval.longValue());
        }
    }

    public String getDescription() {
        return this.m_description;
    }

    public class CastorReloadCallback
    implements FileReloadCallback<V> {
        public V reload(V object, Resource resource) {
            return AbstractCastorConfigDao.this.loadConfig(resource);
        }
    }
}

