/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.LazyList;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeResourceType
implements OnmsResourceType {
    private static final Logger LOG = LoggerFactory.getLogger(NodeResourceType.class);
    protected static final Set<OnmsAttribute> s_emptyAttributeSet = Collections.unmodifiableSet(new HashSet());
    protected ResourceDao m_resourceDao;

    public NodeResourceType(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public String getLabel() {
        return "Node";
    }

    public String getName() {
        return "node";
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        return null;
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        return null;
    }

    public List<OnmsResource> getResourcesForNodeSource(String nodeSource, int nodeId) {
        return null;
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return false;
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return false;
    }

    public boolean isResourceTypeOnNodeSource(String nodeSource, int nodeId) {
        return false;
    }

    public String getLinkForResource(OnmsResource resource) {
        return "element/node.jsp?node=" + resource.getName();
    }

    public OnmsResource createChildResource(OnmsNode node) {
        NodeChildResourceLoader loader = new NodeChildResourceLoader(node.getId(), node.getForeignSource(), node.getForeignId());
        OnmsResource r = new OnmsResource(node.getId().toString(), node.getLabel(), (OnmsResourceType)this, s_emptyAttributeSet, (List)new LazyList((LazyList.Loader)loader));
        r.setEntity((OnmsEntity)node);
        loader.setParent(r);
        return r;
    }

    private class NodeChildResourceLoader
    implements LazyList.Loader<OnmsResource> {
        private int m_nodeId;
        private String m_nodeSource;
        private OnmsResource m_parent;

        public NodeChildResourceLoader(int nodeId, String foreignSource, String foreignId) {
            this.m_nodeId = nodeId;
            this.m_nodeSource = foreignSource + ':' + foreignId;
        }

        public void setParent(OnmsResource parent) {
            this.m_parent = parent;
        }

        public List<OnmsResource> load() {
            LinkedList<OnmsResource> children = new LinkedList<OnmsResource>();
            if (ResourceTypeUtils.isStoreByForeignSource()) {
                for (OnmsResourceType resourceType : this.getResourceTypesForNodeSource(this.m_nodeSource, this.m_nodeId)) {
                    for (OnmsResource resource : resourceType.getResourcesForNodeSource(this.m_nodeSource, this.m_nodeId)) {
                        resource.setParent(this.m_parent);
                        children.add(resource);
                        LOG.debug("load: adding resource {}", (Object)resource.toString());
                    }
                }
            } else {
                for (OnmsResourceType resourceType : this.getResourceTypesForNode(this.m_nodeId)) {
                    for (OnmsResource resource : resourceType.getResourcesForNode(this.m_nodeId)) {
                        resource.setParent(this.m_parent);
                        children.add(resource);
                        LOG.debug("load: adding resource {}", (Object)resource.toString());
                    }
                }
            }
            return children;
        }

        private Collection<OnmsResourceType> getResourceTypesForNode(int nodeId) {
            LinkedList<OnmsResourceType> resourceTypes = new LinkedList<OnmsResourceType>();
            for (OnmsResourceType resourceType : NodeResourceType.this.m_resourceDao.getResourceTypes()) {
                if (!resourceType.isResourceTypeOnNode(nodeId)) continue;
                resourceTypes.add(resourceType);
            }
            return resourceTypes;
        }

        private Collection<OnmsResourceType> getResourceTypesForNodeSource(String nodeSource, int nodeId) {
            LinkedList<OnmsResourceType> resourceTypes = new LinkedList<OnmsResourceType>();
            for (OnmsResourceType resourceType : NodeResourceType.this.m_resourceDao.getResourceTypes()) {
                if (!resourceType.isResourceTypeOnNodeSource(nodeSource, nodeId)) continue;
                resourceTypes.add(resourceType);
            }
            return resourceTypes;
        }
    }
}

