/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.util.List;
import org.opennms.netmgt.config.StorageStrategy;
import org.opennms.netmgt.config.StorageStrategyService;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.datacollection.Parameter;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexStorageStrategy
implements StorageStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(IndexStorageStrategy.class);
    private String m_resourceTypeName;
    protected StorageStrategyService m_storageStrategyService;

    public String getRelativePathForAttribute(String resourceParent, String resource, String attribute) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(resourceParent);
        buffer.append(File.separator);
        buffer.append(this.m_resourceTypeName);
        buffer.append(File.separator);
        buffer.append(resource);
        if (attribute != null) {
            buffer.append(File.separator);
            buffer.append(attribute);
            buffer.append(RrdFileConstants.getRrdSuffix());
        }
        return buffer.toString();
    }

    public void setResourceTypeName(String name) {
        this.m_resourceTypeName = name;
    }

    public String getResourceTypeName() {
        return this.m_resourceTypeName;
    }

    public String getResourceNameFromIndex(CollectionResource resource) {
        return resource.getInstance();
    }

    public void setStorageStrategyService(StorageStrategyService agent) {
        this.m_storageStrategyService = agent;
    }

    public void setParameters(List<Parameter> parameterCollection) throws IllegalArgumentException {
    }
}

