/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.DataCollectionConfigDao;
import org.opennms.netmgt.config.StorageStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.support.DistributedStatusResourceType;
import org.opennms.netmgt.dao.support.DomainResourceType;
import org.opennms.netmgt.dao.support.GenericIndexResourceType;
import org.opennms.netmgt.dao.support.InterfaceSnmpResourceType;
import org.opennms.netmgt.dao.support.NodeResourceType;
import org.opennms.netmgt.dao.support.NodeSnmpResourceType;
import org.opennms.netmgt.dao.support.NodeSourceResourceType;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.dao.support.ResponseTimeResourceType;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;

public class DefaultResourceDao
implements ResourceDao,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResourceDao.class);
    public static final String STRINGS_PROPERTIES_FILE_NAME = "strings.properties";
    public static final String INTERFACE_GRAPH_TYPE = "interface";
    public static final String RESPONSE_DIRECTORY = "response";
    public static final String SNMP_DIRECTORY = "snmp";
    public static final String FOREIGN_SOURCE_DIRECTORY = "fs";
    private NodeDao m_nodeDao;
    private LocationMonitorDao m_locationMonitorDao;
    private File m_rrdDirectory;
    private CollectdConfigFactory m_collectdConfig;
    private DataCollectionConfigDao m_dataCollectionConfigDao;
    private Date m_lastUpdateDataCollectionConfig;
    private Map<String, OnmsResourceType> m_resourceTypes;
    private NodeResourceType m_nodeResourceType;
    private DomainResourceType m_domainResourceType;
    private NodeSourceResourceType m_nodeSourceResourceType;

    public void setRrdDirectory(File rrdDirectory) {
        this.m_rrdDirectory = rrdDirectory;
    }

    public File getRrdDirectory() {
        return this.m_rrdDirectory;
    }

    public File getRrdDirectory(boolean verify) {
        if (verify && !this.getRrdDirectory().isDirectory()) {
            throw new ObjectRetrievalFailureException("RRD directory does not exist: " + this.getRrdDirectory().getAbsolutePath(), (Object)this.getRrdDirectory());
        }
        return this.getRrdDirectory();
    }

    public DataCollectionConfigDao getDataCollectionConfigDao() {
        return this.m_dataCollectionConfigDao;
    }

    public void setDataCollectionConfigDao(DataCollectionConfigDao dataCollectionConfigDao) {
        this.m_dataCollectionConfigDao = dataCollectionConfigDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public CollectdConfigFactory getCollectdConfig() {
        return this.m_collectdConfig;
    }

    public void setCollectdConfig(CollectdConfigFactory collectdConfig) {
        this.m_collectdConfig = collectdConfig;
    }

    public LocationMonitorDao getLocationMonitorDao() {
        return this.m_locationMonitorDao;
    }

    public void setLocationMonitorDao(LocationMonitorDao locationMonitorDao) {
        this.m_locationMonitorDao = locationMonitorDao;
    }

    public void afterPropertiesSet() throws IOException {
        if (this.m_rrdDirectory == null) {
            throw new IllegalStateException("rrdDirectory property has not been set");
        }
        if (this.m_collectdConfig == null) {
            throw new IllegalStateException("collectdConfig property has not been set");
        }
        if (this.m_dataCollectionConfigDao == null) {
            throw new IllegalStateException("dataCollectionConfig property has not been set");
        }
        if (this.m_nodeDao == null) {
            throw new IllegalStateException("nodeDao property has not been set");
        }
        if (this.m_locationMonitorDao == null) {
            throw new IllegalStateException("locationMonitorDao property has not been set");
        }
        this.initResourceTypes();
    }

    private void initResourceTypes() throws IOException {
        LinkedHashMap<String, OnmsResourceType> resourceTypes = new LinkedHashMap<String, OnmsResourceType>();
        Object resourceType = new NodeSnmpResourceType(this);
        resourceTypes.put(resourceType.getName(), (OnmsResourceType)resourceType);
        resourceType = new InterfaceSnmpResourceType(this, this.m_nodeDao);
        resourceTypes.put(resourceType.getName(), (OnmsResourceType)resourceType);
        resourceType = new ResponseTimeResourceType(this, this.m_nodeDao);
        resourceTypes.put(resourceType.getName(), (OnmsResourceType)resourceType);
        resourceType = new DistributedStatusResourceType(this, this.m_locationMonitorDao);
        resourceTypes.put(resourceType.getName(), (OnmsResourceType)resourceType);
        resourceTypes.putAll(this.getGenericIndexResourceTypes());
        this.m_nodeResourceType = new NodeResourceType(this);
        resourceTypes.put(this.m_nodeResourceType.getName(), this.m_nodeResourceType);
        this.m_domainResourceType = new DomainResourceType(this);
        resourceTypes.put(this.m_domainResourceType.getName(), this.m_domainResourceType);
        this.m_nodeSourceResourceType = new NodeSourceResourceType(this, this.m_nodeDao);
        resourceTypes.put(this.m_nodeSourceResourceType.getName(), this.m_nodeSourceResourceType);
        this.m_resourceTypes = resourceTypes;
        this.m_lastUpdateDataCollectionConfig = this.m_dataCollectionConfigDao.getLastUpdate();
    }

    private Map<String, GenericIndexResourceType> getGenericIndexResourceTypes() {
        LinkedHashMap<String, GenericIndexResourceType> resourceTypes = new LinkedHashMap<String, GenericIndexResourceType>();
        Map configuredResourceTypes = this.m_dataCollectionConfigDao.getConfiguredResourceTypes();
        LinkedList resourceTypeList = new LinkedList(configuredResourceTypes.values());
        Collections.sort(resourceTypeList, new Comparator<ResourceType>(){

            @Override
            public int compare(ResourceType r0, ResourceType r1) {
                return r0.getLabel().compareTo(r1.getLabel());
            }
        });
        for (ResourceType resourceType : resourceTypeList) {
            StorageStrategy storageStrategy;
            Class<?> cinst;
            String className = resourceType.getStorageStrategy().getClazz();
            try {
                cinst = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not load class '" + className + "' for resource type '" + resourceType.getName() + "'", (Throwable)e);
            }
            try {
                storageStrategy = (StorageStrategy)cinst.newInstance();
            }
            catch (InstantiationException e) {
                throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate class '" + className + "' for resource type '" + resourceType.getName() + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate class '" + className + "' for resource type '" + resourceType.getName() + "'", (Throwable)e);
            }
            storageStrategy.setResourceTypeName(resourceType.getName());
            GenericIndexResourceType genericIndexResourceType = new GenericIndexResourceType(this, resourceType.getName(), resourceType.getLabel(), resourceType.getResourceLabel(), storageStrategy);
            resourceTypes.put(genericIndexResourceType.getName(), genericIndexResourceType);
        }
        return resourceTypes;
    }

    public Collection<OnmsResourceType> getResourceTypes() {
        if (this.isDataCollectionConfigChanged()) {
            try {
                this.initResourceTypes();
            }
            catch (IOException e) {
                LOG.error("Can't reload resource types.", (Throwable)e);
            }
        }
        return this.m_resourceTypes.values();
    }

    private boolean isDataCollectionConfigChanged() {
        Date current = this.m_dataCollectionConfigDao.getLastUpdate();
        if (current.after(this.m_lastUpdateDataCollectionConfig)) {
            this.m_lastUpdateDataCollectionConfig = current;
            return true;
        }
        return false;
    }

    public OnmsResource getResourceById(String id) {
        OnmsResource resource = null;
        Pattern p = Pattern.compile("([^\\[]+)\\[([^\\]]*)\\](?:\\.|$)");
        Matcher m = p.matcher(id);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String resourceTypeName = DefaultResourceDao.decode(m.group(1));
            String resourceName = DefaultResourceDao.decode(m.group(2));
            try {
                resource = resource == null ? this.getTopLevelResource(resourceTypeName, resourceName) : this.getChildResource(resource, resourceTypeName, resourceName);
            }
            catch (Throwable e) {
                LOG.warn("Could not get resource for resource ID \"{}\"", (Object)id, (Object)e);
                return null;
            }
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        if (sb.length() > 0) {
            LOG.warn("resource ID '{}' does not match pattern '{}' at '{}'", new Object[]{id, p.toString(), sb});
            return null;
        }
        return resource;
    }

    public List<OnmsResource> getResourceListById(String id) throws IllegalArgumentException, ObjectRetrievalFailureException {
        OnmsResource topLevelResource = null;
        Pattern p = Pattern.compile("([^\\[]+)\\[([^\\]]*)\\](?:\\.|$)");
        Matcher m = p.matcher(id);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String resourceTypeName = DefaultResourceDao.decode(m.group(1));
            String resourceName = DefaultResourceDao.decode(m.group(2));
            try {
                if (topLevelResource != null) {
                    return this.getChildResourceList(topLevelResource);
                }
                topLevelResource = this.getTopLevelResource(resourceTypeName, resourceName);
            }
            catch (Throwable e) {
                throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)id, "Could not get resource for resource ID '" + id + "'", e);
            }
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        if (sb.length() > 0) {
            throw new IllegalArgumentException("resource ID '" + id + "' does not match pattern '" + p.toString() + "' at '" + sb + "'");
        }
        return null;
    }

    protected OnmsResource getTopLevelResource(String resourceType, String resource) throws ObjectRetrievalFailureException {
        if ("node".equals(resourceType)) {
            return this.getNodeEntityResource(resource);
        }
        if ("nodeSource".equals(resourceType)) {
            return this.getForeignSourceNodeEntityResource(resource);
        }
        if ("domain".equals(resourceType)) {
            return this.getDomainEntityResource(resource);
        }
        throw new ObjectRetrievalFailureException("Top-level resource type of '" + resourceType + "' is unknown", (Object)resourceType);
    }

    protected OnmsResource getChildResource(OnmsResource parentResource, String resourceType, String resource) {
        for (OnmsResource r : parentResource.getChildResources()) {
            if (!resourceType.equals(r.getResourceType().getName()) || !resource.equals(r.getName())) continue;
            LOG.debug("getChildResource: returning resource {}", (Object)r);
            return r;
        }
        throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)(resourceType + "/" + resource), "Could not find child resource '" + resource + "' with resource type '" + resourceType + "' on resource '" + resource + "'", null);
    }

    protected List<OnmsResource> getChildResourceList(OnmsResource parentResource) {
        LOG.debug("DefaultResourceDao: getChildResourceList for {}", (Object)parentResource.toString());
        return parentResource.getChildResources();
    }

    public List<OnmsResource> findNodeResources() {
        LinkedList<OnmsResource> resources = new LinkedList<OnmsResource>();
        Set<Integer> snmpNodes = this.findSnmpNodeDirectories();
        Set<String> responseTimeInterfaces = DefaultResourceDao.findChildrenMatchingFilter(new File(this.getRrdDirectory(), RESPONSE_DIRECTORY), RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        Set<String> distributedResponseTimeInterfaces = DefaultResourceDao.findChildrenChildrenMatchingFilter(new File(new File(this.getRrdDirectory(), RESPONSE_DIRECTORY), "distributed"), RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        Collection nodeIds = this.m_nodeDao.getNodeIds();
        TreeSet<Integer> nodesFound = new TreeSet<Integer>();
        for (Integer nodeId : nodeIds) {
            if (nodesFound.contains((int)nodeId)) continue;
            boolean found = false;
            OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)nodeId);
            if (snmpNodes.contains(nodeId)) {
                found = true;
            } else if (!(responseTimeInterfaces.size() <= 0 && distributedResponseTimeInterfaces.size() <= 0 || node.getForeignSource() != null && node.getForeignId() != null)) {
                for (OnmsIpInterface ip : ((OnmsNode)this.m_nodeDao.get((Serializable)nodeId)).getIpInterfaces()) {
                    String addr = InetAddressUtils.str((InetAddress)ip.getIpAddress());
                    if (!responseTimeInterfaces.contains(addr) && !distributedResponseTimeInterfaces.contains(addr)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            resources.add(this.m_nodeResourceType.createChildResource(node));
            nodesFound.add(nodeId);
        }
        return resources;
    }

    public List<OnmsResource> findNodeSourceResources() {
        LinkedList<OnmsResource> resources = new LinkedList<OnmsResource>();
        Set<String> nodeSources = this.findNodeSourceDirectories();
        Set<String> responseTimeInterfaces = DefaultResourceDao.findChildrenMatchingFilter(new File(this.getRrdDirectory(), RESPONSE_DIRECTORY), RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        Set<String> distributedResponseTimeInterfaces = DefaultResourceDao.findChildrenChildrenMatchingFilter(new File(new File(this.getRrdDirectory(), RESPONSE_DIRECTORY), "distributed"), RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        List nodes = this.m_nodeDao.findAll();
        TreeSet<Integer> nodesFound = new TreeSet<Integer>();
        for (OnmsNode node : nodes) {
            if (nodesFound.contains(node.getId())) continue;
            boolean found = false;
            if (node.getForeignSource() != null && node.getForeignId() != null) {
                if (nodeSources.contains(node.getForeignSource() + ":" + node.getForeignId())) {
                    found = true;
                } else if (responseTimeInterfaces.size() > 0 || distributedResponseTimeInterfaces.size() > 0) {
                    for (OnmsIpInterface ip : node.getIpInterfaces()) {
                        String addr = InetAddressUtils.str((InetAddress)ip.getIpAddress());
                        if (!responseTimeInterfaces.contains(addr) && !distributedResponseTimeInterfaces.contains(addr)) continue;
                        found = true;
                        break;
                    }
                }
            }
            if (!found) continue;
            resources.add(this.m_nodeSourceResourceType.createChildResource(node.getForeignSource() + ":" + node.getForeignId()));
            nodesFound.add(node.getId());
            LOG.debug("findNodeSourceResources: adding resource for {}:{}", (Object)node.getForeignSource(), (Object)node.getForeignId());
        }
        return resources;
    }

    public List<OnmsResource> findDomainResources() {
        LinkedList<OnmsResource> resources = new LinkedList<OnmsResource>();
        File snmp = new File(this.getRrdDirectory(), SNMP_DIRECTORY);
        File[] domainDirs = snmp.listFiles(RrdFileConstants.DOMAIN_DIRECTORY_FILTER);
        if (domainDirs != null && domainDirs.length > 0) {
            for (File domainDir : domainDirs) {
                resources.add(this.m_domainResourceType.createChildResource(domainDir.getName()));
            }
        }
        return resources;
    }

    protected OnmsResource getNodeEntityResource(String resource) {
        int nodeId;
        try {
            nodeId = Integer.parseInt(resource);
        }
        catch (NumberFormatException e) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)resource, "Top-level resource of resource type node is not numeric: " + resource, null);
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)resource, "Top-level resource of resource type node could not be found: " + resource, null);
        }
        OnmsResource onmsResource = this.getResourceForNode(node);
        return onmsResource;
    }

    protected OnmsResource getForeignSourceNodeEntityResource(String resource) {
        File idDir = new File(this.getRrdDirectory(), SNMP_DIRECTORY + File.separator + ResourceTypeUtils.getRelativeNodeSourceDirectory(resource).toString());
        if (idDir.isDirectory() && RrdFileConstants.NODESOURCE_DIRECTORY_FILTER.accept(idDir)) {
            return this.m_nodeSourceResourceType.createChildResource(resource);
        }
        LOG.debug("resource {} not found by foreign source/foreignId. Trying as a node resource instead...", (Object)resource);
        String[] ident = resource.split(":");
        OnmsNode node = this.m_nodeDao.findByForeignId(ident[0], ident[1]);
        if (node == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)resource, "Top-level resource of resource type node could not be found: " + resource, null);
        }
        OnmsResource onmsResource = this.getResourceForNode(node);
        return onmsResource;
    }

    protected OnmsResource getDomainEntityResource(String domain) {
        File directory = new File(this.getRrdDirectory(), SNMP_DIRECTORY);
        File domainDir = new File(directory, domain);
        if (!domainDir.isDirectory()) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)domain, "Domain not found due to domain RRD directory not existing or not a directory: " + domainDir.getAbsolutePath(), null);
        }
        if (!RrdFileConstants.DOMAIN_DIRECTORY_FILTER.accept(domainDir)) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)domain, "Domain not found due to domain RRD directory not matching the domain directory filter: " + domainDir.getAbsolutePath(), null);
        }
        return this.m_domainResourceType.createChildResource(domain);
    }

    private Set<Integer> findSnmpNodeDirectories() {
        TreeSet<Integer> nodes = new TreeSet<Integer>();
        File directory = new File(this.getRrdDirectory(), SNMP_DIRECTORY);
        File[] nodeDirs = directory.listFiles(RrdFileConstants.NODE_DIRECTORY_FILTER);
        if (nodeDirs == null || nodeDirs.length == 0) {
            return nodes;
        }
        for (File nodeDir : nodeDirs) {
            try {
                Integer nodeId = Integer.valueOf(nodeDir.getName());
                nodes.add(nodeId);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return nodes;
    }

    public Set<String> findNodeSourceDirectories() {
        HashSet<String> nodeSourceDirectories = new HashSet<String>();
        File snmpDir = new File(this.getRrdDirectory(), SNMP_DIRECTORY);
        File forSrcDir = new File(snmpDir, FOREIGN_SOURCE_DIRECTORY);
        File[] sourceDirs = forSrcDir.listFiles(RrdFileConstants.SOURCE_DIRECTORY_FILTER);
        if (sourceDirs != null) {
            for (File sourceDir : sourceDirs) {
                File[] ids;
                for (File id : ids = sourceDir.listFiles(RrdFileConstants.NODESOURCE_DIRECTORY_FILTER)) {
                    nodeSourceDirectories.add(sourceDir.getName() + ":" + id.getName());
                }
            }
        }
        return nodeSourceDirectories;
    }

    private static Set<String> findChildrenMatchingFilter(File directory, FileFilter filter) {
        HashSet<String> children = new HashSet<String>();
        File[] nodeDirs = directory.listFiles(filter);
        if (nodeDirs == null || nodeDirs.length == 0) {
            return children;
        }
        for (File nodeDir : nodeDirs) {
            children.add(nodeDir.getName());
        }
        return children;
    }

    private static Set<String> findChildrenChildrenMatchingFilter(File directory, FileFilter filter) {
        HashSet<String> children = new HashSet<String>();
        File[] locationMonitorDirs = directory.listFiles();
        if (locationMonitorDirs == null) {
            return children;
        }
        for (File locationMonitorDir : locationMonitorDirs) {
            File[] intfDirs = locationMonitorDir.listFiles(filter);
            if (intfDirs == null || intfDirs.length == 0) continue;
            for (File intfDir : intfDirs) {
                children.add(intfDir.getName());
            }
        }
        return children;
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public OnmsResource getResourceForNode(OnmsNode node) {
        Assert.notNull((Object)node, (String)"node argument must not be null");
        return this.m_nodeResourceType.createChildResource(node);
    }

    private OnmsResource getChildResourceForNode(OnmsNode node, String resourceTypeName, String resourceName) {
        OnmsResource nodeResource = this.getResourceForNode(node);
        if (nodeResource == null) {
            return null;
        }
        List childResources = nodeResource.getChildResources();
        for (OnmsResource childResource : childResources) {
            if (!resourceTypeName.equals(childResource.getResourceType().getName()) || !resourceName.equals(childResource.getName())) continue;
            return childResource;
        }
        return null;
    }

    public OnmsResource getResourceForIpInterface(OnmsIpInterface ipInterface) {
        Assert.notNull((Object)ipInterface, (String)"ipInterface argument must not be null");
        Assert.notNull((Object)ipInterface.getNode(), (String)"getNode() on ipInterface must not return null");
        String ipAddress = InetAddressUtils.str((InetAddress)ipInterface.getIpAddress());
        return this.getChildResourceForNode(ipInterface.getNode(), "responseTime", ipAddress);
    }

    public OnmsResource getResourceForIpInterface(OnmsIpInterface ipInterface, OnmsLocationMonitor locMon) {
        Assert.notNull((Object)ipInterface, (String)"ipInterface argument must not be null");
        Assert.notNull((Object)locMon, (String)"locMon argument must not be null");
        Assert.notNull((Object)ipInterface.getNode(), (String)"getNode() on ipInterface must not return null");
        String ipAddress = InetAddressUtils.str((InetAddress)ipInterface.getIpAddress());
        return this.getChildResourceForNode(ipInterface.getNode(), "distributedStatus", locMon.getId() + File.separator + ipAddress);
    }

    public List<OnmsResource> findTopLevelResources() {
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        resources.addAll(this.findNodeResources());
        resources.addAll(this.findNodeSourceResources());
        resources.addAll(this.findDomainResources());
        return resources;
    }
}

