/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.api.StpNodeDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsStpNode;

public class StpNodeDaoHibernate
extends AbstractDaoHibernate<OnmsStpNode, Integer>
implements StpNodeDao {
    public StpNodeDaoHibernate() {
        super(OnmsStpNode.class);
    }

    public void markDeletedIfNodeDeleted() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpNode.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"D"));
        for (OnmsStpNode stpNode : this.findMatching(criteria)) {
            stpNode.setStatus(OnmsArpInterface.StatusType.DELETED);
            this.saveOrUpdate(stpNode);
        }
    }

    public void deactivateForNodeIdIfOlderThan(int nodeid, Date scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpNode.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)OnmsArpInterface.StatusType.ACTIVE));
        for (OnmsStpNode item : this.findMatching(criteria)) {
            item.setStatus(OnmsArpInterface.StatusType.INACTIVE);
            this.saveOrUpdate(item);
        }
    }

    public void deleteForNodeIdIfOlderThan(int nodeid, Date scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpNode.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)"status", (Object)OnmsArpInterface.StatusType.ACTIVE)));
        for (OnmsStpNode item : this.findMatching(criteria)) {
            this.delete(item);
        }
    }

    public void setStatusForNode(Integer nodeid, OnmsArpInterface.StatusType action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpNode.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        for (OnmsStpNode item : this.findMatching(criteria)) {
            item.setStatus(action);
            this.saveOrUpdate(item);
        }
    }

    public OnmsStpNode findByNodeAndVlan(Integer nodeId, Integer baseVlan) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpNode.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"baseVlan", (Object)baseVlan));
        List stpNodes = this.findMatching(criteria);
        if (stpNodes != null && stpNodes.size() > 0) {
            return (OnmsStpNode)stpNodes.get(0);
        }
        return null;
    }
}

