/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.model.outage.OutageSummary;
import org.springframework.orm.hibernate3.HibernateCallback;

public class OutageDaoHibernate
extends AbstractDaoHibernate<OnmsOutage, Integer>
implements OutageDao {
    public OutageDaoHibernate() {
        super(OnmsOutage.class);
    }

    public Integer currentOutageCount() {
        return this.queryInt("select count(*) from OnmsOutage as o where o.ifRegainedService is null");
    }

    public Collection<OnmsOutage> currentOutages() {
        return this.find("from OnmsOutage as o where o.ifRegainedService is null");
    }

    public OnmsOutage currentOutageForService(OnmsMonitoredService service) {
        return (OnmsOutage)this.findUnique("from OnmsOutage as o where o.monitoredService = ? and o.ifRegainedService is null", service);
    }

    public Collection<OnmsOutage> findAll(final Integer offset, final Integer limit) {
        return (Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Collection<OnmsOutage>>(){

            public Collection<OnmsOutage> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(OnmsOutage.class).setFirstResult(offset.intValue()).setMaxResults(limit.intValue()).list();
            }
        });
    }

    public Collection<OnmsOutage> matchingCurrentOutages(ServiceSelector selector) {
        HashSet matchingAddrs = new HashSet(FilterDaoFactory.getInstance().getIPAddressList(selector.getFilterRule()));
        HashSet matchingSvcs = new HashSet(selector.getServiceNames());
        LinkedList<OnmsOutage> matchingOutages = new LinkedList<OnmsOutage>();
        Collection<OnmsOutage> outages = this.currentOutages();
        for (OnmsOutage outage : outages) {
            OnmsMonitoredService svc = outage.getMonitoredService();
            if (!matchingSvcs.contains(svc.getServiceName()) && !matchingSvcs.isEmpty() || !matchingAddrs.contains(svc.getIpAddress())) continue;
            matchingOutages.add(outage);
        }
        return matchingOutages;
    }

    public int countOutagesByNode() {
        return this.getNodeOutageSummaries(0).size();
    }

    public List<OutageSummary> getNodeOutageSummaries(int rows) {
        List<OutageSummary> outages = this.findObjects(OutageSummary.class, "SELECT DISTINCT new org.opennms.netmgt.model.outage.OutageSummary(node.id, node.label, max(outage.ifLostService)) FROM OnmsOutage AS outage LEFT JOIN outage.monitoredService AS monitoredService LEFT JOIN monitoredService.ipInterface AS ipInterface LEFT JOIN ipInterface.node AS node WHERE outage.ifRegainedService IS NULL GROUP BY node.id, node.label ORDER BY max(outage.ifLostService) DESC, node.label ASC, node.id ASC", new Object[0]);
        if (rows == 0 || outages.size() < rows) {
            return outages;
        }
        return outages.subList(0, rows);
    }
}

