/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.Collection;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.OnmsMapElementDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapElement;
import org.springframework.orm.hibernate3.HibernateCallback;

public class OnmsMapElementDaoHibernate
extends AbstractDaoHibernate<OnmsMapElement, Integer>
implements OnmsMapElementDao {
    public OnmsMapElementDaoHibernate() {
        super(OnmsMapElement.class);
    }

    public Collection<OnmsMapElement> findAll(final Integer offset, final Integer limit) {
        return (Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Collection<OnmsMapElement>>(){

            public Collection<OnmsMapElement> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(OnmsMap.class).setFirstResult(offset.intValue()).setMaxResults(limit.intValue()).list();
            }
        });
    }

    public OnmsMapElement findElementById(int id) {
        return (OnmsMapElement)this.findUnique("from OnmsMapElement as element where element.id = ?", id);
    }

    public Collection<OnmsMapElement> findElementsByMapId(OnmsMap map) {
        return this.find("from OnmsMapElement as element where element.map = ?", map);
    }

    public Collection<OnmsMapElement> findElementsByNodeId(int nodeid) {
        Object[] values = new Object[]{nodeid, "N", "H"};
        return this.find("from OnmsMapElement as element where element.elementId = ? and (element.type = ? or element.type = ? )", values);
    }

    public void deleteElementsByMapId(final OnmsMap map) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Void>(){

            public Void doInHibernate(Session session) throws HibernateException, SQLException {
                String hql = "delete from OnmsMapElement as element where element.map.id = :mapId";
                Query query = session.createQuery(hql);
                query.setInteger("mapId", map.getId());
                query.executeUpdate();
                return null;
            }
        });
    }

    public void deleteElementsByNodeid(final int nodeid) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Void>(){

            public Void doInHibernate(Session session) throws HibernateException, SQLException {
                String hql = "delete from OnmsMapElement as element where element.elementId = :nodeId and ( element.type = :typenode or element.type = :typemap )";
                Query query = session.createQuery(hql);
                query.setInteger("nodeId", nodeid);
                query.setString("typenode", "N");
                query.setString("typemap", "H");
                query.executeUpdate();
                return null;
            }
        });
    }

    public void deleteElementsByType(final String type) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Void>(){

            public Void doInHibernate(Session session) throws HibernateException, SQLException {
                String hql = "delete from OnmsMapElement as element where element.type = :type";
                Query query = session.createQuery(hql);
                query.setString("type", type);
                query.executeUpdate();
                return null;
            }
        });
    }

    public void deleteElementsByElementIdAndType(final int id, final String type) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Void>(){

            public Void doInHibernate(Session session) throws HibernateException, SQLException {
                String hql = "delete from OnmsMapElement as element where element.elementId = :id and element.type = :type";
                Query query = session.createQuery(hql);
                query.setInteger("id", id);
                query.setString("type", type);
                query.executeUpdate();
                return null;
            }
        });
    }

    public Collection<OnmsMapElement> findElementsByElementIdAndType(int elementId, String type) {
        Object[] values = new Object[]{elementId, type};
        return this.find("from OnmsMapElement as element where element.elementId = ? and element.type = ?", values);
    }

    public Collection<OnmsMapElement> findElementsByType(String type) {
        return this.find("from OnmsMapElement as element where element.type = ?", type);
    }

    public OnmsMapElement findElement(int elementId, String type, OnmsMap map) {
        Object[] values = new Object[]{elementId, type, map};
        return (OnmsMapElement)this.findUnique("from OnmsMapElement as element where element.elementId = ? and element.type = ? and element.map = ?", values);
    }

    public void deleteElementsByMapType(final String mapType) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Void>(){

            public Void doInHibernate(Session session) throws HibernateException, SQLException {
                String hql = "delete from OnmsMapElement as element where element.id in ( select el.id from OnmsMapElement as el where el.map.type = ?)";
                Query query = session.createQuery(hql);
                query.setParameter(0, (Object)mapType);
                query.executeUpdate();
                return null;
            }
        });
    }

    public Collection<OnmsMapElement> findElementsByMapIdAndType(int mapId, String type) {
        Object[] values = new Object[]{mapId, type};
        return this.find("from OnmsMapElement as element where element.map.id = ? and element.type = ? ", values);
    }

    public Collection<OnmsMapElement> findMapElementsOnMap(int mapId) {
        Object[] values = new Object[]{mapId, "M", "W"};
        return this.find("from OnmsMapElement as element where element.map.id = ? and (element.type = ? or element.type= ? )", values);
    }

    public Collection<OnmsMapElement> findNodeElementsOnMap(int mapId) {
        Object[] values = new Object[]{mapId, "N", "H"};
        return this.find("from OnmsMapElement as element where element.map.id = ? and (element.type = ? or element.type= ? )", values);
    }

    public int countElementsOnMap(final int mapid) {
        Number nu = (Number)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException, SQLException {
                String hql = "select count(*) from OnmsMapElement as element where element.map.id = ?)";
                Query query = session.createQuery(hql);
                query.setParameter(0, (Object)mapid);
                return (Number)query.uniqueResult();
            }
        });
        return nu.intValue();
    }
}

