/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.api.IpRouteInterfaceDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpRouteInterface;

public class IpRouteInterfaceDaoHibernate
extends AbstractDaoHibernate<OnmsIpRouteInterface, Integer>
implements IpRouteInterfaceDao {
    public IpRouteInterfaceDaoHibernate() {
        super(OnmsIpRouteInterface.class);
    }

    public void markDeletedIfNodeDeleted() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"D"));
        for (OnmsIpRouteInterface ipRouteIface : this.findMatching(criteria)) {
            ipRouteIface.setStatus(OnmsArpInterface.StatusType.DELETED);
            this.saveOrUpdate(ipRouteIface);
        }
    }

    public void deactivateForNodeIdIfOlderThan(int nodeid, Date scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)OnmsArpInterface.StatusType.ACTIVE));
        for (OnmsIpRouteInterface item : this.findMatching(criteria)) {
            item.setStatus(OnmsArpInterface.StatusType.INACTIVE);
            this.saveOrUpdate(item);
        }
    }

    public void deleteForNodeIdIfOlderThan(int nodeid, Date scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)"status", (Object)OnmsArpInterface.StatusType.ACTIVE)));
        for (OnmsIpRouteInterface item : this.findMatching(criteria)) {
            this.delete(item);
        }
    }

    public void setStatusForNode(Integer nodeid, OnmsArpInterface.StatusType action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        for (OnmsIpRouteInterface item : this.findMatching(criteria)) {
            item.setStatus(action);
            this.saveOrUpdate(item);
        }
    }

    public void setStatusForNodeAndIfIndex(Integer nodeid, Integer ifIndex, OnmsArpInterface.StatusType action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.eq((String)"routeIfIndex", (Object)ifIndex));
        for (OnmsIpRouteInterface item : this.findMatching(criteria)) {
            item.setStatus(action);
            this.saveOrUpdate(item);
        }
    }

    public OnmsIpRouteInterface findByNodeAndDest(Integer id, String routeDest) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)id));
        criteria.add((Criterion)Restrictions.eq((String)"routeDest", (Object)routeDest));
        List objects = this.findMatching(criteria);
        if (objects != null && objects.size() > 0) {
            return (OnmsIpRouteInterface)objects.get(0);
        }
        return null;
    }
}

