/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.spring.FileReloadContainer;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.test.Level;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.dao.support.PropertiesGraphDao;
import org.opennms.netmgt.mock.MockResourceType;
import org.opennms.netmgt.model.AdhocGraphType;
import org.opennms.netmgt.model.ExternalValueAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.test.FileAnticipator;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.orm.ObjectRetrievalFailureException;

public class PropertiesGraphDaoTest {
    private static final Map<String, Resource> s_emptyMap = new HashMap<String, Resource>();
    static final String s_prefab = "command.prefix=foo\noutput.mime=foo\n\nreports=mib2.HCbits, mib2.bits, mib2.discards\n\nreport.mib2.HCbits.name=Bits In/Out\nreport.mib2.HCbits.columns=ifHCInOctets,ifHCOutOctets\nreport.mib2.HCbits.type=interface\nreport.mib2.HCbits.externalValues=ifSpeed\nreport.mib2.HCbits.suppress=mib2.bits\nreport.mib2.HCbits.command=--title=\"Bits In/Out (High Speed)\" \\\n DEF:octIn={rrd1}:ifHCInOctets:AVERAGE \\\n DEF:octOut={rrd2}:ifHCOutOctets:AVERAGE \\\n CDEF:bitsIn=octIn,8,* \\\n CDEF:bitsOut=octOut,8,* \\\n CDEF:totBits=octIn,octOut,+,8,* \\\n AREA:totBits#00ff00:\"Total\" \\\n GPRINT:totBits:AVERAGE:\" Avg  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:bitsIn#0000ff:\"Bits In\" \\\n GPRINT:bitsIn:AVERAGE:\" Avg  \\\\: %8.2lf %s\" \\\n GPRINT:bitsIn:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:bitsIn:MAX:\"Max  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:bitsOut#ff0000:\"Bits Out\" \\\n GPRINT:bitsOut:AVERAGE:\"Avg  \\\\: %8.2lf %s\" \\\n GPRINT:bitsOut:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:bitsOut:MAX:\"Max  \\\\: %8.2lf %s\\\\n\"\n\nreport.mib2.bits.name=Bits In/Out\nreport.mib2.bits.columns=ifInOctets,ifOutOctets\nreport.mib2.bits.type=interface\nreport.mib2.bits.externalValues=ifSpeed\nreport.mib2.bits.command=--title=\"Bits In/Out\" \\\n DEF:octIn={rrd1}:ifInOctets:AVERAGE \\\n DEF:octOut={rrd2}:ifOutOctets:AVERAGE \\\n CDEF:bitsIn=octIn,8,* \\\n CDEF:bitsOut=octOut,8,* \\\n CDEF:totBits=octIn,octOut,+,8,* \\\n AREA:totBits#00ff00:\"Total\" \\\n GPRINT:totBits:AVERAGE:\" Avg  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:bitsIn#0000ff:\"Bits In\" \\\n GPRINT:bitsIn:AVERAGE:\" Avg  \\\\: %8.2lf %s\" \\\n GPRINT:bitsIn:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:bitsIn:MAX:\"Max  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:bitsOut#ff0000:\"Bits Out\" \\\n GPRINT:bitsOut:AVERAGE:\"Avg  \\\\: %8.2lf %s\" \\\n GPRINT:bitsOut:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:bitsOut:MAX:\"Max  \\\\: %8.2lf %s\\\\n\"\n\nreport.mib2.discards.name=Discards In/Out\nreport.mib2.discards.columns=ifInDiscards,ifOutDiscards\nreport.mib2.discards.type=interface\nreport.mib2.discards.propertiesValues=ifSpeed\nreport.mib2.discards.command=--title=\"Discards In/Out\" \\\n DEF:octIn={rrd1}:ifInDiscards:AVERAGE \\\n DEF:octOut={rrd2}:ifOutDiscards:AVERAGE \\\n LINE2:octIn#0000ff:\"Discards In\" \\\n GPRINT:octIn:AVERAGE:\" Avg  \\\\: %8.2lf %s\" \\\n GPRINT:octIn:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:octIn:MAX:\"Max  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:octOut#ff0000:\"Discards Out\" \\\n GPRINT:octOut:AVERAGE:\"Avg  \\\\: %8.2lf %s\" \\\n GPRINT:octOut:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:octOut:MAX:\"Max  \\\\: %8.2lf %s\\\\n\"\n";
    private static final String s_adhoc = "command.prefix=${install.rrdtool.bin} graph - --imgformat PNG --start {1} --end {2}\noutput.mime=image/png\nadhoc.command.title=--title=\"{3}\"\nadhoc.command.ds=DEF:{4}={0}:{5}:{6}\nadhoc.command.graphline={7}:{4}#{8}:\"{9}\"\n";
    private static final String s_responsePrefab = "command.prefix=foo\noutput.mime=foo\n\nreports=icmp\n\nreport.icmp.name=ICMP\nreport.icmp.columns=icmp\nreport.icmp.type=responseTime\nreport.icmp.command=--title=\"ICMP Response Time\" \\\n  --vertical-label=\"Seconds\" \\\n  DEF:rtMicro={rrd1}:icmp:AVERAGE \\\n  CDEF:rt=rtMicro,1000000,/ \\\n  LINE1:rt#0000ff:\"Response Time\" \\\n  GPRINT:rt:AVERAGE:\" Avg  \\: %8.2lf %s\" \\\n  GPRINT:rt:MIN:\"Min  \\\\: %8.2lf %s\" \\\n  GPRINT:rt:MAX:\"Max  \\\\: %8.2lf %s\\\\n\"";
    private static final String s_baseIncludePrefab = "command.prefix=foo\noutput.mime=image/png\nreports=\ninclude.directory=snmp-graph.properties.d\ninclude.directory.rescan=1000\n";
    private static final String s_separateBitsGraph = "report.id=mib2.bits\nreport.name=Bits In/Out\nreport.columns=ifInOctets,ifOutOctets\nreport.type=interface\nreport.externalValues=ifSpeed\nreport.command=--title=\"Bits In/Out\"\n";
    private static final String s_separateHCBitsGraph = "report.id=mib2.HCbits\nreport.name=Bits In/Out\nreport.columns=ifHCInOctets,ifHCOutOctets\nreport.type=interface\nreport.externalValues=ifSpeed\nreport.suppress=mib2.bits\nreport.command=--title=\"Bits In/Out (High Speed)\"\n";
    private static final String s_separateErrorsGraph = "report.id=mib2.errors\nreport.name=Errors In/Out\nreport.columns=ifIfErrors,ifOutErrors\nreport.type=interface\nreport.propertiesValues=ifSpeed\nreport.command=--title=\"Erros In/Out\"\n";
    private static final String s_includedMultiGraph1 = "reports=mib2.discards,mib2.errors\nreport.mib2.discards.name=Discards In/Out\nreport.mib2.discards.columns=ifInDiscards,ifOutDiscards\nreport.mib2.discards.type=interface\nreport.mib2.discards.propertiesValues=ifSpeed\nreport.mib2.discards.command=--title=\"Discards In/Out\"\n\nreport.mib2.errors.name=Errors In/Out\nreport.mib2.errors.columns=ifInErrors,ifOutErrors\nreport.mib2.errors.type=interface\nreport.mib2.errors.propertiesValues=ifSpeed\nreport.mib2.errors.command=--title=\"Discards In/Out\"\n";
    private static final String s_includedMultiGraph2 = "reports=mib2.bits,mib2.HCbits\nreport.mib2.bits.name=Bits In/Out\nreport.mib2.bits.columns=ifInOctets,ifOutOctets\nreport.mib2.bits.type=interface\nreport.mib2.bits.externalValues=ifSpeed\nreport.mib2.bits.command=--title=\"Bits In/Out\"\n\nreport.mib2.HCbits.name=Bits In/Out\nreport.mib2.HCbits.columns=ifHCInOctets,ifHCOutOctets\nreport.mib2.HCbits.type=interface\nreport.mib2.HCbits.externalValues=ifSpeed\nreport.mib2.HCbits.suppress=mib2.bits\nreport.mib2.HCbits.command=--title=\"Bits In/Out (High Speed)\"\n";
    private static final String s_mib2bitsBasePrefab = "command.prefix=foo\noutput.mime=image/png\ninclude.directory=snmp-graph.properties.d\nreports=mib2.bits\nreport.mib2.bits.name=Wrong Name\nreport.mib2.bits.columns=wrongColumn1,wrongColumn2\nreport.mib2.bits.type=node\nreport.mib2.bits.externalValues=fooBar\nreport.mib2.bits.command=--title=\"Wrong Title\"\n";
    static final String s_partlyBorkedPrefab = "command.prefix=foo\noutput.mime=foo\n\nreports=mib2.HCbits, mib2.bits, mib2.discards\n\nreport.mib2.HCbits.name=Bits In/Out\nreport.mib2.HCbits.columns=ifHCInOctets,ifHCOutOctets\nreport.mib2.HCbits.type=interface\nreport.mib2.HCbits.externalValues=ifSpeed\nreport.mib2.HCbits.suppress=mib2.bits\nreport.mib2.HCbits.command=--title=\"Bits In/Out (High Speed)\" \n\nreport.mib2.bits.nmae=Bits In/Out\nreport.mib2.bits.columns=ifInOctets,ifOutOctets\nreport.mib2.bits.type=interface\nreport.mib2.bits.externalValues=ifSpeed\nreport.mib2.bits.command=--title=\"Bits In/Out\" \n\nreport.mib2.discards.name=Discards In/Out\nreport.mib2.discards.columns=ifInDiscards,ifOutDiscards\nreport.mib2.discards.type=interface\nreport.mib2.discards.propertiesValues=ifSpeed\nreport.mib2.discards.command=--title=\"Discards In/Out\" \n";
    private Map<String, FileReloadContainer<PrefabGraph>> m_graphs;
    private PropertiesGraphDao m_dao;
    private boolean testSpecificLoggingTest = false;
    private FileAnticipator m_fileAnticipator = null;
    private FileOutputStream m_outputStream = null;
    private Writer m_writer = null;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging((boolean)true);
        this.m_dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        ByteArrayInputStream in = new ByteArrayInputStream(s_prefab.getBytes());
        this.m_dao.loadProperties("performance", (InputStream)in);
        PropertiesGraphDao.PrefabGraphTypeDao type = this.m_dao.findPrefabGraphTypeDaoByName("performance");
        Assert.assertNotNull((String)"could not get performance prefab graph type", (Object)type);
        this.m_graphs = type.getReportMap();
        Assert.assertNotNull((String)"report map shouldn't be null", this.m_graphs);
        this.m_fileAnticipator = new FileAnticipator();
    }

    @After
    public void tearDown() throws Exception {
        IOUtils.closeQuietly((Writer)this.m_writer);
        IOUtils.closeQuietly((OutputStream)this.m_outputStream);
        this.m_writer = null;
        this.m_outputStream = null;
        System.gc();
        if (!this.testSpecificLoggingTest) {
            MockLogAppender.assertNoWarningsOrGreater();
        }
        this.m_fileAnticipator.deleteExpected();
        this.m_fileAnticipator.tearDown();
        MockLogAppender.resetEvents();
    }

    @Test
    public void testCompareToLessThan() {
        PrefabGraph bits = (PrefabGraph)this.m_graphs.get("mib2.bits").getObject();
        PrefabGraph discards = (PrefabGraph)this.m_graphs.get("mib2.discards").getObject();
        Assert.assertEquals((String)"compareTo", (long)-1L, (long)bits.compareTo(discards));
    }

    @Test
    public void testCompareToGreaterThan() {
        PrefabGraph bits = (PrefabGraph)this.m_graphs.get("mib2.bits").getObject();
        PrefabGraph discards = (PrefabGraph)this.m_graphs.get("mib2.discards").getObject();
        Assert.assertEquals((String)"compareTo", (long)1L, (long)discards.compareTo(bits));
    }

    @Test
    public void testCompareToEquals() {
        PrefabGraph bits = (PrefabGraph)this.m_graphs.get("mib2.bits").getObject();
        PrefabGraph bits2 = (PrefabGraph)this.m_graphs.get("mib2.bits").getObject();
        Assert.assertEquals((String)"compareTo", (long)0L, (long)bits.compareTo(bits2));
    }

    @Test
    public void testGetName() {
        PrefabGraph bits = (PrefabGraph)this.m_graphs.get("mib2.bits").getObject();
        Assert.assertEquals((String)"getName", (Object)"mib2.bits", (Object)bits.getName());
    }

    @Test
    public void testGetTitle() {
        PrefabGraph bits = (PrefabGraph)this.m_graphs.get("mib2.bits").getObject();
        Assert.assertEquals((String)"getTitle", (Object)"Bits In/Out", (Object)bits.getTitle());
    }

    @Test
    public void testGetOrder() {
        PrefabGraph bits = (PrefabGraph)this.m_graphs.get("mib2.HCbits").getObject();
        Assert.assertEquals((String)"getOrder", (long)0L, (long)bits.getOrder());
    }

    @Test
    public void testGetColumns() {
        PrefabGraph bits = (PrefabGraph)this.m_graphs.get("mib2.bits").getObject();
        String[] columns = bits.getColumns();
        Assert.assertEquals((String)"getColumns().length", (long)2L, (long)columns.length);
        Assert.assertEquals((String)"getColumns()[0]", (Object)"ifInOctets", (Object)columns[0]);
        Assert.assertEquals((String)"getColumns()[1]", (Object)"ifOutOctets", (Object)columns[1]);
    }

    @Test
    public void testGetCommand() {
        String expectedCommand = "--title=\"Bits In/Out\" DEF:octIn={rrd1}:ifInOctets:AVERAGE DEF:octOut={rrd2}:ifOutOctets:AVERAGE CDEF:bitsIn=octIn,8,* CDEF:bitsOut=octOut,8,* CDEF:totBits=octIn,octOut,+,8,* AREA:totBits#00ff00:\"Total\" GPRINT:totBits:AVERAGE:\" Avg  \\: %8.2lf %s\\n\" LINE2:bitsIn#0000ff:\"Bits In\" GPRINT:bitsIn:AVERAGE:\" Avg  \\: %8.2lf %s\" GPRINT:bitsIn:MIN:\"Min  \\: %8.2lf %s\" GPRINT:bitsIn:MAX:\"Max  \\: %8.2lf %s\\n\" LINE2:bitsOut#ff0000:\"Bits Out\" GPRINT:bitsOut:AVERAGE:\"Avg  \\: %8.2lf %s\" GPRINT:bitsOut:MIN:\"Min  \\: %8.2lf %s\" GPRINT:bitsOut:MAX:\"Max  \\: %8.2lf %s\\n\"";
        PrefabGraph bits = (PrefabGraph)this.m_graphs.get("mib2.bits").getObject();
        Assert.assertEquals((String)"getCommand", (Object)expectedCommand, (Object)bits.getCommand());
    }

    @Test
    public void testGetExternalValues() {
        PrefabGraph bits = (PrefabGraph)this.m_graphs.get("mib2.bits").getObject();
        String[] values = bits.getExternalValues();
        Assert.assertEquals((String)"getExternalValues().length", (long)1L, (long)values.length);
        Assert.assertEquals((String)"getExternalValues()[0]", (Object)"ifSpeed", (Object)values[0]);
    }

    @Test
    public void testGetExternalValuesEmpty() {
        PrefabGraph discards = (PrefabGraph)this.m_graphs.get("mib2.discards").getObject();
        Assert.assertEquals((String)"getExternalValues().length", (long)0L, (long)discards.getExternalValues().length);
    }

    @Test
    public void testGetPropertiesValues() {
        PrefabGraph discards = (PrefabGraph)this.m_graphs.get("mib2.discards").getObject();
        String[] values = discards.getPropertiesValues();
        Assert.assertEquals((String)"getPropertiesValues().length", (long)1L, (long)values.length);
        Assert.assertEquals((String)"getPropertiesValues()[0]", (Object)"ifSpeed", (Object)values[0]);
    }

    @Test
    public void testGetPropertiesValuesEmpty() {
        PrefabGraph bits = (PrefabGraph)this.m_graphs.get("mib2.bits").getObject();
        Assert.assertEquals((String)"getPropertiesValues().length", (long)0L, (long)bits.getPropertiesValues().length);
    }

    @Test
    public void testGetTypes() {
        PrefabGraph bits = (PrefabGraph)this.m_graphs.get("mib2.bits").getObject();
        Assert.assertNotNull((String)"getTypes", (Object)bits.getTypes());
        Assert.assertEquals((String)"getTypes count", (long)1L, (long)bits.getTypes().length);
        Assert.assertEquals((String)"getTypes 1", (Object)"interface", (Object)bits.getTypes()[0]);
    }

    @Test
    public void testGetDescription() {
        PrefabGraph bits = (PrefabGraph)this.m_graphs.get("mib2.bits").getObject();
        Assert.assertEquals((String)"getDescription", null, (Object)bits.getDescription());
    }

    @Test
    public void testLoadSnmpGraphProperties() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        dao.loadProperties("foo", (Resource)new FileSystemResource(ConfigurationTestUtils.getFileForConfigFile((String)"snmp-graph.properties")));
    }

    @Test
    public void testLoadSnmpAdhocGraphProperties() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        dao.loadAdhocProperties("foo", ConfigurationTestUtils.getInputStreamForConfigFile((String)"snmp-adhoc-graph.properties"));
    }

    @Test
    public void testLoadResponseTimeGraphProperties() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        dao.loadProperties("foo", ConfigurationTestUtils.getInputStreamForConfigFile((String)"response-graph.properties"));
    }

    @Test
    public void testLoadResponseTimeAdhocGraphProperties() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        dao.loadAdhocProperties("foo", ConfigurationTestUtils.getInputStreamForConfigFile((String)"response-adhoc-graph.properties"));
    }

    @Test
    public void testPrefabPropertiesReload() throws Exception {
        File f = this.m_fileAnticipator.tempFile("snmp-graph.properties");
        this.m_outputStream = new FileOutputStream(f);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        String noDiscards = s_prefab.replace(", mib2.discards", "");
        this.m_writer.write(noDiscards);
        this.m_writer.close();
        this.m_outputStream.close();
        HashMap<String, Resource> perfConfig = new HashMap<String, Resource>();
        perfConfig.put("performance", (Resource)new FileSystemResource(f));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(perfConfig, s_emptyMap);
        PropertiesGraphDao.PrefabGraphTypeDao type = dao.findPrefabGraphTypeDaoByName("performance");
        Assert.assertNotNull((String)"could not get performance prefab graph type", (Object)type);
        Assert.assertNotNull((String)"could not get mib2.bits report", (Object)type.getQuery("mib2.bits"));
        Assert.assertNull((String)"could get mib2.discards report, but shouldn't have been able to", (Object)type.getQuery("mib2.discards"));
        Thread.sleep(1100L);
        this.m_outputStream = new FileOutputStream(f);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_prefab);
        this.m_writer.close();
        this.m_outputStream.close();
        type = dao.findPrefabGraphTypeDaoByName("performance");
        Assert.assertNotNull((String)"could not get performance prefab graph type after rewriting config file", (Object)type);
        Assert.assertNotNull((String)"could not get mib2.bits report after rewriting config file", (Object)type.getQuery("mib2.bits"));
        Assert.assertNotNull((String)"could not get mib2.discards report after rewriting config file", (Object)type.getQuery("mib2.discards"));
    }

    @Test
    public void testPrefabPropertiesReloadBad() throws Exception {
        MockLogAppender.setupLogging((boolean)false, (String)"DEBUG");
        this.testSpecificLoggingTest = true;
        File f = this.m_fileAnticipator.tempFile("snmp-graph.properties");
        this.m_outputStream = new FileOutputStream(f);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_prefab);
        this.m_writer.close();
        this.m_outputStream.close();
        HashMap<String, Resource> perfConfig = new HashMap<String, Resource>();
        perfConfig.put("performance", (Resource)new FileSystemResource(f));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(perfConfig, s_emptyMap);
        PropertiesGraphDao.PrefabGraphTypeDao type = dao.findPrefabGraphTypeDaoByName("performance");
        Assert.assertNotNull((String)"could not get performance prefab graph type", (Object)type);
        Assert.assertNotNull((String)"could not get mib2.bits report", (Object)type.getQuery("mib2.bits"));
        Assert.assertNotNull((String)"could not get mib2.discards report", (Object)type.getQuery("mib2.discards"));
        Thread.sleep(1100L);
        this.m_outputStream = new FileOutputStream(f);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        String noReports = s_prefab.replace("reports=mib2.HCbits, mib2.bits, mib2.discards", "");
        this.m_writer.write(noReports);
        this.m_writer.close();
        this.m_outputStream.close();
        type = dao.findPrefabGraphTypeDaoByName("performance");
        Assert.assertNotNull((String)"could not get performance prefab graph type after rewriting config file", (Object)type);
        Assert.assertNotNull((String)"could not get mib2.bits report after rewriting config file", (Object)type.getQuery("mib2.bits"));
        Assert.assertNotNull((String)"could not get mib2.discards report after rewriting config file", (Object)type.getQuery("mib2.discards"));
        MockLogAppender.assertLogMatched((Level)Level.ERROR, (String)"Could not reload configuration");
    }

    @Test
    public void testAdhocPropertiesReload() throws Exception {
        File f = this.m_fileAnticipator.tempFile("snmp-adhoc-graph.properties");
        this.m_outputStream = new FileOutputStream(f);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        String cheesy = s_adhoc.replace("image/png", "image/cheesy");
        this.m_writer.write(cheesy);
        this.m_writer.close();
        this.m_outputStream.close();
        HashMap<String, Resource> adhocConfig = new HashMap<String, Resource>();
        adhocConfig.put("performance", (Resource)new FileSystemResource(f));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, adhocConfig);
        AdhocGraphType type = dao.findAdhocGraphTypeByName("performance");
        Assert.assertNotNull((String)"could not get performance adhoc graph type", (Object)type);
        Assert.assertEquals((String)"image type isn't correct", (Object)"image/cheesy", (Object)type.getOutputMimeType());
        Thread.sleep(1100L);
        this.m_outputStream = new FileOutputStream(f);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_adhoc);
        this.m_writer.close();
        this.m_outputStream.close();
        type = dao.findAdhocGraphTypeByName("performance");
        Assert.assertNotNull((String)"could not get performance adhoc graph type", (Object)type);
        Assert.assertEquals((String)"image type isn't correct", (Object)"image/png", (Object)type.getOutputMimeType());
    }

    @Test
    public void testNoType() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        String ourConfig = s_responsePrefab.replaceAll("report.icmp.type=responseTime", "");
        ByteArrayInputStream in = new ByteArrayInputStream(ourConfig.getBytes());
        dao.loadProperties("response", (InputStream)in);
        PropertiesGraphDao.PrefabGraphTypeDao type = dao.findPrefabGraphTypeDaoByName("response");
        Assert.assertNotNull((String)"could not get response prefab graph type", (Object)type);
        PrefabGraph graph = type.getQuery("icmp");
        Assert.assertNotNull((String)"could not get icmp response prefab graph type", (Object)graph);
        Assert.assertNotNull((String)"graph type list should not be null", (Object)graph.getTypes());
        Assert.assertEquals((String)"graph type was not specified the list should be empty", (long)0L, (long)graph.getTypes().length);
        Assert.assertFalse((String)"should not have responseTime type", (boolean)graph.hasMatchingType(new String[]{"responseTime"}));
    }

    @Test
    public void testOneType() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        ByteArrayInputStream in = new ByteArrayInputStream(s_responsePrefab.getBytes());
        dao.loadProperties("response", (InputStream)in);
        PropertiesGraphDao.PrefabGraphTypeDao type = dao.findPrefabGraphTypeDaoByName("response");
        Assert.assertNotNull((String)"could not get response prefab graph type", (Object)type);
        PrefabGraph graph = type.getQuery("icmp");
        Assert.assertNotNull((String)"could not get icmp response prefab graph type", (Object)graph);
        Assert.assertNotNull((String)"graph type list should not be null", (Object)graph.getTypes());
        Assert.assertEquals((String)"graph type was not specified the list should be empty", (long)1L, (long)graph.getTypes().length);
        Assert.assertEquals((String)"graph type 1", (Object)"responseTime", (Object)graph.getTypes()[0]);
        Assert.assertTrue((String)"should have responseTime type", (boolean)graph.hasMatchingType(new String[]{"responseTime"}));
        Assert.assertFalse((String)"should not have distributedStatus type", (boolean)graph.hasMatchingType(new String[]{"distributedStatus"}));
        Assert.assertTrue((String)"should have responseTime or distributedStatus type", (boolean)graph.hasMatchingType(new String[]{"responseTime", "distributedStatus"}));
    }

    @Test
    public void testTwoTypes() throws Exception {
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        String ourConfig = s_responsePrefab.replaceAll("report.icmp.type=responseTime", "report.icmp.type=responseTime, distributedStatus");
        ByteArrayInputStream in = new ByteArrayInputStream(ourConfig.getBytes());
        dao.loadProperties("response", (InputStream)in);
        PropertiesGraphDao.PrefabGraphTypeDao type = dao.findPrefabGraphTypeDaoByName("response");
        Assert.assertNotNull((String)"could not get response prefab graph type", (Object)type);
        PrefabGraph graph = type.getQuery("icmp");
        Assert.assertNotNull((String)"could not get icmp response prefab graph type", (Object)graph);
        Assert.assertNotNull((String)"graph type should not be null", (Object)graph.getTypes());
        Assert.assertEquals((String)"graph type count", (long)2L, (long)graph.getTypes().length);
        Assert.assertEquals((String)"graph type 1", (Object)"responseTime", (Object)graph.getTypes()[0]);
        Assert.assertEquals((String)"graph type 2", (Object)"distributedStatus", (Object)graph.getTypes()[1]);
        Assert.assertTrue((String)"should have responseTime type", (boolean)graph.hasMatchingType(new String[]{"responseTime"}));
        Assert.assertTrue((String)"should have distributedStatus type", (boolean)graph.hasMatchingType(new String[]{"distributedStatus"}));
    }

    @Test
    public void testGetPrefabGraphsForResource() {
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interface");
        HashSet<Object> attributes = new HashSet<Object>(0);
        attributes.add(new RrdGraphAttribute("ifInOctets", "", ""));
        attributes.add(new RrdGraphAttribute("ifOutOctets", "", ""));
        attributes.add(new ExternalValueAttribute("ifSpeed", ""));
        OnmsResource resource = new OnmsResource("node", "1", (OnmsResourceType)resourceType, attributes);
        PrefabGraph[] graphs = this.m_dao.getPrefabGraphsForResource(resource);
        Assert.assertEquals((String)"prefab graph array size", (long)1L, (long)graphs.length);
        Assert.assertEquals((String)"prefab graph[0] name", (Object)"mib2.bits", (Object)graphs[0].getName());
    }

    @Test
    public void testGetPrefabGraphsForResourceWithSuppress() {
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interface");
        HashSet<Object> attributes = new HashSet<Object>(0);
        attributes.add(new RrdGraphAttribute("ifInOctets", "", ""));
        attributes.add(new RrdGraphAttribute("ifOutOctets", "", ""));
        attributes.add(new RrdGraphAttribute("ifHCInOctets", "", ""));
        attributes.add(new RrdGraphAttribute("ifHCOutOctets", "", ""));
        attributes.add(new ExternalValueAttribute("ifSpeed", ""));
        OnmsResource resource = new OnmsResource("node", "1", (OnmsResourceType)resourceType, attributes);
        PrefabGraph[] graphs = this.m_dao.getPrefabGraphsForResource(resource);
        Assert.assertEquals((String)"prefab graph array size", (long)1L, (long)graphs.length);
        Assert.assertEquals((String)"prefab graph[0] name", (Object)"mib2.HCbits", (Object)graphs[0].getName());
    }

    @Test
    public void testGetPrefabGraphsForResourceWithSuppressUnused() {
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interface");
        HashSet<Object> attributes = new HashSet<Object>(0);
        attributes.add(new RrdGraphAttribute("ifHCInOctets", "", ""));
        attributes.add(new RrdGraphAttribute("ifHCOutOctets", "", ""));
        attributes.add(new ExternalValueAttribute("ifSpeed", ""));
        OnmsResource resource = new OnmsResource("node", "1", (OnmsResourceType)resourceType, attributes);
        PrefabGraph[] graphs = this.m_dao.getPrefabGraphsForResource(resource);
        Assert.assertEquals((String)"prefab graph array size", (long)1L, (long)graphs.length);
        Assert.assertEquals((String)"prefab graph[0] name", (Object)"mib2.HCbits", (Object)graphs[0].getName());
    }

    public PropertiesGraphDao createPropertiesGraphDao(Map<String, Resource> prefabConfigs, Map<String, Resource> adhocConfigs) throws IOException {
        PropertiesGraphDao dao = new PropertiesGraphDao();
        dao.setPrefabConfigs(prefabConfigs);
        dao.setAdhocConfigs(adhocConfigs);
        dao.afterPropertiesSet();
        return dao;
    }

    @Test
    public void testBasicPrefabConfigDirectorySingleReports() throws IOException {
        File rootFile = this.m_fileAnticipator.tempFile("snmp-graph.properties");
        File graphDirectory = this.m_fileAnticipator.tempDir("snmp-graph.properties.d");
        File graphBits = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.bits.properties");
        File graphHCbits = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.HCbits.properties");
        this.m_outputStream = new FileOutputStream(rootFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_baseIncludePrefab);
        this.m_writer.close();
        this.m_outputStream.close();
        graphDirectory.mkdir();
        this.m_outputStream = new FileOutputStream(graphBits);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateBitsGraph);
        this.m_writer.close();
        this.m_outputStream.close();
        this.m_outputStream = new FileOutputStream(graphHCbits);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateHCBitsGraph);
        this.m_writer.close();
        this.m_outputStream.close();
        HashMap<String, Resource> prefabConfigs = new HashMap<String, Resource>();
        prefabConfigs.put("performance", (Resource)new FileSystemResource(rootFile));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(prefabConfigs, s_emptyMap);
        PrefabGraph mib2Bits = dao.getPrefabGraph("mib2.bits");
        Assert.assertNotNull((Object)mib2Bits);
        Assert.assertEquals((Object)"mib2.bits", (Object)mib2Bits.getName());
        Assert.assertEquals((Object)"Bits In/Out", (Object)mib2Bits.getTitle());
        Object[] columns1 = new String[]{"ifInOctets", "ifOutOctets"};
        Assert.assertArrayEquals((Object[])columns1, (Object[])mib2Bits.getColumns());
        PrefabGraph mib2HCBits = dao.getPrefabGraph("mib2.HCbits");
        Assert.assertNotNull((Object)mib2HCBits);
        Assert.assertEquals((Object)"mib2.HCbits", (Object)mib2HCBits.getName());
        Assert.assertEquals((Object)"Bits In/Out", (Object)mib2HCBits.getTitle());
        Object[] columns2 = new String[]{"ifHCInOctets", "ifHCOutOctets"};
        Assert.assertArrayEquals((Object[])columns2, (Object[])mib2HCBits.getColumns());
    }

    @Test
    public void testPrefabConfigDirectoryMultiReports() throws IOException {
        File rootFile = this.m_fileAnticipator.tempFile("snmp-graph.properties");
        File graphDirectory = this.m_fileAnticipator.tempDir("snmp-graph.properties.d");
        File multiFile1 = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.bits1.properties");
        File multiFile2 = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.bits2.properties");
        this.m_outputStream = new FileOutputStream(rootFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_baseIncludePrefab);
        this.m_writer.close();
        this.m_outputStream.close();
        graphDirectory.mkdir();
        this.m_outputStream = new FileOutputStream(multiFile1);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_includedMultiGraph1);
        this.m_writer.close();
        this.m_outputStream.close();
        this.m_outputStream = new FileOutputStream(multiFile2);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_includedMultiGraph2);
        this.m_writer.close();
        this.m_outputStream.close();
        HashMap<String, Resource> prefabConfigs = new HashMap<String, Resource>();
        prefabConfigs.put("performance", (Resource)new FileSystemResource(rootFile));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(prefabConfigs, s_emptyMap);
        PrefabGraph mib2Bits = dao.getPrefabGraph("mib2.bits");
        Assert.assertNotNull((Object)mib2Bits);
        Assert.assertEquals((Object)"mib2.bits", (Object)mib2Bits.getName());
        Assert.assertEquals((Object)"Bits In/Out", (Object)mib2Bits.getTitle());
        Object[] columns1 = new String[]{"ifInOctets", "ifOutOctets"};
        Assert.assertArrayEquals((Object[])columns1, (Object[])mib2Bits.getColumns());
        PrefabGraph mib2HCBits = dao.getPrefabGraph("mib2.HCbits");
        Assert.assertNotNull((Object)mib2HCBits);
        Assert.assertEquals((Object)"mib2.HCbits", (Object)mib2HCBits.getName());
        Assert.assertEquals((Object)"Bits In/Out", (Object)mib2HCBits.getTitle());
        Object[] columns2 = new String[]{"ifHCInOctets", "ifHCOutOctets"};
        Assert.assertArrayEquals((Object[])columns2, (Object[])mib2HCBits.getColumns());
        PrefabGraph mib2Discards = dao.getPrefabGraph("mib2.discards");
        Assert.assertNotNull((Object)mib2Discards);
        Assert.assertEquals((Object)"mib2.discards", (Object)mib2Discards.getName());
        Assert.assertEquals((Object)"Discards In/Out", (Object)mib2Discards.getTitle());
        Object[] columns3 = new String[]{"ifInDiscards", "ifOutDiscards"};
        Assert.assertArrayEquals((Object[])columns3, (Object[])mib2Discards.getColumns());
        PrefabGraph mib2Errors = dao.getPrefabGraph("mib2.errors");
        Assert.assertNotNull((Object)mib2Errors);
        Assert.assertEquals((Object)"mib2.errors", (Object)mib2Errors.getName());
        Assert.assertEquals((Object)"Errors In/Out", (Object)mib2Errors.getTitle());
        Object[] columns4 = new String[]{"ifInErrors", "ifOutErrors"};
        Assert.assertArrayEquals((Object[])columns4, (Object[])mib2Errors.getColumns());
    }

    @Test
    public void testPrefabConfigDirectoryMixedSingleAndMultiReports() throws IOException {
        File rootFile = this.m_fileAnticipator.tempFile("snmp-graph.properties");
        File graphDirectory = this.m_fileAnticipator.tempDir("snmp-graph.properties.d");
        File multiFile = this.m_fileAnticipator.tempFile(graphDirectory, "mib2-1.properties");
        File graphBits = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.bits.properties");
        File graphHCbits = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.HCbits.properties");
        this.m_outputStream = new FileOutputStream(rootFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_baseIncludePrefab);
        this.m_writer.close();
        this.m_outputStream.close();
        graphDirectory.mkdir();
        this.m_outputStream = new FileOutputStream(graphBits);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateBitsGraph);
        this.m_writer.close();
        this.m_outputStream.close();
        this.m_outputStream = new FileOutputStream(graphHCbits);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateHCBitsGraph);
        this.m_writer.close();
        this.m_outputStream.close();
        graphDirectory.mkdir();
        this.m_outputStream = new FileOutputStream(multiFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_includedMultiGraph1);
        this.m_writer.close();
        this.m_outputStream.close();
        HashMap<String, Resource> prefabConfigs = new HashMap<String, Resource>();
        prefabConfigs.put("performance", (Resource)new FileSystemResource(rootFile));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(prefabConfigs, s_emptyMap);
        PrefabGraph mib2Bits = dao.getPrefabGraph("mib2.bits");
        Assert.assertNotNull((Object)mib2Bits);
        Assert.assertEquals((Object)"mib2.bits", (Object)mib2Bits.getName());
        Assert.assertEquals((Object)"Bits In/Out", (Object)mib2Bits.getTitle());
        Object[] columns1 = new String[]{"ifInOctets", "ifOutOctets"};
        Assert.assertArrayEquals((Object[])columns1, (Object[])mib2Bits.getColumns());
        PrefabGraph mib2HCBits = dao.getPrefabGraph("mib2.HCbits");
        Assert.assertNotNull((Object)mib2HCBits);
        Assert.assertEquals((Object)"mib2.HCbits", (Object)mib2HCBits.getName());
        Assert.assertEquals((Object)"Bits In/Out", (Object)mib2HCBits.getTitle());
        Object[] columns2 = new String[]{"ifHCInOctets", "ifHCOutOctets"};
        Assert.assertArrayEquals((Object[])columns2, (Object[])mib2HCBits.getColumns());
        PrefabGraph mib2Discards = dao.getPrefabGraph("mib2.discards");
        Assert.assertNotNull((Object)mib2Discards);
        Assert.assertEquals((Object)"mib2.discards", (Object)mib2Discards.getName());
        Assert.assertEquals((Object)"Discards In/Out", (Object)mib2Discards.getTitle());
        Object[] columns3 = new String[]{"ifInDiscards", "ifOutDiscards"};
        Assert.assertArrayEquals((Object[])columns3, (Object[])mib2Discards.getColumns());
        PrefabGraph mib2Errors = dao.getPrefabGraph("mib2.errors");
        Assert.assertNotNull((Object)mib2Errors);
        Assert.assertEquals((Object)"mib2.errors", (Object)mib2Errors.getName());
        Assert.assertEquals((Object)"Errors In/Out", (Object)mib2Errors.getTitle());
        Object[] columns4 = new String[]{"ifInErrors", "ifOutErrors"};
        Assert.assertArrayEquals((Object[])columns4, (Object[])mib2Errors.getColumns());
    }

    @Test
    public void testPrefabConfigDirectorySingleReportOverride() throws Exception {
        File rootFile = this.m_fileAnticipator.tempFile("snmp-graph.properties");
        File graphDirectory = this.m_fileAnticipator.tempDir("snmp-graph.properties.d");
        File graphBits = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.bits.properties");
        File graphHCbits = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.HCbits.properties");
        this.m_outputStream = new FileOutputStream(rootFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_mib2bitsBasePrefab);
        this.m_writer.close();
        this.m_outputStream.close();
        graphDirectory.mkdir();
        this.m_outputStream = new FileOutputStream(graphBits);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateBitsGraph);
        this.m_writer.close();
        this.m_outputStream.close();
        this.m_outputStream = new FileOutputStream(graphHCbits);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateHCBitsGraph);
        this.m_writer.close();
        this.m_outputStream.close();
        HashMap<String, Resource> prefabConfigs = new HashMap<String, Resource>();
        prefabConfigs.put("performance", (Resource)new FileSystemResource(rootFile));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(prefabConfigs, s_emptyMap);
        PrefabGraph mib2Bits = dao.getPrefabGraph("mib2.bits");
        Assert.assertNotNull((Object)mib2Bits);
        Assert.assertEquals((Object)"mib2.bits", (Object)mib2Bits.getName());
        Assert.assertEquals((Object)"Bits In/Out", (Object)mib2Bits.getTitle());
        Object[] columns1 = new String[]{"ifInOctets", "ifOutOctets"};
        Assert.assertArrayEquals((Object[])columns1, (Object[])mib2Bits.getColumns());
        PrefabGraph mib2HCBits = dao.getPrefabGraph("mib2.HCbits");
        Assert.assertNotNull((Object)mib2HCBits);
        Assert.assertEquals((Object)"mib2.HCbits", (Object)mib2HCBits.getName());
        Assert.assertEquals((Object)"Bits In/Out", (Object)mib2HCBits.getTitle());
        Object[] columns2 = new String[]{"ifHCInOctets", "ifHCOutOctets"};
        Assert.assertArrayEquals((Object[])columns2, (Object[])mib2HCBits.getColumns());
        this.m_outputStream = new FileOutputStream(rootFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_mib2bitsBasePrefab);
        this.m_writer.close();
        this.m_outputStream.close();
        Thread.sleep(1100L);
        mib2Bits = dao.getPrefabGraph("mib2.bits");
        Assert.assertNotNull((Object)mib2Bits);
        Assert.assertEquals((Object)"mib2.bits", (Object)mib2Bits.getName());
        Assert.assertEquals((Object)"Bits In/Out", (Object)mib2Bits.getTitle());
        Object[] columns3 = new String[]{"ifInOctets", "ifOutOctets"};
        Assert.assertArrayEquals((Object[])columns3, (Object[])mib2Bits.getColumns());
    }

    @Test
    public void testPrefabPropertiesIncludeDirectoryReloadSingleReports() throws Exception {
        File rootFile = this.m_fileAnticipator.tempFile("snmp-graph.properties");
        File graphDirectory = this.m_fileAnticipator.tempDir("snmp-graph.properties.d");
        File graphBits = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.bits.properties");
        this.m_outputStream = new FileOutputStream(rootFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_baseIncludePrefab);
        this.m_writer.close();
        this.m_outputStream.close();
        graphDirectory.mkdir();
        this.m_outputStream = new FileOutputStream(graphBits);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateBitsGraph);
        this.m_writer.close();
        this.m_outputStream.close();
        HashMap<String, Resource> perfConfig = new HashMap<String, Resource>();
        perfConfig.put("performance", (Resource)new FileSystemResource(rootFile));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(perfConfig, s_emptyMap);
        PrefabGraph graph = dao.getPrefabGraph("mib2.bits");
        Assert.assertNotNull((String)"could not get mib2.bits report", (Object)graph);
        Assert.assertEquals((Object)"ifSpeed", (Object)graph.getExternalValues()[0]);
        Thread.sleep(1100L);
        this.m_outputStream = new FileOutputStream(graphBits);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateBitsGraph.replace("ifSpeed", "anotherExternalValue"));
        this.m_writer.close();
        this.m_outputStream.close();
        graph = dao.getPrefabGraph("mib2.bits");
        Assert.assertNotNull((String)"could not get mib2.bits report after rewriting config file", (Object)graph);
        Assert.assertEquals((Object)"anotherExternalValue", (Object)graph.getExternalValues()[0]);
    }

    @Test
    public void testPrefabPropertiesIncludeDirectoryBadReloadSingleReport() throws Exception {
        this.testSpecificLoggingTest = true;
        File rootFile = this.m_fileAnticipator.tempFile("snmp-graph.properties");
        File graphDirectory = this.m_fileAnticipator.tempDir("snmp-graph.properties.d");
        File graphBits = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.bits.properties");
        this.m_outputStream = new FileOutputStream(rootFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_baseIncludePrefab);
        this.m_writer.close();
        this.m_outputStream.close();
        graphDirectory.mkdir();
        this.m_outputStream = new FileOutputStream(graphBits);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateBitsGraph);
        this.m_writer.close();
        this.m_outputStream.close();
        HashMap<String, Resource> perfConfig = new HashMap<String, Resource>();
        perfConfig.put("performance", (Resource)new FileSystemResource(rootFile));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(perfConfig, s_emptyMap);
        PrefabGraph graph = dao.getPrefabGraph("mib2.bits");
        Assert.assertNotNull((String)"could not get mib2.bits report", (Object)graph);
        Assert.assertEquals((Object)"ifSpeed", (Object)graph.getExternalValues()[0]);
        Thread.sleep(1100L);
        this.m_outputStream = new FileOutputStream(graphBits);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateBitsGraph.replace("report.name", "report.fluggle").replace("ifSpeed", "anotherExternalValue"));
        this.m_writer.close();
        this.m_outputStream.close();
        graph = dao.getPrefabGraph("mib2.bits");
        Assert.assertNotNull((String)"could not get mib2.bits report after rewriting config file", (Object)graph);
        Assert.assertEquals((Object)"ifSpeed", (Object)graph.getExternalValues()[0]);
    }

    @Test
    public void testPrefabGraphPartlyBorkedConfig() throws Exception {
        this.testSpecificLoggingTest = true;
        PropertiesGraphDao dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        dao.loadProperties("foo", (InputStream)new ByteArrayInputStream(s_partlyBorkedPrefab.getBytes("UTF-8")));
        try {
            PrefabGraph mib2bits = dao.getPrefabGraph("mib2.bits");
            Assert.fail((String)("Should have thrown an ObjectRetrievalFailureException retrieving graph " + mib2bits));
        }
        catch (ObjectRetrievalFailureException e) {
            // empty catch block
        }
        PrefabGraph mib2HCbits = dao.getPrefabGraph("mib2.HCbits");
        Assert.assertNotNull((Object)mib2HCbits);
        PrefabGraph mib2Discards = dao.getPrefabGraph("mib2.discards");
        Assert.assertNotNull((Object)mib2Discards);
    }

    @Test
    public void testAddingIncludeDirectory() throws Exception {
        File rootFile = this.m_fileAnticipator.tempFile("snmp-graph.properties");
        this.m_outputStream = new FileOutputStream(rootFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_prefab);
        this.m_writer.close();
        this.m_outputStream.close();
        HashMap<String, Resource> perfConfig = new HashMap<String, Resource>();
        perfConfig.put("performance", (Resource)new FileSystemResource(rootFile));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(perfConfig, s_emptyMap);
        Assert.assertNotNull((Object)dao.getPrefabGraph("mib2.bits"));
        try {
            PrefabGraph mib2errors = dao.getPrefabGraph("mib2.errors");
            Assert.fail((String)("Should have thrown an ObjectRetrievalFailureException retrieving graph " + mib2errors));
        }
        catch (ObjectRetrievalFailureException e) {
            // empty catch block
        }
        Thread.sleep(1100L);
        File graphDirectory = this.m_fileAnticipator.tempDir("snmp-graph.properties.d");
        File graphErrors = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.errors.properties");
        graphDirectory.mkdir();
        this.m_outputStream = new FileOutputStream(graphErrors);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateErrorsGraph);
        this.m_writer.close();
        this.m_outputStream.close();
        this.m_outputStream = new FileOutputStream(rootFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_prefab.replace("output.mime", "include.directory=snmp-graph.properties.d\noutput.mime"));
        this.m_writer.close();
        this.m_outputStream.close();
        Assert.assertNotNull((Object)dao.getPrefabGraph("mib2.bits"));
        Assert.assertNotNull((Object)dao.getPrefabGraph("mib2.errors"));
    }

    @Test
    public void testIncludeDirectoryNewFile() throws Exception {
        File rootFile = this.m_fileAnticipator.tempFile("snmp-graph.properties");
        this.m_outputStream = new FileOutputStream(rootFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_baseIncludePrefab);
        this.m_writer.close();
        this.m_outputStream.close();
        File graphDirectory = this.m_fileAnticipator.tempDir("snmp-graph.properties.d");
        graphDirectory.mkdir();
        HashMap<String, Resource> perfConfig = new HashMap<String, Resource>();
        perfConfig.put("performance", (Resource)new FileSystemResource(rootFile));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(perfConfig, s_emptyMap);
        try {
            PrefabGraph mib2errors = dao.getPrefabGraph("mib2.errors");
            Assert.fail((String)("Should have thrown an ObjectRetrievalFailureException retrieving graph " + mib2errors));
        }
        catch (ObjectRetrievalFailureException e) {
            // empty catch block
        }
        File graphErrors = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.errors.properties");
        this.m_outputStream = new FileOutputStream(graphErrors);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateErrorsGraph);
        this.m_writer.close();
        this.m_outputStream.close();
        Thread.sleep(1100L);
        Assert.assertNotNull((Object)dao.getPrefabGraph("mib2.errors"));
    }

    @Test
    public void testIncludeDirectoryIncludeMissingReportId() throws Exception {
        this.testSpecificLoggingTest = true;
        File rootFile = this.m_fileAnticipator.tempFile("snmp-graph.properties");
        File graphDirectory = this.m_fileAnticipator.tempDir("snmp-graph.properties.d");
        File graphBits = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.bits.properties");
        this.m_outputStream = new FileOutputStream(rootFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_baseIncludePrefab);
        this.m_writer.close();
        this.m_outputStream.close();
        graphDirectory.mkdir();
        this.m_outputStream = new FileOutputStream(graphBits);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateBitsGraph.replace("report.id", "report.noid"));
        this.m_writer.close();
        this.m_outputStream.close();
        HashMap<String, Resource> perfConfig = new HashMap<String, Resource>();
        perfConfig.put("performance", (Resource)new FileSystemResource(rootFile));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(perfConfig, s_emptyMap);
        try {
            PrefabGraph graph = dao.getPrefabGraph("mib2.bits");
            Assert.fail((String)("Shouldn't have gotten here; expecting an exception fetching " + graph));
        }
        catch (ObjectRetrievalFailureException e) {
            // empty catch block
        }
    }

    @Test
    public void testIncludeNewFileMalformedContentThenFixed() throws Exception {
        this.testSpecificLoggingTest = true;
        File rootFile = this.m_fileAnticipator.tempFile("snmp-graph.properties");
        this.m_outputStream = new FileOutputStream(rootFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_baseIncludePrefab);
        this.m_writer.close();
        this.m_outputStream.close();
        File graphDirectory = this.m_fileAnticipator.tempDir("snmp-graph.properties.d");
        graphDirectory.mkdir();
        HashMap<String, Resource> perfConfig = new HashMap<String, Resource>();
        perfConfig.put("performance", (Resource)new FileSystemResource(rootFile));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(perfConfig, s_emptyMap);
        try {
            PrefabGraph mib2errors = dao.getPrefabGraph("mib2.errors");
            Assert.fail((String)("Should have thrown an ObjectRetrievalFailureException retrieving graph " + mib2errors));
        }
        catch (ObjectRetrievalFailureException e) {
            // empty catch block
        }
        File graphErrors = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.errors.properties");
        this.m_outputStream = new FileOutputStream(graphErrors);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateErrorsGraph.replace("report.id", "report.noid"));
        this.m_writer.close();
        this.m_outputStream.close();
        Thread.sleep(1100L);
        try {
            PrefabGraph mib2errors = dao.getPrefabGraph("mib2.errors");
            Assert.fail((String)("Should have thrown an ObjectRetrievalFailureException retrieving graph " + mib2errors));
        }
        catch (ObjectRetrievalFailureException e) {
            // empty catch block
        }
        dao.findPrefabGraphTypeByName("performance").setIncludeDirectoryRescanInterval(300000);
        this.m_outputStream = new FileOutputStream(graphErrors);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_separateErrorsGraph);
        this.m_writer.close();
        this.m_outputStream.close();
        Thread.sleep(1100L);
        try {
            Assert.assertNotNull((Object)dao.getPrefabGraph("mib2.errors"));
        }
        catch (Exception e) {
            Assert.fail((String)"Should not have gotten an exception fetching the graph");
        }
    }

    @Test
    public void testPrefabConfigDirectoryPartlyBorkedMultiReports() throws Exception {
        this.testSpecificLoggingTest = true;
        File rootFile = this.m_fileAnticipator.tempFile("snmp-graph.properties");
        File graphDirectory = this.m_fileAnticipator.tempDir("snmp-graph.properties.d");
        File multiFile1 = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.bits1.properties");
        File multiFile2 = this.m_fileAnticipator.tempFile(graphDirectory, "mib2.bits2.properties");
        this.m_outputStream = new FileOutputStream(rootFile);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_baseIncludePrefab);
        this.m_writer.close();
        this.m_outputStream.close();
        graphDirectory.mkdir();
        this.m_outputStream = new FileOutputStream(multiFile1);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_includedMultiGraph1.replace("report.mib2.errors.name", "report.mib2.errors.nmae"));
        this.m_writer.close();
        this.m_outputStream.close();
        this.m_outputStream = new FileOutputStream(multiFile2);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_includedMultiGraph2);
        this.m_writer.close();
        this.m_outputStream.close();
        HashMap<String, Resource> prefabConfigs = new HashMap<String, Resource>();
        prefabConfigs.put("performance", (Resource)new FileSystemResource(rootFile));
        PropertiesGraphDao dao = this.createPropertiesGraphDao(prefabConfigs, s_emptyMap);
        PrefabGraph mib2Bits = dao.getPrefabGraph("mib2.bits");
        Assert.assertNotNull((Object)mib2Bits);
        Assert.assertEquals((Object)"mib2.bits", (Object)mib2Bits.getName());
        Assert.assertEquals((Object)"Bits In/Out", (Object)mib2Bits.getTitle());
        Object[] columns1 = new String[]{"ifInOctets", "ifOutOctets"};
        Assert.assertArrayEquals((Object[])columns1, (Object[])mib2Bits.getColumns());
        PrefabGraph mib2HCBits = dao.getPrefabGraph("mib2.HCbits");
        Assert.assertNotNull((Object)mib2HCBits);
        Assert.assertEquals((Object)"mib2.HCbits", (Object)mib2HCBits.getName());
        Assert.assertEquals((Object)"Bits In/Out", (Object)mib2HCBits.getTitle());
        Object[] columns2 = new String[]{"ifHCInOctets", "ifHCOutOctets"};
        Assert.assertArrayEquals((Object[])columns2, (Object[])mib2HCBits.getColumns());
        PrefabGraph mib2Discards = dao.getPrefabGraph("mib2.discards");
        Assert.assertNotNull((Object)mib2Discards);
        Assert.assertEquals((Object)"mib2.discards", (Object)mib2Discards.getName());
        Assert.assertEquals((Object)"Discards In/Out", (Object)mib2Discards.getTitle());
        Object[] columns3 = new String[]{"ifInDiscards", "ifOutDiscards"};
        Assert.assertArrayEquals((Object[])columns3, (Object[])mib2Discards.getColumns());
        try {
            PrefabGraph mib2Errors = dao.getPrefabGraph("mib2.errors");
            Assert.fail((String)("Should have thrown an ObjectRetrievalFailureException retrieving graph " + mib2Errors));
        }
        catch (ObjectRetrievalFailureException e) {
            // empty catch block
        }
        dao.findPrefabGraphTypeByName("performance").setIncludeDirectoryRescanInterval(300000);
        Thread.sleep(1100L);
        this.m_outputStream = new FileOutputStream(multiFile1);
        this.m_writer = new OutputStreamWriter((OutputStream)this.m_outputStream, "UTF-8");
        this.m_writer.write(s_includedMultiGraph1);
        this.m_writer.close();
        this.m_outputStream.close();
        try {
            Assert.assertNotNull((Object)dao.getPrefabGraph("mib2.errors"));
        }
        catch (Exception e) {
            Assert.fail((String)"Should not have gotten an exception fetching the graph");
        }
    }
}

