/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.dao.support.DefaultRrdDao;
import org.opennms.netmgt.mock.MockResourceType;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.rrd.DefaultRrdGraphDetails;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.StringUtils;

public class DefaultRrdDaoTest
extends TestCase {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private RrdStrategy<?, ?> m_rrdStrategy = (RrdStrategy)this.m_mocks.createMock(RrdStrategy.class);
    private DefaultRrdDao m_dao;

    public void setUp() throws Exception {
        super.setUp();
        RrdUtils.setStrategy((RrdStrategy)new JRobinRrdStrategy());
        this.m_dao = new DefaultRrdDao();
        this.m_dao.setRrdStrategy(this.m_rrdStrategy);
        this.m_dao.setRrdBaseDirectory(new File(System.getProperty("java.io.tmpdir")));
        this.m_dao.setRrdBinaryPath("/bin/true");
        this.m_dao.afterPropertiesSet();
    }

    public void testInit() {
    }

    public void testPrintValue() throws Exception {
        long end = System.currentTimeMillis();
        long start = end - 86400000L;
        OnmsResource childResource = this.preparePrintValueTest(start, end, "1");
        this.m_mocks.replayAll();
        Double value = this.m_dao.getPrintValue((OnmsAttribute)childResource.getAttributes().iterator().next(), "AVERAGE", start, end);
        this.m_mocks.verifyAll();
        DefaultRrdDaoTest.assertNotNull((String)"value should not be null", (Object)value);
        DefaultRrdDaoTest.assertEquals((String)"value", (Object)1.0, (Object)value);
    }

    public void testPrintValueWithNaN() throws Exception {
        long end = System.currentTimeMillis();
        long start = end - 86400000L;
        OnmsResource childResource = this.preparePrintValueTest(start, end, "NaN");
        this.m_mocks.replayAll();
        Double value = this.m_dao.getPrintValue((OnmsAttribute)childResource.getAttributes().iterator().next(), "AVERAGE", start, end);
        this.m_mocks.verifyAll();
        DefaultRrdDaoTest.assertNotNull((String)"value should not be null", (Object)value);
        DefaultRrdDaoTest.assertEquals((String)"value", (Object)Double.NaN, (Object)value);
    }

    public void testPrintValueWithnan() throws Exception {
        long end = System.currentTimeMillis();
        long start = end - 86400000L;
        OnmsResource childResource = this.preparePrintValueTest(start, end, "nan");
        this.m_mocks.replayAll();
        Double value = this.m_dao.getPrintValue((OnmsAttribute)childResource.getAttributes().iterator().next(), "AVERAGE", start, end);
        this.m_mocks.verifyAll();
        DefaultRrdDaoTest.assertNotNull((String)"value should not be null", (Object)value);
        DefaultRrdDaoTest.assertEquals((String)"value", (Object)Double.NaN, (Object)value);
    }

    public void testPrintValueWithNegativeNan() throws Exception {
        long end = System.currentTimeMillis();
        long start = end - 86400000L;
        OnmsResource childResource = this.preparePrintValueTest(start, end, "-nan");
        this.m_mocks.replayAll();
        Double value = this.m_dao.getPrintValue((OnmsAttribute)childResource.getAttributes().iterator().next(), "AVERAGE", start, end);
        this.m_mocks.verifyAll();
        DefaultRrdDaoTest.assertNotNull((String)"value should not be null", (Object)value);
        DefaultRrdDaoTest.assertEquals((String)"value", (Object)Double.NaN, (Object)value);
    }

    public void testPrintValueWithBogusLine() throws Exception {
        long end = System.currentTimeMillis();
        long start = end - 86400000L;
        String printLine = "blah blah blah this should be a floating point number blah blah blah";
        OnmsResource childResource = this.preparePrintValueTest(start, end, printLine);
        this.m_mocks.replayAll();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new DataAccessResourceFailureException("Value of line 1 of output from RRD is not a valid floating point number: '" + printLine + "'"));
        try {
            this.m_dao.getPrintValue((OnmsAttribute)childResource.getAttributes().iterator().next(), "AVERAGE", start, end);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        this.m_mocks.verifyAll();
        ta.verifyAnticipated();
    }

    private OnmsResource preparePrintValueTest(long start, long end, String printLine) throws IOException, RrdException {
        String rrdDir = "snmp" + File.separator + "1" + File.separator + "eth0";
        String rrdFile = "ifInOctets.jrb";
        String escapedFile = rrdDir + File.separator + rrdFile;
        if (File.separatorChar == '\\') {
            escapedFile = escapedFile.replace("\\", "\\\\");
        }
        Object[] command = new String[]{this.m_dao.getRrdBinaryPath(), "graph", "-", "--start=" + start / 1000L, "--end=" + end / 1000L, "DEF:ds=" + escapedFile + ":ifInOctets:AVERAGE", "PRINT:ds:AVERAGE:\"%le\""};
        String commandString = StringUtils.arrayToDelimitedString((Object[])command, (String)" ");
        OnmsResource topResource = new OnmsResource("1", "Node One", (OnmsResourceType)new MockResourceType(), new HashSet(0));
        RrdGraphAttribute attribute = new RrdGraphAttribute("ifInOctets", rrdDir, rrdFile);
        HashSet<RrdGraphAttribute> attributeSet = new HashSet<RrdGraphAttribute>(1);
        attributeSet.add(attribute);
        MockResourceType childResourceType = new MockResourceType();
        OnmsResource childResource = new OnmsResource("eth0", "Interface One: eth0", (OnmsResourceType)childResourceType, attributeSet);
        childResource.setParent(topResource);
        DefaultRrdGraphDetails details = new DefaultRrdGraphDetails();
        details.setPrintLines(new String[]{printLine});
        EasyMock.expect((Object)this.m_rrdStrategy.createGraphReturnDetails(commandString, this.m_dao.getRrdBaseDirectory())).andReturn((Object)details);
        return childResource;
    }

    public void testFetchLastValue() throws Exception {
        String rrdDir = "snmp" + File.separator + "1" + File.separator + "eth0";
        String rrdFile = "ifInOctets.jrb";
        OnmsResource topResource = new OnmsResource("1", "Node One", (OnmsResourceType)new MockResourceType(), new HashSet(0));
        RrdGraphAttribute attribute = new RrdGraphAttribute("ifInOctets", rrdDir, rrdFile);
        HashSet<RrdGraphAttribute> attributeSet = new HashSet<RrdGraphAttribute>(1);
        attributeSet.add(attribute);
        MockResourceType childResourceType = new MockResourceType();
        OnmsResource childResource = new OnmsResource("eth0", "Interface One: eth0", (OnmsResourceType)childResourceType, attributeSet);
        childResource.setParent(topResource);
        int interval = 300000;
        Double expectedValue = new Double(1.0);
        String fullRrdFilePath = this.m_dao.getRrdBaseDirectory().getAbsolutePath() + File.separator + rrdDir + File.separator + rrdFile;
        EasyMock.expect((Object)this.m_rrdStrategy.fetchLastValue(fullRrdFilePath, attribute.getName(), interval)).andReturn((Object)expectedValue);
        this.m_mocks.replayAll();
        Double value = this.m_dao.getLastFetchValue((OnmsAttribute)attribute, interval);
        this.m_mocks.verifyAll();
        DefaultRrdDaoTest.assertNotNull((String)"last fetched value must not be null, but was null", (Object)value);
        DefaultRrdDaoTest.assertEquals((String)"last fetched value", (Object)expectedValue, (Object)value);
    }

    public void testFetchLastValueInRange() throws Exception {
        String rrdDir = "snmp" + File.separator + "1" + File.separator + "eth0";
        String rrdFile = "ifInOctets.jrb";
        OnmsResource topResource = new OnmsResource("1", "Node One", (OnmsResourceType)new MockResourceType(), new HashSet(0));
        RrdGraphAttribute attribute = new RrdGraphAttribute("ifInOctets", rrdDir, rrdFile);
        HashSet<RrdGraphAttribute> attributeSet = new HashSet<RrdGraphAttribute>(1);
        attributeSet.add(attribute);
        MockResourceType childResourceType = new MockResourceType();
        OnmsResource childResource = new OnmsResource("eth0", "Interface One: eth0", (OnmsResourceType)childResourceType, attributeSet);
        childResource.setParent(topResource);
        int interval = 300000;
        int range = 300000;
        Double expectedValue = new Double(1.0);
        String fullRrdFilePath = this.m_dao.getRrdBaseDirectory().getAbsolutePath() + File.separator + rrdDir + File.separator + rrdFile;
        EasyMock.expect((Object)this.m_rrdStrategy.fetchLastValueInRange(fullRrdFilePath, attribute.getName(), interval, range)).andReturn((Object)expectedValue);
        this.m_mocks.replayAll();
        Double value = this.m_dao.getLastFetchValue((OnmsAttribute)attribute, interval, range);
        this.m_mocks.verifyAll();
        DefaultRrdDaoTest.assertNotNull((String)"last fetched value must not be null, but was null", (Object)value);
        DefaultRrdDaoTest.assertEquals((String)"last fetched value", (Object)expectedValue, (Object)value);
    }
}

