/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.api.ReportCatalogDao;
import org.opennms.netmgt.model.ReportCatalogEntry;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class ReportCatalogDaoHibernateTest
implements InitializingBean {
    @Autowired
    private ReportCatalogDao m_reportCatalogDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Test
    @Transactional
    public void testSave() {
        Date date = new Date();
        ReportCatalogEntry catalogEntry = new ReportCatalogEntry();
        catalogEntry.setReportId("reportId_1");
        catalogEntry.setLocation("location_1");
        catalogEntry.setTitle("title_1");
        catalogEntry.setDate(date);
        this.m_reportCatalogDao.save((Object)catalogEntry);
        Integer id = catalogEntry.getId();
        ReportCatalogEntry retrievedEntry = (ReportCatalogEntry)this.m_reportCatalogDao.get((Serializable)id);
        Assert.assertEquals((Object)catalogEntry.getReportId(), (Object)retrievedEntry.getReportId());
        Assert.assertEquals((Object)catalogEntry.getTitle(), (Object)retrievedEntry.getTitle());
        Assert.assertEquals((Object)catalogEntry.getLocation(), (Object)retrievedEntry.getLocation());
        Assert.assertEquals((long)0L, (long)catalogEntry.getDate().compareTo(retrievedEntry.getDate()));
    }

    @Test
    @Transactional
    public void testDelete() {
        Date date = new Date();
        ReportCatalogEntry catalogEntry = new ReportCatalogEntry();
        catalogEntry.setReportId("reportId_2");
        catalogEntry.setLocation("location_2");
        catalogEntry.setTitle("title_2");
        catalogEntry.setDate(date);
        this.m_reportCatalogDao.save((Object)catalogEntry);
        Integer id = catalogEntry.getId();
        Assert.assertNotNull((Object)this.m_reportCatalogDao.get((Serializable)id));
        this.m_reportCatalogDao.delete(id);
        Assert.assertNull((Object)this.m_reportCatalogDao.get((Serializable)id));
    }
}

