/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.StpNodeDao;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsStpNode;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class OnmsStpNodeDaoHibernateTest
implements InitializingBean {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private StpNodeDao m_stpNodeDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
        this.m_databasePopulator.populateDatabase();
    }

    @Test
    public void testSaveOnmsStpNode() {
        OnmsStpNode stpnode = new OnmsStpNode(this.m_databasePopulator.getNode2(), Integer.valueOf(1));
        stpnode.setBaseBridgeAddress("0a0112345678");
        stpnode.setBaseNumPorts(Integer.valueOf(20));
        stpnode.setBaseType(OnmsStpNode.BridgeBaseType.TRANSPARENT_ONLY);
        stpnode.setBaseVlanName("default");
        stpnode.setLastPollTime(new Date());
        stpnode.setStatus(OnmsArpInterface.StatusType.ACTIVE);
        stpnode.setStpDesignatedRoot("80000a0112345670");
        stpnode.setStpPriority(Integer.valueOf(28532));
        stpnode.setStpProtocolSpecification(OnmsStpNode.StpProtocolSpecification.IEEE8021D);
        stpnode.setStpRootCost(Integer.valueOf(128));
        stpnode.setStpRootPort(Integer.valueOf(15));
        this.m_stpNodeDao.save((Object)stpnode);
        Assert.assertEquals((long)1L, (long)this.m_stpNodeDao.countAll());
        OnmsStpNode dbStpNode = this.m_stpNodeDao.findByNodeAndVlan(this.m_databasePopulator.getNode2().getId(), Integer.valueOf(1));
        Assert.assertEquals((Object)stpnode.getBaseBridgeAddress(), (Object)dbStpNode.getBaseBridgeAddress());
        Assert.assertEquals((Object)"transparent-only", (Object)OnmsStpNode.BridgeBaseType.getBridgeBaseTypeString((Integer)dbStpNode.getBaseType().getIntCode()));
        Assert.assertEquals((Object)"ieee8021d", (Object)OnmsStpNode.StpProtocolSpecification.getStpProtocolSpecificationString((Integer)dbStpNode.getStpProtocolSpecification().getIntCode()));
    }
}

