/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.AtInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsAtInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class OnmsAtInterfaceDaoHibernateTest
implements InitializingBean {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private AtInterfaceDao m_atInterfaceDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
        this.m_databasePopulator.populateDatabase();
    }

    @Test
    public void testSaveAtInterface() {
        OnmsAtInterface atinterface = new OnmsAtInterface(this.m_databasePopulator.getNode6(), this.m_databasePopulator.getNode6().getPrimaryInterface().getIpAddress(), "0080aa12aa12");
        atinterface.setSourceNodeId(this.m_databasePopulator.getNode1().getId());
        atinterface.setIfIndex(Integer.valueOf(1));
        atinterface.setLastPollTime(new Date());
        atinterface.setStatus(OnmsArpInterface.StatusType.ACTIVE);
        this.m_atInterfaceDao.save((Object)atinterface);
        this.m_atInterfaceDao.flush();
        Assert.assertEquals((long)2L, (long)this.m_atInterfaceDao.countAll());
    }

    @Test
    public void testFindByNodeAndAddress() throws UnknownHostException {
        OnmsAtInterface atinterface = this.m_atInterfaceDao.findByNodeAndAddress(this.m_databasePopulator.getNode2().getId(), InetAddress.getByName("192.168.2.1"), "AA:BB:CC:DD:EE:FF");
        this.checkAtInterface(atinterface);
        OnmsAtInterface atinterface2 = this.m_atInterfaceDao.findByNodeAndAddress(this.m_databasePopulator.getNode6().getId(), InetAddress.getByName("192.168.2.1"), "AA:BB:CC:DD:EE:FF");
        Assert.assertEquals((Object)true, (Object)(atinterface2 == null ? 1 : 0));
    }

    @Test
    public void testGetAtInterfaceForAddress() throws UnknownHostException {
        Collection atinterfaces = this.m_atInterfaceDao.getAtInterfaceForAddress(InetAddress.getByName("192.168.2.1"));
        Assert.assertEquals((long)1L, (long)atinterfaces.size());
        Assert.assertEquals((long)1L, (long)this.m_atInterfaceDao.countAll());
        OnmsAtInterface atinterface = (OnmsAtInterface)atinterfaces.iterator().next();
        this.checkAtInterface(atinterface);
        atinterfaces = this.m_atInterfaceDao.getAtInterfaceForAddress(InetAddress.getByName("192.168.3.1"));
        Assert.assertEquals((long)1L, (long)atinterfaces.size());
        Assert.assertEquals((long)1L, (long)this.m_atInterfaceDao.countAll());
        OnmsAtInterface atinterface2 = (OnmsAtInterface)atinterfaces.iterator().next();
        Assert.assertEquals((Object)"192.168.3.1", (Object)atinterface2.getIpAddress().getHostAddress());
        Assert.assertEquals((Object)this.m_databasePopulator.getNode3().getId(), (Object)atinterface2.getNode().getId());
        Assert.assertEquals((Object)"", (Object)atinterface2.getMacAddress());
        atinterface2.setSourceNodeId(this.m_databasePopulator.getNode1().getId());
        atinterface2.setIfIndex(Integer.valueOf(1));
        atinterface2.setMacAddress("0080aa11aa11");
        atinterface2.setLastPollTime(new Date());
        atinterface2.setStatus(OnmsArpInterface.StatusType.ACTIVE);
        this.m_atInterfaceDao.saveOrUpdate((Object)atinterface2);
        atinterfaces = this.m_atInterfaceDao.getAtInterfaceForAddress(InetAddress.getByName("192.168.3.1"));
        Assert.assertEquals((long)1L, (long)atinterfaces.size());
        Assert.assertEquals((long)2L, (long)this.m_atInterfaceDao.countAll());
        OnmsAtInterface atinterface3 = (OnmsAtInterface)atinterfaces.iterator().next();
        Assert.assertEquals((Object)"192.168.3.1", (Object)atinterface3.getIpAddress().getHostAddress());
        Assert.assertEquals((Object)this.m_databasePopulator.getNode3().getId(), (Object)atinterface3.getNode().getId());
        Assert.assertEquals((Object)"0080aa11aa11", (Object)atinterface3.getMacAddress());
        atinterfaces = this.m_atInterfaceDao.getAtInterfaceForAddress(InetAddress.getByName("192.168.168.1"));
        Assert.assertEquals((long)0L, (long)atinterfaces.size());
    }

    private void checkAtInterface(OnmsAtInterface atinterface) {
        Assert.assertEquals((Object)true, (Object)(atinterface != null ? 1 : 0));
        Assert.assertEquals((Object)"192.168.2.1", (Object)atinterface.getIpAddress().getHostAddress());
        Assert.assertEquals((long)1L, (long)atinterface.getIfIndex().intValue());
        Assert.assertEquals((Object)this.m_databasePopulator.getNode1().getId(), (Object)atinterface.getSourceNodeId());
        Assert.assertEquals((Object)this.m_databasePopulator.getNode2().getId(), (Object)atinterface.getNode().getId());
        Assert.assertEquals((Object)"AA:BB:CC:DD:EE:FF", (Object)atinterface.getMacAddress());
        Assert.assertEquals((Object)OnmsArpInterface.StatusType.ACTIVE, (Object)atinterface.getStatus());
    }
}

