/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class DataLinkInterfaceDaoHibernateTest
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DataLinkInterfaceDaoHibernateTest.class);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
        this.m_databasePopulator.populateDatabase();
    }

    @Test
    @JUnitTemporaryDatabase
    public void testFindById() throws Exception {
        int id = 64;
        DataLinkInterface dli = this.m_dataLinkInterfaceDao.findById(Integer.valueOf(id));
        if (dli == null) {
            List dlis = this.m_dataLinkInterfaceDao.findAll();
            StringBuffer ids = new StringBuffer();
            for (DataLinkInterface current : dlis) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(current.getId());
            }
            Assert.fail((String)("No DataLinkInterface record with ID " + id + " was found, the only IDs are: " + ids.toString()));
        }
        Assert.assertNotNull((Object)dli);
        Assert.assertEquals((Object)this.m_databasePopulator.getNode1().getId(), (Object)dli.getNode().getId());
        Assert.assertEquals((Object)1, (Object)dli.getIfIndex());
        Assert.assertEquals((Object)dli.getSource(), (Object)"linkd");
    }

    @Test
    public void testFindByCriteria() throws Exception {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"node.id", (Object)this.m_databasePopulator.getNode1().getId()), (Criterion)Restrictions.eq((String)"nodeParentId", (Object)this.m_databasePopulator.getNode1().getId())));
        List dlis = this.m_dataLinkInterfaceDao.findMatching(criteria);
        for (DataLinkInterface iface : dlis) {
            LOG.debug("dli = {}", (Object)iface);
        }
        Assert.assertEquals((long)3L, (long)dlis.size());
    }

    @Test
    public void testFindByStatus() throws Exception {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)OnmsArpInterface.StatusType.ACTIVE));
        List dlis = this.m_dataLinkInterfaceDao.findMatching(criteria);
        for (DataLinkInterface iface : dlis) {
            LOG.debug("dli = {}", (Object)iface);
        }
        Assert.assertEquals((long)3L, (long)dlis.size());
    }

    @Test
    @Transactional
    public void testFindByNodeIdAndifIndex() {
        Collection dlfindbynodeidifindex = this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(this.m_databasePopulator.getNode2().getId(), Integer.valueOf(1));
        Assert.assertEquals((long)1L, (long)dlfindbynodeidifindex.size());
        for (DataLinkInterface link : dlfindbynodeidifindex) {
            Assert.assertEquals((Object)this.m_databasePopulator.getNode2().getId(), (Object)link.getNodeId());
            Assert.assertEquals((long)1L, (long)link.getIfIndex().intValue());
        }
        Collection node1ifindex1 = this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(this.m_databasePopulator.getNode1().getId(), Integer.valueOf(2));
        Assert.assertEquals((long)1L, (long)node1ifindex1.size());
        for (DataLinkInterface link : node1ifindex1) {
            Assert.assertEquals((Object)this.m_databasePopulator.getNode1().getId(), (Object)link.getNodeId());
            Assert.assertEquals((long)2L, (long)link.getIfIndex().intValue());
        }
        Collection node1ifindex1parent = this.m_dataLinkInterfaceDao.findByParentNodeIdAndIfIndex(this.m_databasePopulator.getNode1().getId(), Integer.valueOf(1));
        Assert.assertEquals((long)3L, (long)node1ifindex1parent.size());
        for (DataLinkInterface link : node1ifindex1parent) {
            Assert.assertEquals((Object)this.m_databasePopulator.getNode1().getId(), (Object)link.getNodeParentId());
            Assert.assertEquals((long)1L, (long)link.getParentIfIndex().intValue());
        }
    }

    @Test
    @Transactional
    public void testSaveDataLinkInterface() {
        DataLinkInterface dli = new DataLinkInterface(this.m_databasePopulator.getNode2(), 2, this.m_databasePopulator.getNode1().getId().intValue(), 1, OnmsArpInterface.StatusType.UNKNOWN, new Date());
        dli.setLinkTypeId(Integer.valueOf(101));
        dli.setProtocol(DataLinkInterface.DiscoveryProtocol.NA);
        this.m_dataLinkInterfaceDao.save((Object)dli);
        this.m_dataLinkInterfaceDao.flush();
        Assert.assertNotNull((Object)this.m_dataLinkInterfaceDao.get((Serializable)dli.getId()));
        DataLinkInterface dli2 = this.m_dataLinkInterfaceDao.findById(dli.getId());
        Assert.assertSame((Object)dli, (Object)dli2);
        Assert.assertEquals((Object)dli.getId(), (Object)dli2.getId());
        Assert.assertEquals((Object)dli.getNode().getId(), (Object)dli2.getNode().getId());
        Assert.assertEquals((Object)dli.getIfIndex(), (Object)dli2.getIfIndex());
        Assert.assertEquals((Object)dli.getNodeParentId(), (Object)dli2.getNodeParentId());
        Assert.assertEquals((Object)dli.getParentIfIndex(), (Object)dli2.getParentIfIndex());
        Assert.assertEquals((Object)dli.getStatus(), (Object)dli2.getStatus());
        Assert.assertEquals((Object)dli.getLinkTypeId(), (Object)dli2.getLinkTypeId());
        Assert.assertEquals((Object)dli.getLastPollTime(), (Object)dli2.getLastPollTime());
        Assert.assertEquals((Object)dli.getProtocol(), (Object)dli2.getProtocol());
        Assert.assertEquals((Object)dli.getSource(), (Object)"linkd");
    }

    @Test
    @Transactional
    public void testSaveDataLinkInterface2() {
        DataLinkInterface dli = new DataLinkInterface(this.m_databasePopulator.getNode3(), -1, this.m_databasePopulator.getNode1().getId().intValue(), 3, OnmsArpInterface.StatusType.UNKNOWN, new Date());
        dli.setLinkTypeId(Integer.valueOf(101));
        dli.setSource("rest");
        this.m_dataLinkInterfaceDao.save((Object)dli);
        this.m_dataLinkInterfaceDao.flush();
        Assert.assertNotNull((Object)this.m_dataLinkInterfaceDao.get((Serializable)dli.getId()));
        DataLinkInterface dli2 = this.m_dataLinkInterfaceDao.findById(dli.getId());
        Assert.assertSame((Object)dli, (Object)dli2);
        Assert.assertEquals((Object)dli.getId(), (Object)dli2.getId());
        Assert.assertEquals((Object)dli.getNode().getId(), (Object)dli2.getNode().getId());
        Assert.assertEquals((Object)dli.getIfIndex(), (Object)dli2.getIfIndex());
        Assert.assertEquals((Object)dli.getNodeParentId(), (Object)dli2.getNodeParentId());
        Assert.assertEquals((Object)dli.getParentIfIndex(), (Object)dli2.getParentIfIndex());
        Assert.assertEquals((Object)dli.getStatus(), (Object)dli2.getStatus());
        Assert.assertEquals((Object)dli.getLinkTypeId(), (Object)dli2.getLinkTypeId());
        Assert.assertEquals((Object)dli.getLastPollTime(), (Object)dli2.getLastPollTime());
        Assert.assertNull((Object)dli2.getProtocol());
        Assert.assertEquals((Object)dli.getSource(), (Object)"rest");
    }

    @Test
    @Transactional
    public void testUpdate() {
        DataLinkInterface dli = new DataLinkInterface(this.m_databasePopulator.getNode4(), -1, this.m_databasePopulator.getNode1().getId().intValue(), 3, OnmsArpInterface.StatusType.UNKNOWN, new Date());
        dli.setLinkTypeId(Integer.valueOf(101));
        dli.setSource("updatetest");
        this.m_dataLinkInterfaceDao.save((Object)dli);
        this.m_dataLinkInterfaceDao.flush();
        this.m_dataLinkInterfaceDao.setStatusForNode(this.m_databasePopulator.getNode4().getId(), "updatetest", OnmsArpInterface.StatusType.DELETED);
        Assert.assertNotNull((Object)this.m_dataLinkInterfaceDao.get((Serializable)dli.getId()));
        DataLinkInterface dli2 = this.m_dataLinkInterfaceDao.findById(dli.getId());
        Assert.assertSame((Object)dli, (Object)dli2);
        Assert.assertEquals((Object)dli.getId(), (Object)dli2.getId());
        Assert.assertEquals((Object)dli.getNode().getId(), (Object)dli2.getNode().getId());
        Assert.assertEquals((Object)dli.getIfIndex(), (Object)dli2.getIfIndex());
        Assert.assertEquals((Object)dli.getNodeParentId(), (Object)dli2.getNodeParentId());
        Assert.assertEquals((Object)dli.getParentIfIndex(), (Object)dli2.getParentIfIndex());
        Assert.assertEquals((Object)OnmsArpInterface.StatusType.DELETED, (Object)dli2.getStatus());
        Assert.assertEquals((Object)dli.getLinkTypeId(), (Object)dli2.getLinkTypeId());
        Assert.assertEquals((Object)dli.getLastPollTime(), (Object)dli2.getLastPollTime());
        Assert.assertEquals((Object)dli.getSource(), (Object)"updatetest");
    }
}

