/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OnmsUserNotification;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class AnnotationTest
implements InitializingBean {
    @Autowired
    private SessionFactory m_sessionFactory;
    @Autowired
    private DatabasePopulator m_databasePopulator;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_databasePopulator.populateDatabase();
    }

    @Test
    @Transactional
    public void testDistPoller() {
        this.assertLoadAll(OnmsDistPoller.class, new EmptyChecker<OnmsDistPoller>(){

            @Override
            public void check(OnmsDistPoller entity) {
                Assert.assertNotNull((String)"name not should be null", (Object)entity.getName());
            }
        });
    }

    @Test
    @Transactional
    public void testAssetRecord() {
        this.assertLoadAll(OnmsAssetRecord.class, new EmptyChecker<OnmsAssetRecord>(){

            @Override
            public void check(OnmsAssetRecord entity) {
                Assert.assertNotNull((String)"node should not be null", (Object)entity.getNode());
                Assert.assertNotNull((String)"node label should not be null", (Object)entity.getNode().getLabel());
            }
        });
    }

    @Test
    @Transactional
    public void testNode() {
        this.assertLoadAll(OnmsNode.class, new EmptyChecker<OnmsNode>(){

            @Override
            public void check(OnmsNode entity) {
                Assert.assertNotNull((String)"asset record should not be null", (Object)entity.getAssetRecord());
                Assert.assertNotNull((String)"asset record ID should not be null", (Object)entity.getAssetRecord().getId());
                Assert.assertNotNull((String)"dist poller should not be null", (Object)entity.getDistPoller());
                Assert.assertNotNull((String)"dist poller name should not be null", (Object)entity.getDistPoller().getName());
                Assert.assertNotNull((String)"categories list should not be null", (Object)entity.getCategories());
                entity.getCategories().size();
                Assert.assertNotNull((String)"ip interfaces list should not be null", (Object)entity.getIpInterfaces());
                Assert.assertTrue((String)"ip interfaces list size should be greater than zero", (entity.getIpInterfaces().size() > 0 ? 1 : 0) != 0);
                Assert.assertNotNull((String)"snmp interfaces list should not be null", (Object)entity.getSnmpInterfaces());
                Assert.assertTrue((String)"snmp interfaces list should be greater than or equal to zero", (entity.getSnmpInterfaces().size() >= 0 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    @Transactional
    public void testIpInterfaces() {
        this.assertLoadAll(OnmsIpInterface.class, new EmptyChecker<OnmsIpInterface>(){

            @Override
            public void check(OnmsIpInterface entity) {
                Assert.assertNotNull((String)"ip address should not be null", (Object)entity.getIpAddress());
                Assert.assertNotNull((String)"node should not be null", (Object)entity.getNode());
                Assert.assertNotNull((String)"node label should not be null", (Object)entity.getNode().getLabel());
                Assert.assertNotNull((String)"monitored services list should not be null", (Object)entity.getMonitoredServices());
                Assert.assertTrue((String)"number of monitored services should be greater than or equal to zero", (entity.getMonitoredServices().size() >= 0 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    @Transactional
    public void testSnmpInterfaces() {
        this.assertLoadAll(OnmsSnmpInterface.class, new EmptyChecker<OnmsSnmpInterface>(){

            @Override
            public void check(OnmsSnmpInterface entity) {
                Assert.assertNotNull((String)"ifindex should not be null", (Object)entity.getIfIndex());
                Assert.assertNotNull((String)"node should not be null", (Object)entity.getNode());
                Assert.assertNotNull((String)"node label should not be null", (Object)entity.getNode().getLabel());
                Assert.assertNotNull((String)"collect should not by null", (Object)entity.getCollect());
                Assert.assertNotNull((String)"ip interfaces list should not be null", (Object)entity.getIpInterfaces());
                Assert.assertTrue((String)"ip interfaces list size should be greater than 0", (entity.getIpInterfaces().size() > 0 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    @Transactional
    public void testCategories() {
        this.assertLoadAll(OnmsCategory.class, new EmptyChecker<OnmsCategory>(){

            @Override
            public void check(OnmsCategory entity) {
                Assert.assertNotNull((String)"name should not be null", (Object)entity.getName());
            }
        });
    }

    @Test
    @Transactional
    public void testMonitoredServices() {
        this.assertLoadAll(OnmsMonitoredService.class, new EmptyChecker<OnmsMonitoredService>(){

            @Override
            public void check(OnmsMonitoredService entity) {
                Assert.assertNotNull((String)"ip interface should be null", (Object)entity.getIpInterface());
                Assert.assertNotNull((String)"ip address should not be null", (Object)entity.getIpAddress());
                Assert.assertNotNull((String)"node ID should not be null", (Object)entity.getNodeId());
                Assert.assertNotNull((String)"current outages list should not be null", (Object)entity.getCurrentOutages());
                Assert.assertTrue((String)"current outage count should be greater than or equal to zero", (entity.getCurrentOutages().size() >= 0 ? 1 : 0) != 0);
                Assert.assertNotNull((String)"service type should not be null", (Object)entity.getServiceType());
                Assert.assertNotNull((String)"service name should not be null", (Object)entity.getServiceName());
            }
        });
    }

    @Test
    @Transactional
    public void testServiceTypes() {
        this.assertLoadAll(OnmsServiceType.class, new EmptyChecker<OnmsServiceType>(){

            @Override
            public void check(OnmsServiceType entity) {
                Assert.assertNotNull((String)"id should not be null", (Object)entity.getId());
                Assert.assertNotNull((String)"name should not be null", (Object)entity.getName());
            }
        });
    }

    @Test
    @Transactional
    public void testOutages() {
        this.assertLoadAll(OnmsOutage.class, new EmptyChecker<OnmsOutage>(){

            @Override
            public void check(OnmsOutage entity) {
                Assert.assertNotNull((String)"monitored service should not be null", (Object)entity.getMonitoredService());
                Assert.assertNotNull((String)"ip address should not be null", (Object)entity.getIpAddress());
                Assert.assertNotNull((String)"node ID should not be null", (Object)entity.getNodeId());
                Assert.assertNotNull((String)"service lost event should not be null", (Object)entity.getServiceLostEvent());
                Assert.assertNotNull((String)"service lost event UEI should not be null", (Object)entity.getServiceLostEvent().getEventUei());
                if (entity.getIfRegainedService() != null) {
                    Assert.assertNotNull((String)"outage has ended (ifregainedservice) so service regained event should not be null", (Object)entity.getServiceRegainedEvent());
                    Assert.assertNotNull((String)"outage has ended (ifregainedservice) so service regained event UEI should not be null", (Object)entity.getServiceRegainedEvent().getEventUei());
                }
            }
        });
    }

    @Test
    @Transactional
    public void testEvents() {
        this.assertLoadAll(OnmsEvent.class, new EmptyChecker<OnmsEvent>(){

            @Override
            public void check(OnmsEvent entity) {
                if (entity.getAlarm() != null) {
                    Assert.assertEquals((String)"event UEI should equal the alarm UEI", (Object)entity.getEventUei(), (Object)entity.getAlarm().getUei());
                }
                Assert.assertNotNull((String)"associated service lost outages list should not be null", (Object)entity.getAssociatedServiceLostOutages());
                Assert.assertTrue((String)"there should be zero or more associated service lost outages", (entity.getAssociatedServiceLostOutages().size() >= 0 ? 1 : 0) != 0);
                Assert.assertNotNull((String)"associated service regained outages list should not be null", (Object)entity.getAssociatedServiceRegainedOutages());
                Assert.assertTrue((String)"there should be zero or more associated service regained outages", (entity.getAssociatedServiceRegainedOutages().size() >= 0 ? 1 : 0) != 0);
                Assert.assertNotNull((String)"dist poller should not be null", (Object)entity.getDistPoller());
                Assert.assertNotNull((String)"dist poller name should not be null", (Object)entity.getDistPoller().getName());
                Assert.assertNotNull((String)"notifications list should not be null", (Object)entity.getNotifications());
                Assert.assertTrue((String)"notifications list size should be greater than or equal to zero", (entity.getNotifications().size() >= 0 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    @Transactional
    public void testAlarms() {
        this.assertLoadAll(OnmsAlarm.class, new EmptyChecker<OnmsAlarm>(){

            @Override
            public void check(OnmsAlarm entity) {
                Assert.assertNotNull((String)"last event should not be null", (Object)entity.getLastEvent());
                Assert.assertEquals((String)"alarm UEI should match the last event UEI", (Object)entity.getUei(), (Object)entity.getLastEvent().getEventUei());
                Assert.assertNotNull((String)"dist poller should not be null", (Object)entity.getDistPoller());
                Assert.assertNotNull((String)"dist poller name should not be null", (Object)entity.getDistPoller().getName());
            }
        });
    }

    @Test
    @Transactional
    public void testNotifacations() {
        this.assertLoadAll(OnmsNotification.class, new NullChecker());
    }

    @Test
    @Transactional
    public void testUsersNotified() {
        this.assertLoadAll(OnmsUserNotification.class, new NullChecker());
    }

    private <T> void assertLoadAll(Class<T> annotatedClass, Checker<T> checker) {
        block0: {
            HibernateTemplate template = new HibernateTemplate(this.m_sessionFactory);
            List results = template.loadAll(annotatedClass);
            Assert.assertNotNull((Object)results);
            checker.checkCollection(results);
            Iterator i$ = results.iterator();
            if (!i$.hasNext()) break block0;
            Object t = i$.next();
            checker.check(t);
        }
    }

    public abstract class EmptyChecker<T>
    implements Checker<T> {
        @Override
        public void checkCollection(Collection<T> collection) {
            Assert.assertFalse((String)"collection should not be empty", (boolean)collection.isEmpty());
        }
    }

    public class NullChecker<T>
    implements Checker<T> {
        @Override
        public void check(T entity) {
        }

        @Override
        public void checkCollection(Collection<T> collection) {
        }
    }

    public static interface Checker<T> {
        public void checkCollection(Collection<T> var1);

        public void check(T var1);
    }
}

