/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.beanutils.BeanUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PathElement;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.AfterTransaction;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class NodeDaoTest
implements InitializingBean {
    @Autowired
    DistPollerDao m_distPollerDao;
    @Autowired
    NodeDao m_nodeDao;
    @Autowired
    JdbcTemplate m_jdbcTemplate;
    @Autowired
    DatabasePopulator m_populator;
    @Autowired
    TransactionTemplate m_transTemplate;

    public void afterPropertiesSet() throws Exception {
        org.opennms.core.spring.BeanUtils.assertAutowiring((Object)this);
    }

    @BeforeTransaction
    public void setUp() {
        this.m_populator.populateDatabase();
    }

    @AfterTransaction
    public void tearDown() {
        this.m_populator.resetDatabase();
    }

    public OnmsNode getNode1() {
        return this.m_populator.getNode1();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.m_jdbcTemplate;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public DistPollerDao getDistPollerDao() {
        return this.m_distPollerDao;
    }

    @Test
    @Transactional
    public void testSave() {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().get((Serializable)((Object)"localhost"));
        OnmsNode node = new OnmsNode(distPoller);
        node.setLabel("MyFirstNode");
        this.getNodeDao().save((Object)node);
        this.getNodeDao().flush();
    }

    @Test
    @Transactional
    public void testSaveWithPathElement() {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().get((Serializable)((Object)"localhost"));
        OnmsNode node = new OnmsNode(distPoller);
        node.setLabel("MyFirstNode");
        PathElement p = new PathElement("192.168.7.7", "ICMP");
        node.setPathElement(p);
        this.getNodeDao().save((Object)node);
        this.getNodeDao().flush();
    }

    @Test
    @Transactional
    public void testSaveWithNullPathElement() {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().get((Serializable)((Object)"localhost"));
        OnmsNode node = new OnmsNode(distPoller);
        node.setLabel("MyFirstNode");
        PathElement p = new PathElement("192.168.7.7", "ICMP");
        node.setPathElement(p);
        this.getNodeDao().save((Object)node);
        OnmsNode myNode = (OnmsNode)this.getNodeDao().get((Serializable)node.getId());
        Assert.assertNotNull((Object)myNode);
        myNode.setPathElement(null);
        this.getNodeDao().save((Object)myNode);
        this.getNodeDao().flush();
    }

    @Test
    @Transactional
    public void testCreate() throws InterruptedException {
        OnmsDistPoller distPoller = this.getDistPoller();
        OnmsNode node = new OnmsNode(distPoller);
        node.setLabel("MyFirstNode");
        node.getAssetRecord().setDisplayCategory("MyCategory");
        PathElement p = new PathElement("192.168.7.7", "ICMP");
        node.setPathElement(p);
        this.getNodeDao().save((Object)node);
        System.out.println("BEFORE GET");
        OnmsDistPoller dp = this.getDistPoller();
        Assert.assertSame((Object)distPoller, (Object)dp);
        System.out.println("AFTER GET");
        List nodes = this.getNodeDao().findNodes(dp);
        Assert.assertEquals((long)7L, (long)nodes.size());
        System.out.println("AFTER GETNODES");
        for (OnmsNode retrieved : nodes) {
            System.out.println("category for " + retrieved.getId() + " = " + retrieved.getAssetRecord().getDisplayCategory());
            if (node.getId() != 5) continue;
            Assert.assertEquals((Object)"MyFirstNode", (Object)retrieved.getLabel());
            Assert.assertEquals((Object)"MyCategory", (Object)retrieved.getAssetRecord().getDisplayCategory());
            Assert.assertEquals((Object)"192.168.7.7", (Object)retrieved.getPathElement().getIpAddress());
        }
        System.out.println("AFTER Loop");
    }

    @Test
    @Transactional
    public void testQuery() throws Exception {
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)this.getNode1().getId());
        this.validateNode(n);
    }

    @Test
    @Transactional
    public void testDeleteOnOrphanIpInterface() {
        int preCount = this.getJdbcTemplate().queryForInt("select count(*) from ipinterface where ipinterface.nodeId = " + this.getNode1().getId());
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)this.getNode1().getId());
        Iterator it = n.getIpInterfaces().iterator();
        it.next();
        it.remove();
        this.getNodeDao().saveOrUpdate((Object)n);
        this.getNodeDao().flush();
        int postCount = this.getJdbcTemplate().queryForInt("select count(*) from ipinterface where ipinterface.nodeId = " + this.getNode1().getId());
        Assert.assertEquals((long)(preCount - 1), (long)postCount);
    }

    @Test
    @Transactional
    public void testDeleteNode() {
        int preCount = this.getJdbcTemplate().queryForInt("select count(*) from node");
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)this.getNode1().getId());
        this.getNodeDao().delete((Object)n);
        this.getNodeDao().flush();
        int postCount = this.getJdbcTemplate().queryForInt("select count(*) from node");
        Assert.assertEquals((long)(preCount - 1), (long)postCount);
    }

    @Test
    @Transactional
    public void testQueryWithHierarchy() throws Exception {
        OnmsNode n = this.getNodeDao().getHierarchy(this.getNode1().getId());
        this.validateNode(n);
    }

    public OnmsNode getNodeHierarchy(final int nodeId) {
        return (OnmsNode)this.m_transTemplate.execute((TransactionCallback)new TransactionCallback<OnmsNode>(){

            public OnmsNode doInTransaction(TransactionStatus status) {
                return NodeDaoTest.this.getNodeDao().getHierarchy(Integer.valueOf(nodeId));
            }
        });
    }

    @Test
    @Transactional
    public void testQueryWithHierarchyCloseTransaction() throws Exception {
        OnmsNode n = this.getNodeHierarchy(this.getNode1().getId());
        this.validateNode(n);
        for (OnmsIpInterface ip : n.getIpInterfaces()) {
            ip.getIpAddress();
            for (OnmsMonitoredService service : ip.getMonitoredServices()) {
                service.getServiceName();
            }
        }
        for (OnmsSnmpInterface snmp : n.getSnmpInterfaces()) {
            for (OnmsIpInterface ip : snmp.getIpInterfaces()) {
                ip.getIpAddress();
            }
        }
    }

    @Test
    @Transactional
    public void testGetForeignIdToNodeIdMap() {
        Map arMap = this.getNodeDao().getForeignIdToNodeIdMap("imported:");
        Assert.assertTrue((String)"Expected to find foriegnId 1", (boolean)arMap.containsKey("1"));
        OnmsNode node1 = (OnmsNode)this.getNodeDao().get((Serializable)arMap.get("1"));
        Assert.assertNotNull((String)"Exepected foreignId to be mapped to a node", (Object)node1);
        Assert.assertEquals((String)"Expected foreignId to be mapped to 'node1'", (Object)"node1", (Object)node1.getLabel());
    }

    @Test
    @Transactional
    public void testUpdateNodeScanStamp() {
        Date timestamp = new Date(27L);
        this.getNodeDao().updateNodeScanStamp(this.getNode1().getId(), timestamp);
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)this.getNode1().getId());
        Assert.assertEquals((Object)timestamp, (Object)n.getLastCapsdPoll());
    }

    @Test
    @Transactional
    public void testFindByForeignSourceAndIpAddress() {
        Assert.assertEquals((long)0L, (long)this.getNodeDao().findByForeignSourceAndIpAddress("NoSuchForeignSource", "192.168.1.1").size());
        Assert.assertEquals((long)0L, (long)this.getNodeDao().findByForeignSourceAndIpAddress("imported:", "192.167.7.7").size());
        Assert.assertEquals((long)1L, (long)this.getNodeDao().findByForeignSourceAndIpAddress("imported:", "192.168.1.1").size());
        Assert.assertEquals((long)1L, (long)this.getNodeDao().findByForeignSourceAndIpAddress(null, "10.1.1.1").size());
        Assert.assertEquals((long)0L, (long)this.getNodeDao().findByForeignSourceAndIpAddress(null, "192.167.7.7").size());
    }

    @Test
    @Transactional
    public void testGetNodeLabelForId() {
        OnmsNode node = this.getNode1();
        String label = this.getNodeDao().getLabelForId(node.getId());
        Assert.assertEquals((Object)label, (Object)node.getLabel());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testDeleteObsoleteInterfaces() {
        this.m_populator.populateDatabase();
        final Date timestamp = new Date(1234L);
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                NodeDaoTest.this.simulateScan(timestamp);
            }
        });
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                NodeDaoTest.this.deleteObsoleteInterfaces(timestamp);
            }
        });
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                NodeDaoTest.this.validateScan();
            }
        });
    }

    private void validateScan() {
        OnmsNode after = (OnmsNode)this.getNodeDao().get((Serializable)this.getNode1().getId());
        Assert.assertEquals((long)1L, (long)after.getIpInterfaces().size());
        Assert.assertEquals((long)1L, (long)after.getSnmpInterfaces().size());
    }

    private void simulateScan(Date timestamp) {
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)this.getNode1().getId());
        Assert.assertEquals((long)4L, (long)n.getIpInterfaces().size());
        Assert.assertEquals((long)4L, (long)n.getSnmpInterfaces().size());
        OnmsIpInterface iface = n.getIpInterfaceByIpAddress("192.168.1.1");
        Assert.assertNotNull((Object)iface);
        iface.setIpLastCapsdPoll(timestamp);
        OnmsSnmpInterface snmpIface = n.getSnmpInterfaceWithIfIndex(1);
        Assert.assertNotNull((Object)snmpIface);
        snmpIface.setLastCapsdPoll(timestamp);
        this.getNodeDao().saveOrUpdate((Object)n);
        this.getNodeDao().flush();
    }

    private void deleteObsoleteInterfaces(Date timestamp) {
        this.getNodeDao().deleteObsoleteInterfaces(this.getNode1().getId(), timestamp);
    }

    private void validateNode(OnmsNode n) throws Exception {
        Assert.assertNotNull((String)"Expected node to be non-null", (Object)n);
        Assert.assertNotNull((String)("Expected node " + n.getId() + " to have interfaces"), (Object)n.getIpInterfaces());
        Assert.assertEquals((String)("Unexpected number of interfaces for node " + n.getId()), (long)4L, (long)n.getIpInterfaces().size());
        Iterator i$ = n.getIpInterfaces().iterator();
        while (i$.hasNext()) {
            OnmsIpInterface o;
            OnmsIpInterface iface = o = (OnmsIpInterface)i$.next();
            Assert.assertNotNull((Object)iface);
            Assert.assertNotNull((Object)InetAddressUtils.str((InetAddress)iface.getIpAddress()));
        }
        NodeDaoTest.assertNodeEquals(this.getNode1(), n);
    }

    private static void assertNodeEquals(OnmsNode expected, OnmsNode actual) throws Exception {
        Assert.assertEquals((String)"Unexpected nodeId", (Object)expected.getId(), (Object)actual.getId());
        String[] properties = new String[]{"id", "label", "labelSource", "assetRecord.assetNumber", "distPoller.name", "sysContact", "sysName", "sysObjectId"};
        NodeDaoTest.assertPropertiesEqual(properties, expected, actual);
        NodeDaoTest.assertInterfaceSetsEqual(expected.getIpInterfaces(), actual.getIpInterfaces());
    }

    private static <T> void assertSetsEqual(Set<T> expectedSet, Set<T> actualSet, String orderProperty, AssertEquals<T> comparer) throws Exception {
        TreeSet<Object> expectedSorted = new TreeSet<Object>(new PropertyComparator(orderProperty));
        expectedSorted.addAll(expectedSet);
        TreeSet<Object> actualSorted = new TreeSet<Object>(new PropertyComparator(orderProperty));
        actualSorted.addAll(actualSet);
        Iterator expected = expectedSorted.iterator();
        Iterator actual = actualSorted.iterator();
        while (expected.hasNext() && actual.hasNext()) {
            comparer.assertEqual(expected.next(), actual.next());
        }
        if (expected.hasNext()) {
            Assert.fail((String)("Missing item " + expected.next() + " in the actual list"));
        }
        if (actual.hasNext()) {
            Assert.fail((String)("Unexpected item " + actual.next() + " in the actual list"));
        }
    }

    private static void assertInterfaceSetsEqual(Set<OnmsIpInterface> expectedSet, Set<OnmsIpInterface> actualSet) throws Exception {
        NodeDaoTest.assertSetsEqual(expectedSet, actualSet, "ipAddress", new AssertEquals<OnmsIpInterface>(){

            @Override
            public void assertEqual(OnmsIpInterface expected, OnmsIpInterface actual) throws Exception {
                NodeDaoTest.assertInterfaceEquals(expected, actual);
            }
        });
    }

    private static void assertInterfaceEquals(OnmsIpInterface expected, OnmsIpInterface actual) throws Exception {
        String[] properties = new String[]{"ipAddress", "ifIndex", "ipHostName", "isManaged", "node.id"};
        NodeDaoTest.assertPropertiesEqual(properties, expected, actual);
        NodeDaoTest.assertServicesEquals(expected.getMonitoredServices(), actual.getMonitoredServices());
    }

    private static void assertServicesEquals(Set<OnmsMonitoredService> expectedSet, Set<OnmsMonitoredService> actualSet) throws Exception {
        NodeDaoTest.assertSetsEqual(expectedSet, actualSet, "serviceId", new AssertEquals<OnmsMonitoredService>(){

            @Override
            public void assertEqual(OnmsMonitoredService expected, OnmsMonitoredService actual) throws Exception {
                NodeDaoTest.assertServiceEquals(expected, actual);
            }
        });
    }

    protected static void assertServiceEquals(OnmsMonitoredService expected, OnmsMonitoredService actual) {
        Assert.assertEquals((Object)expected.getServiceName(), (Object)actual.getServiceName());
    }

    private static void assertPropertiesEqual(String[] properties, Object expected, Object actual) throws Exception {
        for (String property : properties) {
            NodeDaoTest.assertPropertyEquals(property, expected, actual);
        }
    }

    private static void assertPropertyEquals(String name, Object expected, Object actual) throws Exception {
        String expectedValue = BeanUtils.getProperty((Object)expected, (String)name);
        String actualValue = BeanUtils.getProperty((Object)actual, (String)name);
        Assert.assertEquals((String)("Unexpected value for property " + name + " on object " + expected), (Object)expectedValue, (Object)actualValue);
    }

    @Test
    @Transactional
    public void testCB() {
        CriteriaBuilder cb = new CriteriaBuilder(OnmsNode.class);
        cb.alias("assetRecord", "asset").match("any").ilike("label", (Object)"%ode%").ilike("sysDescription", (Object)"%abc%").ilike("asset.comment", (Object)"%xyz%");
        List nodes = this.m_nodeDao.findMatching(cb.toCriteria());
        System.err.println("Nodes found: " + nodes.size());
        Assert.assertEquals((long)6L, (long)nodes.size());
        cb = new CriteriaBuilder(OnmsNode.class);
        cb.alias("assetRecord", "asset").match("any").ilike("label", (Object)"%alt%").ilike("sysDescription", (Object)"%abc%").ilike("asset.comment", (Object)"%xyz%");
        nodes = this.m_nodeDao.findMatching(cb.toCriteria());
        System.err.println("Nodes found: " + nodes.size());
        Assert.assertEquals((long)2L, (long)nodes.size());
    }

    @Test
    @Transactional
    public void testQuery2() {
        Assert.assertNotNull((Object)this.m_populator);
        Assert.assertNotNull((Object)this.m_populator.getNode6());
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)this.m_populator.getNode6().getId());
        Assert.assertNotNull((Object)n);
        Assert.assertEquals((long)3L, (long)n.getIpInterfaces().size());
        Assert.assertNotNull((Object)n.getAssetRecord());
        Assert.assertEquals((Object)"category1", (Object)n.getAssetRecord().getDisplayCategory());
    }

    private OnmsDistPoller getDistPoller() {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost"));
        Assert.assertNotNull((Object)distPoller);
        return distPoller;
    }

    private static interface AssertEquals<T> {
        public void assertEqual(T var1, T var2) throws Exception;
    }

    private static class PropertyComparator
    implements Comparator<Object> {
        String m_propertyName;

        public PropertyComparator(String propertyName) {
            this.m_propertyName = propertyName;
        }

        @Override
        public int compare(Object o1, Object o2) {
            try {
                String expectedValue = "" + BeanUtils.getProperty((Object)o1, (String)this.m_propertyName);
                String actualValue = "" + BeanUtils.getProperty((Object)o2, (String)this.m_propertyName);
                return expectedValue.compareTo(actualValue);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Unable to compare property " + this.m_propertyName, e);
            }
        }
    }
}

