/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.config.DefaultDataCollectionConfigDao;
import org.opennms.netmgt.config.datacollection.DatacollectionConfig;
import org.opennms.netmgt.config.datacollection.Group;
import org.opennms.netmgt.config.datacollection.MibObj;
import org.opennms.netmgt.config.datacollection.SnmpCollection;
import org.opennms.netmgt.config.datacollection.SystemDef;
import org.opennms.netmgt.model.RrdRepository;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class DefaultDataCollectionConfigDaoTest {
    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
        System.setProperty("opennms.home", "src/test/opennms-home");
        ConfigurationTestUtils.setRelativeHomeDirectory((String)"src/test/opennms-home");
    }

    @After
    public void tearDown() {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testNewStyle() throws Exception {
        DefaultDataCollectionConfigDao dao = this.instantiateDao("datacollection-config.xml", true);
        this.executeTests(dao);
    }

    @Test
    public void testOldStyle() throws Exception {
        DefaultDataCollectionConfigDao oldDao = this.instantiateDao("examples/old-datacollection-config.xml", false);
        this.executeTests(oldDao);
    }

    @Test
    public void testCompareOldAndNewStyles() throws Exception {
        DefaultDataCollectionConfigDao newDao = this.instantiateDao("datacollection-config.xml", true);
        DefaultDataCollectionConfigDao oldDao = this.instantiateDao("examples/old-datacollection-config.xml", false);
        this.compareContent((DatacollectionConfig)oldDao.getContainer().getObject(), (DatacollectionConfig)newDao.getContainer().getObject());
    }

    @Test
    @Ignore
    public void testLoadTimeOfDao() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.instantiateDao("datacollection-config.xml", true);
        }
    }

    private void executeTests(DefaultDataCollectionConfigDao dao) {
        int netsnmpObjectsCount = 197;
        int ciscoObjectsCount = 44;
        int resourceTypesCount = 88;
        int systemDefCount = 141;
        this.executeRepositoryTest(dao);
        this.executeMibObjectsTest(dao, ".1.3.6.1.4.1.8072.3.2.255", netsnmpObjectsCount);
        this.executeMibObjectsTest(dao, ".1.3.6.1.4.1.9.1.222", ciscoObjectsCount);
        this.executeResourceTypesTest(dao, resourceTypesCount);
        this.executeSystemDefCount(dao, systemDefCount);
    }

    private void executeRepositoryTest(DefaultDataCollectionConfigDao dao) {
        Assert.assertEquals((Object)"select", (Object)dao.getSnmpStorageFlag("default"));
        RrdRepository repository = dao.getRrdRepository("default");
        Assert.assertNotNull((Object)repository);
        Assert.assertEquals((long)300L, (long)repository.getStep());
        Assert.assertEquals((long)repository.getStep(), (long)dao.getStep("default"));
        List rras = dao.getRRAList("default");
        Assert.assertEquals((long)repository.getRraList().size(), (long)rras.size());
    }

    private DefaultDataCollectionConfigDao instantiateDao(String fileName, boolean setConfigDirectory) throws Exception {
        DefaultDataCollectionConfigDao dao = new DefaultDataCollectionConfigDao();
        File configFile = new File("src/test/opennms-home/etc", fileName);
        if (setConfigDirectory) {
            File configFolder = new File(configFile.getParentFile(), "datacollection");
            Assert.assertTrue((boolean)configFolder.isDirectory());
            dao.setConfigDirectory(configFolder.getAbsolutePath());
        }
        dao.setConfigResource((Resource)new InputStreamResource((InputStream)new FileInputStream(configFile)));
        dao.afterPropertiesSet();
        return dao;
    }

    private void executeSystemDefCount(DefaultDataCollectionConfigDao dao, int expectedCount) {
        DatacollectionConfig config = (DatacollectionConfig)dao.getContainer().getObject();
        int systemDefCount = 0;
        for (SnmpCollection collection : config.getSnmpCollections()) {
            systemDefCount += collection.getSystems().getSystemDefs().size();
        }
        Assert.assertEquals((long)expectedCount, (long)systemDefCount);
    }

    private void executeResourceTypesTest(DefaultDataCollectionConfigDao dao, int expectedCount) {
        Map resourceTypesMap = dao.getConfiguredResourceTypes();
        Assert.assertNotNull((Object)resourceTypesMap);
        Assert.assertEquals((long)expectedCount, (long)resourceTypesMap.size());
        Assert.assertTrue((boolean)resourceTypesMap.containsKey("frCircuitIfIndex"));
        Assert.assertTrue((boolean)resourceTypesMap.containsKey("wmiTcpipNetworkInterface"));
        Assert.assertTrue((boolean)resourceTypesMap.containsKey("xmpFilesys"));
    }

    private void executeMibObjectsTest(DefaultDataCollectionConfigDao dao, String systemOid, int expectedCount) {
        List mibObjects = dao.getMibObjectList("default", systemOid, "127.0.0.1", -1);
        Assert.assertNotNull((Object)mibObjects);
        Assert.assertEquals((long)expectedCount, (long)mibObjects.size());
    }

    private void compareContent(DatacollectionConfig refObj, DatacollectionConfig newObj) {
        String i;
        HashSet<String> resourceTypes = new HashSet<String>();
        HashSet<String> systemDefs = new HashSet<String>();
        HashSet<String> groups = new HashSet<String>();
        for (SnmpCollection collection : refObj.getSnmpCollections()) {
            for (SystemDef sd : collection.getSystems().getSystemDefs()) {
                systemDefs.add(sd.getName());
                for (String group : sd.getCollect().getIncludeGroups()) {
                    groups.add(group);
                }
            }
            for (Group g : collection.getGroups().getGroups()) {
                if (!groups.contains(g.getName())) continue;
                for (MibObj mo : g.getMibObjs()) {
                    i = mo.getInstance();
                    if (i.matches("\\d+") || i.equals("ifIndex")) continue;
                    resourceTypes.add(mo.getInstance());
                }
            }
        }
        for (SnmpCollection collection : newObj.getSnmpCollections()) {
            for (Group g : collection.getGroups().getGroups()) {
                for (MibObj mo : g.getMibObjs()) {
                    i = mo.getInstance();
                    if (i.matches("\\d+") || i.equals("ifIndex")) continue;
                    resourceTypes.remove(mo.getInstance());
                }
            }
            for (SystemDef sd : collection.getSystems().getSystemDefs()) {
                systemDefs.remove(sd.getName());
                for (String group : sd.getCollect().getIncludeGroups()) {
                    groups.remove(group);
                }
            }
        }
        if (systemDefs.size() > 0) {
            Assert.fail((String)("There are un-configured system definitions on the new datacollection: " + systemDefs));
        }
        if (groups.size() > 0) {
            Assert.fail((String)("There are un-configured groups on the new datacollection: " + groups));
        }
        if (resourceTypes.size() > 0) {
            Assert.fail((String)("There are un-configured resourceTypes on the new datacollection: " + resourceTypes));
        }
    }
}

