/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.AssetRecordDao;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class AssetRecordDaoTest
implements InitializingBean {
    @Autowired
    private DistPollerDao m_distPollerDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private AssetRecordDao m_assetRecordDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;
    private static boolean m_populated = false;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeTransaction
    public void setUp() {
        try {
            if (!m_populated) {
                this.m_databasePopulator.populateDatabase();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        finally {
            m_populated = true;
        }
    }

    @Test
    @Transactional
    public void testCreateAndGets() {
        OnmsNode onmsNode = new OnmsNode((OnmsDistPoller)this.m_distPollerDao.load((Serializable)((Object)"localhost")));
        onmsNode.setLabel("myNode");
        this.m_nodeDao.save((Object)onmsNode);
        OnmsAssetRecord assetRecord = onmsNode.getAssetRecord();
        assetRecord.setAssetNumber("imported-id: 7");
        this.m_assetRecordDao.update((Object)assetRecord);
        this.m_assetRecordDao.flush();
        List assetRecords = this.m_assetRecordDao.findAll();
        Assert.assertEquals((long)7L, (long)assetRecords.size());
        Assert.assertEquals((long)7L, (long)this.m_assetRecordDao.countAll());
    }

    @Test
    @Transactional
    public void testAddUserName() {
        OnmsNode onmsNode = new OnmsNode((OnmsDistPoller)this.m_distPollerDao.load((Serializable)((Object)"localhost")));
        onmsNode.setLabel("myNode");
        this.m_nodeDao.save((Object)onmsNode);
        OnmsAssetRecord assetRecord = onmsNode.getAssetRecord();
        assetRecord.setAssetNumber("imported-id: 7");
        assetRecord.setUsername("antonio");
        assetRecord.setPassword("password");
        assetRecord.setEnable("cisco");
        assetRecord.setConnection("telnet");
        this.m_assetRecordDao.update((Object)assetRecord);
        this.m_assetRecordDao.flush();
        int id = assetRecord.getId();
        OnmsAssetRecord assetRecordFromDb = (OnmsAssetRecord)this.m_assetRecordDao.get((Serializable)Integer.valueOf(id));
        Assert.assertEquals((Object)assetRecord.getUsername(), (Object)assetRecordFromDb.getUsername());
        Assert.assertEquals((Object)assetRecord.getPassword(), (Object)assetRecordFromDb.getPassword());
        Assert.assertEquals((Object)assetRecord.getEnable(), (Object)assetRecordFromDb.getEnable());
        Assert.assertEquals((Object)assetRecord.getConnection(), (Object)assetRecordFromDb.getConnection());
    }

    @Test
    @Transactional
    public void testAddAutoenable() {
        OnmsNode onmsNode = new OnmsNode((OnmsDistPoller)this.m_distPollerDao.load((Serializable)((Object)"localhost")));
        onmsNode.setLabel("myNode");
        this.m_nodeDao.save((Object)onmsNode);
        OnmsAssetRecord assetRecord = onmsNode.getAssetRecord();
        assetRecord.setAssetNumber("imported-id: 7");
        assetRecord.setUsername("antonio");
        assetRecord.setPassword("password");
        assetRecord.setAutoenable("A");
        assetRecord.setConnection("telnet");
        this.m_assetRecordDao.update((Object)assetRecord);
        this.m_assetRecordDao.flush();
        int id = assetRecord.getId();
        OnmsAssetRecord assetRecordFromDb = (OnmsAssetRecord)this.m_assetRecordDao.get((Serializable)Integer.valueOf(id));
        Assert.assertEquals((Object)assetRecord.getUsername(), (Object)assetRecordFromDb.getUsername());
        Assert.assertEquals((Object)assetRecord.getPassword(), (Object)assetRecordFromDb.getPassword());
        Assert.assertEquals((Object)assetRecord.getAutoenable(), (Object)assetRecordFromDb.getAutoenable());
        Assert.assertEquals((Object)assetRecord.getConnection(), (Object)assetRecordFromDb.getConnection());
    }

    @Test
    @Transactional
    public void testFindByNodeId() {
        OnmsNode onmsNode = new OnmsNode((OnmsDistPoller)this.m_distPollerDao.load((Serializable)((Object)"localhost")));
        onmsNode.setLabel("myNode");
        this.m_nodeDao.save((Object)onmsNode);
        OnmsAssetRecord assetRecord = onmsNode.getAssetRecord();
        assetRecord.setAssetNumber("imported-id: 7");
        this.m_assetRecordDao.update((Object)assetRecord);
        this.m_assetRecordDao.flush();
        OnmsAssetRecord a = this.m_assetRecordDao.findByNodeId(onmsNode.getId());
        Assert.assertTrue((boolean)a.equals((Object)assetRecord));
    }

    @Test
    @Transactional
    public void testGeolocation() {
        OnmsNode onmsNode = new OnmsNode((OnmsDistPoller)this.m_distPollerDao.load((Serializable)((Object)"localhost")));
        onmsNode.setLabel("myNode");
        this.m_nodeDao.save((Object)onmsNode);
        OnmsAssetRecord assetRecord = onmsNode.getAssetRecord();
        OnmsGeolocation geo = assetRecord.getGeolocation();
        if (geo == null) {
            geo = new OnmsGeolocation();
            assetRecord.setGeolocation(geo);
        }
        geo.setAddress1("220 Chatham Business Drive");
        geo.setCity("Pittsboro");
        geo.setState("NC");
        geo.setZip("27312");
        geo.setCountry("US");
        this.m_assetRecordDao.update((Object)assetRecord);
        this.m_assetRecordDao.flush();
        int id = assetRecord.getId();
        OnmsAssetRecord assetRecordFromDb = (OnmsAssetRecord)this.m_assetRecordDao.get((Serializable)Integer.valueOf(id));
        Assert.assertNotNull((Object)assetRecordFromDb.getGeolocation());
        Assert.assertEquals((Object)geo.getAddress1(), (Object)assetRecordFromDb.getGeolocation().getAddress1());
        Assert.assertEquals((Object)geo.getCity(), (Object)assetRecordFromDb.getGeolocation().getCity());
        Assert.assertEquals((Object)geo.getState(), (Object)assetRecordFromDb.getGeolocation().getState());
        Assert.assertEquals((Object)geo.getZip(), (Object)assetRecordFromDb.getGeolocation().getZip());
        Assert.assertEquals((Object)geo.getCountry(), (Object)assetRecordFromDb.getGeolocation().getCountry());
    }
}

