/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db.columnchanges;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.dao.db.ColumnChange;
import org.opennms.netmgt.dao.db.ColumnChangeReplacement;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AutoIntegerIdMapStoreReplacement
implements ColumnChangeReplacement {
    private int m_value;
    private final String[] m_indexColumns;
    private final Map<MultiColumnKey, Integer> m_idMap = new HashMap<MultiColumnKey, Integer>();

    public AutoIntegerIdMapStoreReplacement(int initialValue, String[] indexColumns) {
        this.m_value = initialValue;
        this.m_indexColumns = indexColumns;
    }

    @Override
    public Integer getColumnReplacement(ResultSet rs, Map<String, ColumnChange> columnChanges) throws SQLException {
        MultiColumnKey key = this.getKeyForColumns(rs, columnChanges, this.m_indexColumns);
        Integer newInteger = this.m_value++;
        this.m_idMap.put(key, newInteger);
        return newInteger;
    }

    @Override
    public boolean addColumnIfColumnIsNew() {
        return true;
    }

    public Integer getIntegerForColumns(ResultSet rs, Map<String, ColumnChange> columnChanges, String[] columns, boolean noMatchOkay) throws SQLException {
        MultiColumnKey key = this.getKeyForColumns(rs, columnChanges, columns);
        Integer oldInteger = this.m_idMap.get(key);
        Assert.isTrue((oldInteger != null || noMatchOkay ? 1 : 0) != 0, (String)("No entry in the map for " + key));
        return oldInteger;
    }

    private MultiColumnKey getKeyForColumns(ResultSet rs, Map<String, ColumnChange> columnChanges, String[] columns) throws SQLException {
        Object[] objects = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            String indexColumn = columns[i];
            ColumnChange columnChange = columnChanges.get(indexColumn);
            Assert.notNull((Object)columnChange, (String)("No ColumnChange entry for '" + indexColumn + "'"));
            int index = columnChange.getSelectIndex();
            Assert.isTrue((index > 0 ? 1 : 0) != 0, (String)("ColumnChange entry for '" + indexColumn + "' has no select index"));
            objects[i] = rs.getObject(index);
        }
        return new MultiColumnKey(objects);
    }

    @Override
    public void close() {
    }

    public class MultiColumnKey {
        private final Object[] m_keys;

        public MultiColumnKey(Object[] keys) {
            this.m_keys = keys;
        }

        public boolean equals(Object otherObject) {
            if (!(otherObject instanceof MultiColumnKey)) {
                return false;
            }
            MultiColumnKey other = (MultiColumnKey)otherObject;
            if (this.m_keys.length != other.m_keys.length) {
                return false;
            }
            for (int i = 0; i < this.m_keys.length; ++i) {
                if (this.m_keys[i] == null && other.m_keys[i] == null) continue;
                if (this.m_keys[i] == null || other.m_keys[i] == null) {
                    return false;
                }
                if (this.m_keys[i].equals(other.m_keys[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return StringUtils.arrayToDelimitedString((Object[])this.m_keys, (String)", ");
        }

        public int hashCode() {
            int value = 1;
            for (Object o : this.m_keys) {
                if (o == null) continue;
                value = o.hashCode() ^ value;
            }
            return value;
        }
    }
}

