/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.siteStatusViews.View;
import org.opennms.netmgt.config.siteStatusViews.Views;
import org.opennms.netmgt.dao.SiteStatusViewConfigDao;
import org.opennms.netmgt.dao.castor.SiteStatusViewsFactory;
import org.springframework.dao.DataRetrievalFailureException;

public class DefaultSiteStatusViewConfigDao
implements SiteStatusViewConfigDao {
    @Override
    public View getView(String viewName) {
        try {
            return SiteStatusViewsFactory.getInstance().getView(viewName);
        }
        catch (MarshalException e) {
            throw new DataRetrievalFailureException("Syntax error in site status view config file", (Throwable)e);
        }
        catch (ValidationException e) {
            throw new DataRetrievalFailureException("Syntax error in site status view config file", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataRetrievalFailureException("Error load site status view config file", (Throwable)e);
        }
    }

    @Override
    public Views getViews() {
        return SiteStatusViewsFactory.getConfig().getViews();
    }

    public Map<String, View> getViewMap() {
        return SiteStatusViewsFactory.getViewsMap();
    }

    @Override
    public View getDefaultView() {
        String defaultView = SiteStatusViewsFactory.getConfig().getDefaultView();
        return this.getView(defaultView);
    }

    static {
        try {
            SiteStatusViewsFactory.init();
        }
        catch (MarshalException e) {
            throw new DataRetrievalFailureException("Syntax error in site status view config file", (Throwable)e);
        }
        catch (ValidationException e) {
            throw new DataRetrievalFailureException("Syntax error in site status view config file", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new DataRetrievalFailureException("Unable to locate site status view config file", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataRetrievalFailureException("Error load site status view config file", (Throwable)e);
        }
    }
}

