/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.BaseConnectionFactory;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import snaq.db.DBPoolDataSource;

public class DBPoolConnectionFactory
extends BaseConnectionFactory {
    private DBPoolDataSource m_dataSource;

    public DBPoolConnectionFactory(InputStream stream, String dsName) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        super(stream, dsName);
    }

    public DBPoolConnectionFactory(String configFile, String dsName) throws IOException, MarshalException, ValidationException, PropertyVetoException, SQLException {
        super(configFile, dsName);
    }

    @Override
    protected void initializePool(JdbcDataSource dataSource) throws SQLException {
        this.m_dataSource = new DBPoolDataSource();
        this.m_dataSource.setName(dataSource.getName());
        this.m_dataSource.setDriverClassName(dataSource.getClassName());
        this.m_dataSource.setUrl(dataSource.getUrl());
        this.m_dataSource.setUser(dataSource.getUserName());
        this.m_dataSource.setPassword(dataSource.getPassword());
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_dataSource.getConnection();
    }

    @Override
    public String getUrl() {
        return this.m_dataSource.getUrl();
    }

    @Override
    public void setUrl(String url) {
        this.m_dataSource.setUrl(url);
    }

    @Override
    public String getUser() {
        return this.m_dataSource.getUser();
    }

    @Override
    public void setUser(String user) {
        this.m_dataSource.setUser(user);
    }

    @Override
    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.m_dataSource.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_dataSource.getLoginTimeout();
    }

    @Override
    public void close() throws SQLException {
        super.close();
        LogUtils.infof((Object)this, (String)"Closing DBPool pool.", (Object[])new Object[0]);
        this.m_dataSource.release();
    }

    @Override
    public void setIdleTimeout(int idleTimeout) {
        this.m_dataSource.setIdleTimeout(idleTimeout);
    }

    @Override
    public void setMinPool(int minPool) {
        this.m_dataSource.setMinPool(minPool);
    }

    @Override
    public void setMaxPool(int maxPool) {
        this.m_dataSource.setMaxPool(maxPool);
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.m_dataSource.setMaxSize(maxSize);
    }
}

